﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品关联分销佣金仓储层
    /// </summary>
    public class RB_Goods_DistributionCommissionRepository : RepositoryBase<RB_Goods_DistributionCommission>
    {

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_DistributionCommission_Extend> GetList(RB_Goods_DistributionCommission_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Goods_DistributionCommission.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Goods_DistributionCommission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Goods_SpecificationPrice.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Goods_DistributionCommission.Id)}={dmodel.Id}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and {nameof(RB_Goods_DistributionCommission.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and {nameof(RB_Goods_DistributionCommission.GoodsId)} in({dmodel.GoodsIds})";
            }
            
            string sql = $@"select * from RB_Goods_DistributionCommission where {where} order by Id desc";
            return Get<RB_Goods_DistributionCommission_Extend>(sql).ToList();
        }
    }
}
