﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;
namespace Mall.Repository.User
{
    /// <summary>
    /// 底部导航标签仓储层
    /// </summary>
    public class RB_Miniprogram_BottomnavRepository : RepositoryBase<RB_Miniprogram_Bottomnav>
    {
        /// <summary>
        /// 根据查询条件获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Bottomnav_Extend> GetListRepository(RB_Miniprogram_Bottomnav_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_Miniprogram_Bottomnav WHERE 1=1 AND Status=0 ");
            if (query != null)
            {
                if (query.TenantId != null && query.TenantId > 0)
                {
                    builder.AppendFormat(" AND TenantId={0} ", query.TenantId);
                }
                if (query.MallBaseId != null && query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND MallBaseId={0} ", query.MallBaseId);
                }
            }
            builder.Append(" ORDER BY TagSort ");
            return Get<RB_Miniprogram_Bottomnav_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 删除底部导航
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool DeleteBottomnavRepository(string Ids)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat("DELETE FROM RB_Miniprogram_Bottomnav WHERE 1=1 AND TagId IN({0}) ", Ids);
            return base.Execute(builder.ToString()) > 0;
        }
    }
}
