﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Xml.Linq;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Pay.WeChatPat;
using Mall.Common.Pay.WeChatPat.Model;
using Mall.Common.Plugin;
using Mall.Model.Extend.Product;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Mall.WeChat.Helper;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.AppletWeChat
{

    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class WeChatPayController : BaseController
    {
        private IHttpContextAccessor _accessor;

        /// <summary>
        /// 构造函数
        /// </summary>
        /// <param name="accessor"></param>
        public WeChatPayController(IHttpContextAccessor accessor)
        {
            _accessor = accessor;
        }

        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();
        private readonly UserModule userModule = new UserModule();
        /// <summary>
        /// 微信支付
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public ApiResult GetPayInfo()
        {
            var request = RequestParm;
            var userInfo = AppletUserInfo;


            var userModel = userModule.GetMemberUserInfo(21233);

            if (userInfo == null)
            {
                userInfo = new Common.AppletUserInfo();
                userInfo.TenantId = userModel.TenantId;
                userInfo.MallBaseId = userModel.MallBaseId;
                userInfo.UserId = userModel.Id;
            }
            RB_Goods_Order_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_Order_Extend>(request.msg.ToString());
            string sPayInfo = string.Empty;
            if (!demodel.OrderPayType.HasValue)
            {
                return ApiResult.Failed("请选择支付方式！");
            }
            var model = new Module.Product.OrderModule().GetOrderInfo(demodel.OrderId);
            if (model == null)
            {
                return ApiResult.Failed("订单信息不存在！");
            }

            if (model.OrderStatus == Common.Enum.Goods.OrderStatusEnum.Cancel)
            {
                return ApiResult.Failed("订单已取消");
            }
            if ((int)model.OrderStatus > 1)
            {
                return ApiResult.Failed("订单已支付");

            }
            string sOrderNo = (System.DateTime.Now.ToString("yyyyMMddHHmmssfff")) + model.OrderId;
            //根据订单号获取微信支付配置信息
            RB_MiniProgram_Extend miniProgram = new RB_MiniProgram_Extend();  //2020年5月26号新增
            miniProgram = programModule.GetMiniProgramModule(new RB_MiniProgram_Extend { MallBaseId = userInfo.MallBaseId, TenantId = userInfo.TenantId });
            App_Code.PayUtil payUtil = new App_Code.PayUtil();
            switch ((int)demodel.OrderPayType)
            {
                case 1://微信支付    
                    sPayInfo = GetMinUnifiedOrder(sOrderNo, demodel.GoodsName, model.Income.Value, model.UserId.ToString(), demodel.OpenId, miniProgram);
                    break;
                default:
                    break;
            }
            return ApiResult.Success("", sPayInfo);
        }




        /// <summary>
        /// 微信小程序支付
        /// </summary>
        /// <param name="sOrderNo"></param>
        /// <param name="sProductName"></param>
        /// <param name="dPrice"></param>
        /// <param name="CustomerId"></param>
        /// <param name="openid"></param>
        /// <returns></returns>
        private string GetMinUnifiedOrder(string sOrderNo, string sProductName, decimal dPrice, string CustomerId, string openid, RB_MiniProgram_Extend model)
        {
            App_Code.PayUtil payUtil = new App_Code.PayUtil();
            var req = new Common.Pay.WeChatPat.RequestHandler();
            req.SetKey(model.WeChatApiSecret);
            //
            req.SetParameter("appid", model.MiniAppId);//微信开放平台审核通过的应用APPID
            req.SetParameter("mch_id", model.WeChatPayMerchants);//微信支付分配的商户号
            req.SetParameter("nonce_str", payUtil.GetNoncestr());//随机字符串，不长于32位
            req.SetParameter("body", sProductName);
            req.SetParameter("attach", CustomerId);
            req.SetParameter("out_trade_no", sOrderNo);
            req.SetParameter("total_fee", (dPrice * 100).ToString("f0"));
            req.SetParameter("spbill_create_ip", _accessor.HttpContext.Connection.RemoteIpAddress.ToString());
            req.SetParameter("time_start", DateTime.Now.ToString("yyyyMMddHHmmss"));
            req.SetParameter("time_expire", DateTime.Now.AddMinutes(10).ToString("yyyyMMddHHmmss"));
            req.SetParameter("notify_url", Config.sTenpayNotify);
            req.SetParameter("trade_type", "JSAPI");
            req.SetParameter("openid", openid);
            req.SetParameter("sign", req.CreateMd5Sign(_accessor));

            var reqXml = req.ParseXml();
            var result = Common.Pay.WeChatPat.HttpHelper.Post(new HttpParam()
            {
                Url = Mall.Common.Pay.WeChatPat.Model.ApiList.UnifiedOrderUrl,
                PostParam = reqXml,
                Encoding = Common.Pay.WeChatPat.HttpHelper.GetRequestEncoding(_accessor.HttpContext.Request),
                //  Encoding = HttpContext.Current.Request.ContentEncoding
            });

            var xe = XElement.Parse(result, LoadOptions.SetLineInfo);
            LogHelper.Write(null, "订单号【" + sOrderNo + "】支付错误：" + xe);
            try
            {

                var prepayId = xe.GetElement("return_code").Value;
                var payReq = new RequestHandler();
                payReq.SetParameter("appId", model.MiniAppId);
         
                //创建签名
                payReq.SetParameter("sign", payReq.CreateMd5Sign(_accessor));
                var payReqXml = payReq.ParseXml();
                var payReqJson = payReq.ParseJson();
                return payReqJson;
            }
            catch (Exception)
            {
                var returnCode = xe.GetElement("return_code").Value;
                var returnMsg = xe.GetElement("return_msg").Value;
                return "{Error:'" + returnCode + returnMsg + "'}";
            }
        }






        /// <summary>
        /// 企业付款
        /// </summary>
        /// <param name="sOrderNo"></param>
        /// <param name="sProductName"></param>
        /// <param name="dPrice"></param>
        /// <param name="CustomerId"></param>
        /// <param name="openid"></param>
        /// <returns></returns>
        private string GetTransfersOrder(string sOrderNo, string sProductName, decimal dPrice, string CustomerId, string openid, RB_MiniProgram_Extend model)
        {
            App_Code.PayUtil payUtil = new App_Code.PayUtil();
            var req = new Common.Pay.WeChatPat.RequestHandler();
            req.SetKey(model.WeChatApiSecret);
            //
            req.SetParameter("mch_appid", model.MiniAppId);//微信开放平台审核通过的应用APPID
            req.SetParameter("mchid", model.WeChatPayMerchants);//微信支付分配的商户号
            req.SetParameter("nonce_str", payUtil.GetNoncestr());//随机字符串，不长于32位
            req.SetParameter("sign", req.CreateMd5Sign(_accessor));
            req.SetParameter("partner_trade_no", sProductName);//商户订单号，需保持唯一性(只能是字母或者数字，不能包含有其它字符)
            req.SetParameter("openid", openid);
            req.SetParameter("check_name", "NO_CHECK");
            req.SetParameter("out_trade_no", sOrderNo);
            req.SetParameter("amount", (dPrice * 100).ToString("f0"));
            req.SetParameter("spbill_create_ip", _accessor.HttpContext.Connection.RemoteIpAddress.ToString());
            req.SetParameter("time_start", DateTime.Now.ToString("yyyyMMddHHmmss"));
            req.SetParameter("time_expire", DateTime.Now.AddMinutes(10).ToString("yyyyMMddHHmmss"));
            req.SetParameter("desc", "赞羊商城佣金提现");
            req.SetParameter("trade_type", "JSAPI");
         
           

            var reqXml = req.ParseXml();
            var result = Common.Pay.WeChatPat.HttpHelper.Post(new HttpParam()
            {
                Url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers",
                PostParam = reqXml,
                Encoding = Common.Pay.WeChatPat.HttpHelper.GetRequestEncoding(_accessor.HttpContext.Request),
                CertPath = model.WeChatPayCertificateUrl, 
                CertPwd = model.WeChatApiSecret
            });

            var xe = XElement.Parse(result, LoadOptions.SetLineInfo);
            LogHelper.Write(null, "订单号【" + sOrderNo + "】支付错误：" + xe);
            try
            {

                var prepayId = xe.GetElement("prepay_id").Value;
                var payReq = new RequestHandler();
                payReq.SetKey(model.WeChatApiSecret);
                payReq.SetParameter("appId", model.MiniAppId);
                // req.SetParameter("mch_id", EheMall.WeChat.Common.WeChatConfig.GetOpenMchID());//微信支付分配的商户号
                payReq.SetParameter("timeStamp", payUtil.GetTimestamp());
                payReq.SetParameter("nonceStr", payUtil.GetNoncestr());
                payReq.SetParameter("package", "prepay_id=" + prepayId);
                payReq.SetParameter("signType", "MD5");
                //创建签名
                payReq.SetParameter("sign", payReq.CreateMd5Sign(_accessor));
                var payReqXml = payReq.ParseXml();
                var payReqJson = payReq.ParseJson();
                return payReqJson;
            }
            catch (Exception)
            {
                var returnCode = xe.GetElement("return_code").Value;
                var returnMsg = xe.GetElement("return_msg").Value;
                return "{Error:'" + returnCode + returnMsg + "'}";
            }
        }


    }
}