﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品评论模板仓储层
    /// </summary>
    public class RB_Goods_CommentTemplateRepository : BaseRepository<RB_Goods_CommentTemplate>
    {

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_CommentTemplate_Extend> GetPageList(int pageIndex, int pageSize, out long count, RB_Goods_CommentTemplate_Extend dmodel)
        {
            string where = $" 1=1 and Status =0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_CommentTemplate.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_CommentTemplate.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Goods_CommentTemplate.Id)}={dmodel.Id}";
            }
            if (dmodel.CommentGrade > 0)
            {
                where += $@" and {nameof(RB_Goods_CommentTemplate.CommentGrade)}={(int)dmodel.CommentGrade}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Goods_CommentTemplate.Name)} like '%{dmodel.Name}%'";
            }

            string sql = $@"SELECT * FROM RB_Goods_CommentTemplate where {where} order by Id desc";
            return GetPage<RB_Goods_CommentTemplate_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
