﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Microsoft.AspNetCore.Authorization;
using Mall.Model.Entity.User;
using Mall.AOP;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MContentController : BaseController
    {
        /// <summary>
        /// 内容管理
        /// </summary>
        private Module.User.ContentModule contentModule = new ContentModule();

        /// <summary>
        /// 菜单处理类
        /// </summary>
        private Module.User.MenuModule menuModule = new Module.User.MenuModule();

        /// <summary>
        /// 商户菜单处理类
        /// </summary>
        private Module.User.TenantMenuModule tenantMenuModule = AOPHelper.CreateAOPObject<TenantMenuModule>();

        #region 专题分类

        /// <summary>
        /// 专题分类分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicTypePageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Topic_Type_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetTopicTypePageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取专题分类列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicTypeList()
        {
            var query = JsonConvert.DeserializeObject<RB_Topic_Type_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetTopicTypeListModule( query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改专题分类
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTopicType()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Topic_Type_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetTopicTypeModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取专题分类实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetTopicTypeModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除专题分类
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveTopicType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveTopicTypeModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新专题分类状态
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateTopicTypeStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var IsDisable = parms.GetInt("IsDisable");
            var flag = contentModule.UpdateTopicTypeStatusModule(Id, IsDisable);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 专题

        /// <summary>
        /// 专题分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Topic_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetTopicPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取专题列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicList()
        {
            var query = JsonConvert.DeserializeObject<RB_Topic_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetTopicListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改专题
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTopic()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Topic_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            if (extModel.ComponentDataList != null && extModel.ComponentDataList.Count > 0)
            {
                extModel.TemplateData = JsonConvert.SerializeObject(extModel.ComponentDataList);
            }
            var flag = contentModule.SetTopicModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取专题实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopic()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetTopicModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除专题
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveTopic()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveTopicModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 门店

        /// <summary>
        /// 门店分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetStoresPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Stores_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetStoresPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 门店分类列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetStoresList()
        {
            var query = JsonConvert.DeserializeObject<RB_Stores_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetStoresListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改门店
        /// </summary>
        /// <returns></returns>
        public ApiResult SetStores()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Stores_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetStoresModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取门店实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetStores()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetStoresModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除门店
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveStores()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveStoresModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 视频

        /// <summary>
        /// 视频分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetVideoPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Video_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetVideoPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取视频列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetVideoList()
        {
            var query = JsonConvert.DeserializeObject<RB_Video_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetVideoListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改视频
        /// </summary>
        /// <returns></returns>
        public ApiResult SetVideo()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Video_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetVideoModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取视频实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetVideo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetVideoModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除视频
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveVideo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveVideoModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 文章

        /// <summary>
        /// 文章分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetArticlePageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Article_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetArticlePageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取文章列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetArticleList()
        {
            var query = JsonConvert.DeserializeObject<RB_Article_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetArticleListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改文章
        /// </summary>
        /// <returns></returns>
        public ApiResult SetArticle()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Article_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetArticleModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取文章实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetArticle()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetArticleModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除文章
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveArticle()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveArticleModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新文章状态
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateArticleStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var IsDisable = parms.GetInt("IsDisable");
            var flag = contentModule.UpdateArticleIsDisableModule(Id, IsDisable);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 商城菜单

        /// <summary>
        /// 获取小程序分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetTenantMenu()
        {
            var list = JsonConvert.DeserializeObject<List<RB_Tenant_Menu_Extend>>(RequestParm.msg.ToString());
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    item.TenantId = RequestParm.TenantId;
                }
            }
            var flag = tenantMenuModule.SetTenantMenuModule(list);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商户菜单列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetTenantMenuList()
        {
            List<object> result = new List<object>();
            var menuList = menuModule.GetMenuListModule(new RB_Menu_Extend());
            if (menuList != null && menuList.Count > 0)
            {
                var tenantMenuList = tenantMenuModule.GetTenantMenuListModule(new RB_Tenant_Menu_Extend() { TenantId = RequestParm.TenantId });
                foreach (var item in menuList.Where(qitem => qitem.MenuLevel == 1))
                {
                    List<object> secondList = new List<object>();
                    foreach (var subItem in menuList.Where(qitem => qitem.MenuLevel == 2 && qitem.ParentId == item.MenuId))
                    {
                        List<object> childList = new List<object>();
                        foreach (var thirdItem in menuList.Where(qitem => qitem.MenuLevel == 3 && qitem.ParentId == subItem.MenuId))
                        {
                            childList.Add(new
                            {
                                thirdItem.MenuId,
                                thirdItem.MenuName,
                                thirdItem.ParentId,
                                IsChecked = tenantMenuList?.Where(qitem => qitem.MenuId == thirdItem.MenuId)?.Count() > 0,
                                SubMenuList =new List<string>()
                            });
                        }
                        secondList.Add(new
                        {
                            subItem.MenuId,
                            subItem.MenuName,
                            subItem.ParentId,
                            IsChecked = tenantMenuList?.Where(qitem => qitem.MenuId == subItem.MenuId)?.Count() > 0,
                            SubMenuList = childList
                        });
                    }
                    var obj = new
                    {
                        item.MenuId,
                        item.MenuName,
                        item.ParentId,
                        IsChecked = tenantMenuList?.Where(qitem => qitem.MenuId == item.MenuId)?.Count() > 0,
                        SubMenuList = secondList
                    };
                    result.Add(obj);
                }
            }
            return ApiResult.Success(data: result);
        }

        #endregion
    }
}