﻿using Mall.CacheManager.AppletWeChat;
using Mall.CacheManager.DataStatistic;
using Mall.Common;
using Mall.Common.Enum;
using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.User;
using Mall.Repository.TradePavilion;
using Newtonsoft.Json.Linq;
using RabbitMQ.Client.Framing.Impl;
using System;
using System.Collections.Generic;
using System.Linq;
using VT.FW.DB;
using static ICSharpCode.SharpZipLib.Zip.ExtendedUnixData;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 宜宾商载通新方法处理类
    /// </summary>
    public partial class BuildingCarrierModule
    {
        /// <summary>
        /// 【商载通】品牌/企业申请仓储层
        /// </summary>
        private readonly RB_BrandEnterpriseApplyForRepository brandEnterpriseApplyForRepository = new RB_BrandEnterpriseApplyForRepository();


        /// <summary>
        /// 【商载通】品牌/企业申请仓储层
        /// </summary>
        private readonly RB_CarrierEnterpriseApplyForRepository carrierEnterpriseApplyForRepository = new RB_CarrierEnterpriseApplyForRepository();

        /// <summary>
        /// 【商载通】地铁申请仓储层
        /// </summary>
        private readonly RB_CarrierEnterpriseMetroApplyForRepository carrierEnterpriseMetroApplyForRepository = new RB_CarrierEnterpriseMetroApplyForRepository();



        #region 品牌/企业
        /// <summary>
        /// 品牌/企业申请信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_BrandEnterpriseApplyFor_Extend> GetCarrierEnterpriseApplyForModule(RB_BrandEnterpriseApplyFor_Extend query)
        {
            return brandEnterpriseApplyForRepository.GetCarrierEnterpriseApplyForRepository(query);

        }

        /// <summary>
        /// 品牌/企业申请信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_BrandEnterpriseApplyFor_Extend> GetBrandEnterpriseApplyForPageList(int pageIndex, int pageSize, out long rowCount, RB_BrandEnterpriseApplyFor_Extend query)
        {
            var list = brandEnterpriseApplyForRepository.GetBrandEnterpriseApplyForPageList(pageIndex, pageSize, out rowCount, query);

            return list;
        }

        /// <summary>
        /// 根据id获取品牌/企业详情信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public RB_BrandEnterpriseApplyFor_Extend GetCarrierEnterpriseApplyForEntity(int ID)
        {

            return brandEnterpriseApplyForRepository.GetEntity(ID).RefMapperTo<RB_BrandEnterpriseApplyFor_Extend>();
        }

        /// <summary>
        /// 新增/修改品牌/企业申请信息
        /// </summary>
        /// <returns></returns>
        public bool SetCarrierEnterpriseApplyFor(RB_BrandEnterpriseApplyFor_Extend model)
        {
            bool flag = false;
            if (model.ID > 0)
            {
                flag = brandEnterpriseApplyForRepository.Insert(model) > 0;
            }
            else
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.UpdateDate),model.UpdateDate },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Logo),model.Logo },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Banner),model.Banner },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.VideoUrl),model.VideoUrl },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.FullBrandName),model.FullBrandName },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.BrandName),model.BrandName },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.ShopNum),model.ShopNum },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.BuiltUpArea),model.BuiltUpArea },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.EndBuiltUpArea),model.EndBuiltUpArea },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.BrandType),model.BrandType },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.CustomerType),model.CustomerType },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.StoreExpansion),model.StoreExpansion },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.ProjectType),model.ProjectType },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.AreaRequirement),model.AreaRequirement },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.EndAreaRequirement),model.EndAreaRequirement },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Advertising),model.Advertising },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Other),model.Other },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.ShopSize),model.ShopSize },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Plumbing),model.Plumbing },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Caliber),model.Caliber },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Sewage),model.Sewage },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.RanQi),model.RanQi },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.DianLiang),model.DianLiang },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.PaiYan),model.PaiYan },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.KongTiao),model.KongTiao },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.XinFeng),model.XinFeng },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.BrandClassId),model.BrandClassId },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.RanQiBZ),model.RanQiBZ },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.IsDianLiang),model.IsDianLiang },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.PaiYanBZ),model. PaiYanBZ },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.IsShopSize),model.IsShopSize },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.OpenShopWish),model.OpenShopWish },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.IsInChengdu),model.IsInChengdu },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.ExistBrandId),model.ExistBrandId },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Introduce),model. Introduce },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.DevIntention),model.DevIntention },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.PropertyDemand),model.PropertyDemand },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Cooperation),model.Cooperation },
                    {nameof(RB_BrandEnterpriseApplyFor_Extend.Complementary),model.Complementary },
                };
                flag = brandEnterpriseApplyForRepository.Update(fileds, new WhereHelper(nameof(RB_BrandEnterpriseApplyFor_Extend.ID), model.ID));
            }
            return flag;
        }

        #endregion



        #region 载体/楼宇
        /// <summary>
        /// 新增修改载体申请
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCarrierEnterpriseApplyFor(RB_CarrierEnterpriseApplyFor_Extend model)
        {

            bool flag = false;
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CarrierName),model.CarrierName },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Logo),model.Logo },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Banner),model.Banner },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.VideoUrl),model.VideoUrl },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Address),model.Address },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.LatAndLon),model.LatAndLon },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Developers),model.Developers },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.OpenTime),model.OpenTime },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CarrierSize),model.CarrierSize },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.ProjectType),(int)model.ProjectType },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.LayersNum),model.LayersNum },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CarNum),model.CarNum },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CarrierPlan),model.CarrierPlan },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CarrierTarget),model.CarrierTarget },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Location),model.Location },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Crowd),model.Crowd },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.ExistCarrierId),model.ExistCarrierId },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Discount),model.Discount },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Honor),model.Honor },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.YeJi),model.YeJi },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.ShopNum),model.ShopNum },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.AreaRequirement ),model.AreaRequirement  },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.EndAreaRequirement),model.EndAreaRequirement },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.BuiltUpArea),model.BuiltUpArea },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.EndBuiltUpArea),model.EndBuiltUpArea },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.FirstShopNum),model.FirstShopNum },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.StartingInfo),model.StartingInfo },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.Ascription),model.Ascription },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.PropertyComposition),model.PropertyComposition },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.VisitorsFlowrate),model.VisitorsFlowrate },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.SupportingFacilities),model.SupportingFacilities },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.ManagementCompany),model.ManagementCompany },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.BrandDemand),model.BrandDemand },
                    {nameof(RB_CarrierEnterpriseApplyFor_Extend.CategoryId),model.CategoryId },
                };
                flag = carrierEnterpriseApplyForRepository.Update(fileds, new WhereHelper(nameof(RB_CarrierEnterpriseApplyFor_Extend.ID), model.ID));
                if (flag)
                {
                    var oldCarrierMetroList = carrierEnterpriseMetroApplyForRepository.GetCarrierMetroList(new RB_CarrierEnterpriseMetroApplyFor_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CarrierId = model.ID });
                    carrierEnterpriseMetroApplyForRepository.DeleteBatch(oldCarrierMetroList);
                    model.CarrierMetroList.ForEach(x =>
                    {
                        x.CarrierId = model.ID;
                        x.Status = 0;
                        x.TenantId = model.TenantId;
                        x.MallBaseId = model.MallBaseId;
                    });
                    carrierEnterpriseMetroApplyForRepository.InsertBatch(model.CarrierMetroList);

                    //更新认证表  资料状态为完成
                    //Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    //    { nameof(RB_Company_Extend.IsComplete),1}
                    //};
                    //List<WhereHelper> wheres = new List<WhereHelper>() {
                    //    new WhereHelper(){
                    //            FiledName=nameof(RB_Company_Extend.CompanyId),
                    //            FiledValue= model.CompanyId,
                    //            OperatorEnum=OperatorEnum.Equal
                    //    }
                    //};
                    //companyRepository.Update(keyValues, wheres);
                }
            }
            else
            {
                #region 验证载体申请是否已存在
                //var oldList = carrierEnterpriseApplyForRepository.GetCarrierEnterpriseList(new RB_CarrierEnterpriseApplyFor_Extend() { MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                //if (oldList.Any())
                //{
                //    return false;
                //}
                #endregion
                int Id = carrierEnterpriseApplyForRepository.Insert(model);
                if (Id > 0)
                {
                    model.CarrierMetroList.ForEach(x =>
                    {
                        x.ID = 0;
                        x.CarrierId = Id;
                        x.Status = 0;
                        x.TenantId = model.TenantId;
                        x.MallBaseId = model.MallBaseId;
                    });
                    carrierEnterpriseMetroApplyForRepository.InsertBatch(model.CarrierMetroList);

                    //更新认证表  资料状态为完成
                    //Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    //    { nameof(RB_Company_Extend.IsComplete),1}
                    //};
                    //List<WhereHelper> wheres = new List<WhereHelper>() {
                    //    new WhereHelper(){
                    //            FiledName=nameof(RB_Company_Extend.CompanyId),
                    //            FiledValue= model.CompanyId,
                    //            OperatorEnum=OperatorEnum.Equal
                    //    }
                    //};
                    //  companyRepository.Update(keyValues, wheres);
                }
                flag = Id > 0;
            }
            if (flag)
            {
                //if (Config.IsFirtsShopAutoExamine == "1")//自动审核
                //{
                ////    Dictionary<string, object> fileds = new Dictionary<string, object>()
                ////    {
                ////        {nameof(RB_Company_Extend.CompanyStatus),1 },
                ////    };

                ////    List<WhereHelper> wheres = new List<WhereHelper>() {
                ////     new WhereHelper(){
                ////         FiledName=nameof(RB_Company_Extend.CompanyId),
                ////          FiledValue= model.CompanyId,
                ////           OperatorEnum=OperatorEnum.Equal
                ////     }
                ////};
                ////    companyRepository.Update(fileds, wheres);
                //    //载体
                //    var carrierList = carrierEnterpriseApplyForRepository.GetCarrierEnterpriseList(new RB_CarrierEnterpriseApplyFor_Extend() { MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                //    if (carrierList != null && carrierList.Any())
                //    {
                //        var CarrierModel = carrierList.FirstOrDefault();
                //        var MetroList = carrierEnterpriseMetroApplyForRepository.GetCarrierMetroList(new RB_CarrierEnterpriseMetroApplyFor_Extend { MallBaseId = model.MallBaseId, CarrierId = CarrierModel.ID });

                //        if (CarrierModel.ExistCarrierId > 0)
                //        {
                //            var carrmodel = carrierRepository.GetEntity(CarrierModel.ExistCarrierId);

                //            #region 修改载体
                //            int FirstStoreTest = 0;
                //            if (!string.IsNullOrWhiteSpace(CarrierModel.StartingInfo))
                //            {
                //                FirstStoreTest = 1;
                //            }
                //            int OpeningStatus = 0;
                //            if (CarrierModel.OpenTime.HasValue)
                //            {
                //                if (CarrierModel.OpenTime.Value <= System.DateTime.Now)
                //                {
                //                    OpeningStatus = 1;
                //                }
                //            }
                //            Dictionary<string, object> filedsCarrier = new Dictionary<string, object>()
                //                    {
                //                        {nameof(RB_Carrier_Extend.Logo),CarrierModel.Logo },
                //                        {nameof(RB_Carrier_Extend.Banner),CarrierModel.Banner },
                //                        {nameof(RB_Carrier_Extend.VideoUrl),CarrierModel.VideoUrl },
                //                        {nameof(RB_Carrier_Extend.Address),CarrierModel.Address },
                //                        {nameof(RB_Carrier_Extend.LatAndLon),CarrierModel.LatAndLon },
                //                        {nameof(RB_Carrier_Extend.Developers),CarrierModel.Developers },
                //                        {nameof(RB_Carrier_Extend.OpenTime),CarrierModel.OpenTime },
                //                        {nameof(RB_Carrier_Extend.CarrierSize),CarrierModel.CarrierSize },
                //                        {nameof(RB_Carrier_Extend.ProjectType),(int)CarrierModel.ProjectType },
                //                        {nameof(RB_Carrier_Extend.LayersNum),CarrierModel.LayersNum },
                //                        {nameof(RB_Carrier_Extend.CarNum),CarrierModel.CarNum },
                //                        {nameof(RB_Carrier_Extend.CarrierPlan),CarrierModel.CarrierPlan },
                //                        {nameof(RB_Carrier_Extend.CarrierTarget),CarrierModel.CarrierTarget },
                //                        {nameof(RB_Carrier_Extend.Location),CarrierModel.Location },
                //                        {nameof(RB_Carrier_Extend.Crowd),CarrierModel.Crowd },
                //                        {nameof(RB_Carrier_Extend.UserId),cmodel.CreateBy },
                //                        {nameof(RB_Carrier_Extend.Discount),CarrierModel.Discount },
                //                        {nameof(RB_Carrier_Extend.Honor),CarrierModel.Honor },
                //                        {nameof(RB_Carrier_Extend.YeJi),CarrierModel.YeJi },
                //                        {nameof(RB_Carrier_Extend.ShopNum),CarrierModel.ShopNum },
                //                        {nameof(RB_Carrier_Extend.AreaRequirement ),CarrierModel.AreaRequirement  },
                //                        {nameof(RB_Carrier_Extend.EndAreaRequirement),CarrierModel.EndAreaRequirement },
                //                        {nameof(RB_Carrier_Extend.BuiltUpArea),CarrierModel.BuiltUpArea },
                //                        {nameof(RB_Carrier_Extend.EndBuiltUpArea),CarrierModel.EndBuiltUpArea },
                //                        {nameof(RB_Carrier_Extend.FirstShopNum),CarrierModel.FirstShopNum },
                //                        {nameof(RB_Carrier_Extend.StartingInfo),CarrierModel.StartingInfo },
                //                          {nameof(RB_Carrier_Extend.FirstStoreTest),FirstStoreTest },
                //                          {nameof(RB_Carrier_Extend.OpeningStatus),OpeningStatus }
                //                    };
                //            flag = carrierRepository.Update(filedsCarrier, new WhereHelper(nameof(RB_Carrier_Extend.ID), carrmodel.ID));
                //            if (flag)
                //            {
                //                var oldCarrierMetroList = carrierMetroRepository.GetCarrierMetroList(new RB_CarrierMetro_Extend { MallBaseId = CarrierModel.MallBaseId, CarrierId = carrmodel.ID });
                //                carrierMetroRepository.DeleteBatch(oldCarrierMetroList);
                //                var mlist = MetroList.RefMapperToList<RB_CarrierMetro_Extend>();
                //                mlist.ForEach(x =>
                //                {
                //                    x.ID = 0;
                //                    x.CarrierId = carrmodel.ID;
                //                    x.Status = 0;
                //                    x.TenantId = CarrierModel.TenantId;
                //                    x.MallBaseId = CarrierModel.MallBaseId;
                //                });
                //                carrierMetroRepository.InsertBatch(mlist);
                //            }
                //            #endregion
                //        }
                //        else
                //        {

                //            #region 新增载体
                //            var inserCModel = CarrierModel.RefMapperTo<RB_Carrier_Extend>();
                //            inserCModel.ID = 0;
                //            inserCModel.UserId = cmodel.CreateBy;
                //            if (CarrierModel.OpenTime.HasValue)
                //            {
                //                if (CarrierModel.OpenTime.Value <= System.DateTime.Now)
                //                {
                //                    inserCModel.OpeningStatus = 1;
                //                }
                //            }
                //            if (!string.IsNullOrWhiteSpace(CarrierModel.StartingInfo))
                //            {
                //                inserCModel.FirstStoreTest = 1;
                //            }
                //            int Id = carrierRepository.Insert(inserCModel);
                //            if (Id > 0)
                //            {
                //                var mlist = MetroList.RefMapperToList<RB_CarrierMetro_Extend>();
                //                mlist.ForEach(x =>
                //                {
                //                    x.ID = 0;
                //                    x.CarrierId = Id;
                //                    x.Status = 0;
                //                    x.TenantId = CarrierModel.TenantId;
                //                    x.MallBaseId = CarrierModel.MallBaseId;
                //                });
                //                carrierMetroRepository.InsertBatch(mlist);
                //            }
                //            #endregion
                //        }
                //    }
                //}
            }
            return flag;
        }
        #endregion


    }
}
