﻿using VT.FW.DB;
using Mall.Common.Enum.Goods;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.Statistics
{
    /// <summary>
    /// 首页统计
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class MallIndexStatistics
    {
        /// <summary>
        /// 用户数量
        /// </summary>
        public int UserTotalNum { get; set; }

        /// <summary>
        /// 商品数量
        /// </summary>
        public int GoodsTotalNum { get; set; }

        /// <summary>
        /// 总订单数量
        /// </summary>
        public int TotalOrderNum { get; set; }

        /// <summary>
        /// 代发货数量
        /// </summary>
        public int NoSendOrderNum { get; set; }

        /// <summary>
        /// 维权订单数量
        /// </summary>
        public int ActivistOrderNum { get; set; }
    }

    /// <summary>
    /// 订单数量统计
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class OrderNum
    {
        /// <summary>
        /// 订单状态  枚举
        /// </summary>        
        public OrderStatusEnum? OrderStatus
        {
            get;
            set;
        }

        /// <summary>
        /// 订单数量
        /// </summary>
        public int OrderCount { get; set; }
    }

    /// <summary>
    /// 销售情况统计
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class MallSalesStatistics
    {
        /// <summary>
        /// 时间类型
        /// </summary>
        public string TimeStr { get; set; }

        /// <summary>
        /// 支付订单数
        /// </summary>
        public int OrderCount { get; set; }

        /// <summary>
        /// 支付金额
        /// </summary>
        public decimal Income { get; set; }

        /// <summary>
        /// 用户数量
        /// </summary>
        public int UserCount { get; set; }

        /// <summary>
        /// 购买商品件数
        /// </summary>
        public int GoodCount { get; set; }
    }

    /// <summary>
    /// 商品购买力TOP排行
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class MallSalesGoodsTop
    {
        /// <summary>
        /// 排名
        /// </summary>
        public int Num { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }

        /// <summary>
        /// 销售额
        /// </summary>
        public decimal Income { get; set; }

        /// <summary>
        /// 销量
        /// </summary>
        public int SaleCount { get; set; }
    }

    /// <summary>
    /// 用户购买力TOP排行
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class MallSalesUserTop
    {
        /// <summary>
        /// 排名
        /// </summary>
        public int Num { get; set; }

        /// <summary>
        /// 用户头像
        /// </summary>
        public string Photo { get; set; }

        /// <summary>
        /// 用户名称
        /// </summary>
        public string UserName { get; set; }

        /// <summary>
        /// 支付金额
        /// </summary>
        public decimal Income { get; set; }

        /// <summary>
        /// 支付件数
        /// </summary>
        public int SaleCount { get; set; }
    }

    /// <summary>
    /// 分销用户统计
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class MallDistributorTotal
    {
        /// <summary>
        /// 分销等级
        /// </summary>
        public int FXGradeId { get; set; }

        /// <summary>
        /// 分销等级名称
        /// </summary>
        public string GradeName { get; set; }

        /// <summary>
        /// 分销等级用户数量
        /// </summary>
        public int UserCount { get; set; }

        /// <summary>
        /// 时间
        /// </summary>
        public DateTime TimeStr { get; set; }
    }
}
