﻿using Mall.Model.Entity.Product;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品关联区域表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Groupbuy_Activity_Extend : RB_Groupbuy_Activity
    {
        /// <summary>
        /// 开始日期
        /// </summary>
        public string QStartDate { get; set; }

        /// <summary>
        /// 结束日期
        /// </summary>
        public string QEndDate { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        public string QGoodName { get; set; }

        /// <summary>
        /// 商品封面图
        /// </summary>
        public string CarouselImage { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string Cover_Img
        {
            get
            {
                string str = "";
                if (!string.IsNullOrWhiteSpace(this.CarouselImage))
                {
                    List<string> imgList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(this.CarouselImage);
                    if (imgList != null && imgList.Count > 0)
                    {
                        str = Common.Config.GetFileUrl(imgList[0]);
                    }
                }
                return str;
            }
        }

 
        /// <summary>
        /// 活动开始时间
        /// </summary>
        public string StartTimeStr
        {
            get
            {
                string str = "";
                str = Convert.ToDateTime(this.StartTime).ToString("yyyy-MM-dd HH:mm:ss");
                return str;
            }
        }

        /// <summary>
        /// 活动结束时间
        /// </summary>
        public string EndTimeStr
        {
            get
            {
                string str = "";
                str = Convert.ToDateTime(this.EndTime).ToString("yyyy-MM-dd HH:mm:ss");
                return str;
            }
        }

        /// <summary>
        /// 活动状态
        /// </summary>
        public string GoodsStatusStr
        {
            get
            {
                string str = "";
                switch (this.GoodsStatus)
                {
                    case 1:
                        str = "上架";
                        if (this.StartTime > DateTime.Now)
                        {
                            str = "未开始";
                        }
                        if (this.StartTime <= DateTime.Now && DateTime.Now <= this.EndTime)
                        {
                            str = "进行中";
                        }
                        if (DateTime.Now > this.EndTime)
                        {
                            str = "已结束";
                        }
                        break;
                    case 2: str = "下架"; break;
                    case 3: str = "删除"; break;
                }
                return str;
            }
        }

        /// <summary>
        /// 拼团阶梯价列表
        /// </summary>
        public List<RB_Groupbuy_Activity_Step_Extend> GroupList { get; set; }

        /// <summary>
        /// 规格名列表
        /// </summary>
        public List<RB_Groupbuy_Activity_Specification_Extend> SpecificationList { get; set; }

        /// <summary>
        /// 规格价格列表
        /// </summary>
        public List<RB_Groupbuy_Activity_Specificationprice_Extend> SpecificationPriceList { get; set; }

        /// <summary>
        /// 服务列表
        /// </summary>
        public List<RB_ImageCommonModel> ServiceList { get; set; }
    }
}
