﻿using Mall.Model.Entity.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Extend.TradePavilion
{
    /// <summary>
    /// 榜单报名扩展实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_FirstShop_ListEnroll_Extend : RB_FirstShop_ListEnroll
    {
        /// <summary>
        /// 查询候选列表  1是
        /// </summary>
        public int IsSelectCandidate { get; set; }

        /// <summary>
        /// 查询上榜列表  1是
        /// </summary>
        public int IsSelectPrize { get; set; }

        /// <summary>
        /// 用户名称
        /// </summary>
        public string UserName { get; set; }

        /// <summary>
        /// 用户头像
        /// </summary>
        public string UserIcon { get; set; }

        /// <summary>
        /// 品牌/载体名称
        /// </summary>
        public string ObjectName { get; set; }

        /// <summary>
        /// 品牌/载体图标
        /// </summary>
        public string ObjectIcon { get; set; }

        /// <summary>
        /// 企业名称
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// 联系人(责任人)
        /// </summary>
        public string Principal { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// 对象ids
        /// </summary>
        public string ObjectIds { get; set; }
    }
}
