﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace Mall.Common.Plugin
{
    /// <summary>
    /// 微信帮助类
    /// </summary>
    public class WeiXinHelper
    {
        static readonly List<WeChatMiniAppMessage> weChatMiniAppMessages = new List<WeChatMiniAppMessage>();

        static WeiXinHelper()
        {
            // //(拼团失败通知) 980（拼团成功通知）
            weChatMiniAppMessages.Add(new WeChatMiniAppMessage()
            {
                Tid = "1953",
                Title = "拼团失败通知",
                KidList = new List<int>() {1,2,3 },
                SceneDesc = "",
            });

            weChatMiniAppMessages.Add(new WeChatMiniAppMessage()
            {
                Tid = "980",
                Title = "拼团成功通知",
                KidList = new List<int>() {1,2,3},
                SceneDesc = "",
            });
        }

        /// <summary>
        /// 获取微信用户OpenId
        /// </summary>
        /// <param name="AppId"></param>
        /// <param name="AppSecret"></param>
        /// <param name="Code"></param>
        /// <returns></returns>
        public static string GetWeChatOpenId(string AppId, string AppSecret, string Code)
        {
            string result = "";
            string openid = "";
            try
            {
                //请求路径
                string url = "https://api.weixin.qq.com/sns/jscode2session?appid=" + AppId + "&secret=" + AppSecret + "&js_code=" + Code + "&grant_type=authorization_code";
                result = Common.Plugin.HttpHelper.HttpGet(url);
                if (result != null && !string.IsNullOrEmpty(result))
                {
                    JObject jObj = JObject.Parse(result);
                    openid = jObj["openid"].ToString();
                }
            }
            catch (Exception ex)
            {
                //GetWeChatOpenId:result={"errcode":40163,"errmsg":"code been used, hints: [ req_id: AHGbGiqNe-OhJh.a ]"}&&Code=051S1Ykl2wYCF64U7gnl2AK6ga0S1Yk2
                //Code过期
                if (result != null && !string.IsNullOrEmpty(result) && !result.Contains("40163"))
                {
                    Common.Plugin.LogHelper.Write(ex, string.Format("GetWeChatOpenId:result={0}&&Code={1}", result, Code));
                }
            }
            return openid;
        }

        /// <summary>
        /// 验证OpenId是否有效
        /// </summary>
        /// <param name="AppId"></param>
        /// <param name="AppSecret"></param>
        /// <param name="OpenId"></param>
        /// <returns></returns>
        public static int ValidateOpenId(string AppId, string AppSecret,string OpenId)
        {
            string result = "";
            string access_token = "";
            try
            {
                //请求路径
                string url = string.Format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={0}&secret={1}", AppId, AppSecret);
                result = Common.Plugin.HttpHelper.HttpGet(url);
                if (result != null && !string.IsNullOrEmpty(result))
                {
                    JObject jObj = JObject.Parse(result);
                    access_token = jObj["access_token"].ToString();
                }
                if (!string.IsNullOrWhiteSpace(access_token))
                {
                    string TestUrl = string.Format("https://api.weixin.qq.com/sns/auth?access_token={0}&openid={1}", access_token, OpenId);
                    result = Common.Plugin.HttpHelper.HttpGet(TestUrl);
                }
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "GetWeChatAccessToken:result=" + result);
            }
            return 1;
        }

        /// <summary>
        /// 获取微信订阅消息模板
        /// </summary>
        /// <param name="AppId"></param>
        /// <param name="AppSecret"></param>
        /// <returns></returns>
        public static List<WeChatMiniAppMessage> GetWeChatTemplateMessage(string AppId, string AppSecret)
        {
            string result = "";
            string access_token = "";
            try
            {
                //请求路径
                string url = string.Format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={0}&secret={1}",AppId,AppSecret);
                result = Common.Plugin.HttpHelper.HttpGet(url);
                if (result != null && !string.IsNullOrEmpty(result))
                {
                    JObject jObj = JObject.Parse(result);
                    access_token = jObj["access_token"].ToString();
                }
                if (!string.IsNullOrWhiteSpace(access_token))
                {
                    string addTemplate = string.Format("https://api.weixin.qq.com/wxaapi/newtmpl/addtemplate?access_token={0}",access_token);
                    foreach (var item in weChatMiniAppMessages)
                    {
                        result = "";
                        string newParameters = string.Format("tid={0}",item.Tid);
                        if (item.KidList != null && item.KidList.Count > 0)
                        {
                            int index = 0;
                            foreach (var subItem in item.KidList)
                            {
                                newParameters += string.Format("&kidList[{0}]={1}", index,subItem);
                                index++;
                            }
                        }
                        newParameters += string.Format("&sceneDesc={0}",item.Title);
                        result = Common.Plugin.HttpHelper.HttpPostStr(addTemplate, newParameters);
                        if (!string.IsNullOrWhiteSpace(result))
                        {
                            JObject jObj = JObject.Parse(result);
                            item.MessageTemplateId = jObj["priTmplId"].ToString();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "GetWeChatAccessToken:result=" + result);
            }
            return weChatMiniAppMessages;
        }
    }

    /// <summary>
    /// 微信小程序订阅消息实体
    /// </summary>
    public class WeChatMiniAppMessage
    { 
        /// <summary>
        /// 模板标题Id
        /// </summary>
       public string Tid { get; set; }

        /// <summary>
        /// 模板名称
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 开发者自行组合好的模板关键词列表
        /// </summary>
        public List<int> KidList { get; set; }

        /// <summary>
        /// 服务场景描述，15个字以内
        /// </summary>
        public string SceneDesc { get; set; }

        /// <summary>
        /// 模板消息Id
        /// </summary>
        public string MessageTemplateId { get; set; }
    }

    /// <summary>
    /// 获取用心信息帮助类
    /// </summary>
    public class GetUsersHelper
    {

        /// <summary> 
        /// 获取链接返回数据 
        /// </summary> 
        /// <param name="Url">链接</param> 
        /// <param name="type">请求类型</param> 
        /// <returns></returns> 
        public string GetUrltoHtml(string Url, string type)
        {
            try
            {
                System.Net.WebRequest wReq = System.Net.WebRequest.Create(Url);
                // Get the response instance. 
                System.Net.WebResponse wResp = wReq.GetResponse();
                System.IO.Stream respStream = wResp.GetResponseStream();
                // Dim reader As StreamReader = New StreamReader(respStream) 
                using System.IO.StreamReader reader = new System.IO.StreamReader(respStream, Encoding.GetEncoding(type));
                return reader.ReadToEnd();
            }
            catch (System.Exception ex)
            {
                return ex.Message;
            }
        }
    }

    #region 实体类
    /// <summary>  
    /// 微信小程序验证返回结果  
    /// </summary>  
    public class result
    {
        /// <summary>
        /// openid
        /// </summary>
        public string openid { get; set; }

        /// <summary>
        /// session_key
        /// </summary>
        public string session_key { get; set; }

        /// <summary>
        /// 错误状态码
        /// </summary>
        public string errcode { get; set; }

        /// <summary>
        /// 错误提示信息
        /// </summary>
        public string errmsg { get; set; }
    }


    public class templateresult
    {
        /// <summary>
        /// openid
        /// </summary>
        public string openid { get; set; }

        /// <summary>
        /// session_key
        /// </summary>
        public List<templateresultModel> data { get; set; }

        /// <summary>
        /// 错误状态码
        /// </summary>
        public string errCode { get; set; }

        /// <summary>
        /// 错误提示信息
        /// </summary>
        public string errMsg { get; set; }
    }

    public class templateresultModel
    {
        /// <summary>
        /// 添加至帐号下的模板 id，发送小程序订阅消息时所需
        /// </summary>
        public string priTmplId { get; set; }

        /// <summary>
        /// 	模版标题
        /// </summary>
        public string title { get; set; }

        /// <summary>
        /// 模版内容
        /// </summary>
        public string content { get; set; }

        /// <summary>
        /// 模板内容示例
        /// </summary>
        public string example { get; set; }

        /// <summary>
        /// 模版类型，2 为一次性订阅，3 为长期订阅
        /// </summary>
        public string type { get; set; }
    }

    #endregion







    public class WxPayData
    {
        public const string SIGN_TYPE_MD5 = "MD5";
        public const string SIGN_TYPE_HMAC_SHA256 = "HMAC-SHA256";
        public WxPayData()
        {

        }

        //采用排序的Dictionary的好处是方便对数据包进行签名，不用再签名之前再做一次排序
        private readonly SortedDictionary<string, object> m_values = new SortedDictionary<string, object>();

        /**
        * 设置某个字段的值
        * @param key 字段名
         * @param value 字段值
        */
        public void SetValue(string key, object value)
        {
            m_values[key] = value;
        }

        /**
        * 根据字段名获取某个字段的值
        * @param key 字段名
         * @return key对应的字段值
        */
        public object GetValue(string key)
        {
            m_values.TryGetValue(key, out object o);
            return o;
        }

        /**
         * 判断某个字段是否已设置
         * @param key 字段名
         * @return 若字段key已被设置，则返回true，否则返回false
         */
        public bool IsSet(string key)
        {
            m_values.TryGetValue(key, out object o);
            if (null != o)
                return true;
            else
                return false;
        }

        /**
        * @将Dictionary转成xml
        * @return 经转换得到的xml串
        * @throws WxPayException
        **/
        public string ToXml()
        {
            //数据为空时不能转化为xml格式
            if (0 == m_values.Count)
            {
                //_logger.LogError(this.GetType().ToString(), "WxPayData数据为空!");
                throw new Exception("WxPayData数据为空!");
            }

            string xml = "<xml>";
            foreach (KeyValuePair<string, object> pair in m_values)
            {
                //字段值不能为null，会影响后续流程
                if (pair.Value == null)
                {
                    //_logger.LogError(this.GetType().ToString(), "WxPayData内部含有值为null的字段!");
                    throw new Exception("WxPayData内部含有值为null的字段!");
                }

                if (pair.Value.GetType() == typeof(int))
                {
                    xml += "<" + pair.Key + ">" + pair.Value + "</" + pair.Key + ">";
                }
                else if (pair.Value.GetType() == typeof(string))
                {
                    xml += "<" + pair.Key + ">" + "<![CDATA[" + pair.Value + "]]></" + pair.Key + ">";
                }
                else//除了string和int类型不能含有其他数据类型
                {
                    //_logger.LogError(this.GetType().ToString(), "WxPayData字段数据类型错误!");
                    throw new Exception("WxPayData字段数据类型错误!");
                }
            }
            xml += "</xml>";
            return xml;
        }



        public SortedDictionary<string, object> NoSignFromXml(string xml)
        {
            if (string.IsNullOrEmpty(xml))
            {
                //_logger.LogError(this.GetType().ToString(), "将空的xml串转换为WxPayData不合法!");
                throw new Exception("将空的xml串转换为WxPayData不合法!");
            }

            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.LoadXml(xml);
            XmlNode xmlNode = xmlDoc.FirstChild;//获取到根节点<xml>
            XmlNodeList nodes = xmlNode.ChildNodes;
            foreach (XmlNode xn in nodes)
            {
                XmlElement xe = (XmlElement)xn;
                m_values[xe.Name] = xe.InnerText;//获取xml的键值对到WxPayData内部的数据中
            }

            return m_values;
        }

        /**
        * @Dictionary格式转化成url参数格式
        * @ return url格式串, 该串不包含sign字段值
        */
        public string ToUrl()
        {
            string buff = "";
            foreach (KeyValuePair<string, object> pair in m_values)
            {
                if (pair.Value == null)
                {
                    //_logger.LogError(this.GetType().ToString(), "WxPayData内部含有值为null的字段!");
                    throw new Exception("WxPayData内部含有值为null的字段!");
                }

                if (pair.Key != "sign" && pair.Value.ToString() != "")
                {
                    buff += pair.Key + "=" + pair.Value + "&";
                }
            }
            buff = buff.Trim('&');
            return buff;
        }



        public bool CheckSign()
        {
            ////如果没有设置签名，则跳过检测
            //if (!IsSet("sign"))
            //{
            //    //_logger.LogError(this.GetType().ToString(), "WxPayData签名存在但不合法!");
            //    throw new Exception("WxPayData签名存在但不合法!");
            //}
            ////如果设置了签名但是签名为空，则抛异常
            //else if (GetValue("sign") == null || GetValue("sign").ToString() == "")
            //{
            //    //_logger.LogError(this.GetType().ToString(), "WxPayData签名存在但不合法!");
            //    throw new Exception("WxPayData签名存在但不合法!");
            //}

            ////获取接收到的签名
            //string return_sign = GetValue("sign").ToString();

            ////在本地计算新的签名
            //string cal_sign = payReq.CreateMd5Sign(_accessor, model.WeChatApiSecret);
            return true;
            //if (cal_sign == return_sign)
            //{
            //    return true;
            //}

            //_logger.LogError(this.GetType().ToString(), "WxPayData签名验证错误!");
            throw new Exception("WxPayData签名验证错误!");
        }
    }
}
