﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Miai
{
    /// <summary>
    /// 活动评论表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Miai_ActivityDiscuss
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 活动id
        /// </summary>
        public int ActivityId { get; set; }

        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 内容
        /// </summary>
        public string Content { get; set; }

        /// <summary>
        /// 图片列表
        /// </summary>
        public string Images { get; set; }

        /// <summary>
        /// 回复内容id  1级=0
        /// </summary>
        public int ParentId { get; set; }

        /// <summary>
        /// 回复用户id
        /// </summary>
        public int ReplyUserId { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 修改时间
        /// </summary>        
        public DateTime UpdateDate
        {
            get;
            set;
        }
    }
}
