﻿using Mall.Common;
using Mall.Common.API;
using Mall.Common.Models;
using Mall.Common.Plugin;
using Mall.Model.Entity.Education;
using Mall.Model.Entity.Product;
using Mall.Model.Entity.User;
using Mall.Model.Extend.Education;
using Mall.Model.Extend.Product;
using Mall.Model.Extend.User;
using Mall.Repository.Education;
using Mall.Repository.Product;
using Mall.Repository.User;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.Education
{
    public class EducationModule
    {

        /// <summary>
        /// 素材管理
        /// </summary>
        private readonly RB_Material_InfoRepository material_InfoRepository = new RB_Material_InfoRepository();
        /// <summary>
        /// 教师仓储
        /// </summary>
        private readonly RB_Education_TeacherRepository educationTeacherRepository = new RB_Education_TeacherRepository();


        /// <summary>
        /// 我关注的教师仓储
        /// </summary>
        private readonly RB_Education_FollowTeacherRepository followTeacherRepository = new RB_Education_FollowTeacherRepository();
        /// <summary>
        /// 小程序
        /// </summary>
        private readonly RB_MiniProgramRepository miniProgramRepository = new RB_MiniProgramRepository();

        private readonly RB_Education_CouponRepository discountCouponRepository = new RB_Education_CouponRepository();
        private readonly RB_Education_CouponProductRepository productRepository = new RB_Education_CouponProductRepository();


        private readonly RB_Education_MemberUseCouponRepository memberUseCouponRepository = new RB_Education_MemberUseCouponRepository();
        private readonly RB_Education_MemberCouponRepository memberCouponRepository = new RB_Education_MemberCouponRepository();
        private readonly RB_Education_CouponSelfMotionMemberRepository selfMotionMemberRepository = new RB_Education_CouponSelfMotionMemberRepository();

        private readonly RB_Education_CouponSelfMotionRepository selfMotionRepository = new RB_Education_CouponSelfMotionRepository();

        /// <summary>
        /// 消息
        /// </summary>
        private readonly Repository.Miai.RB_Miai_MessageRepository miai_MessageRepository = new Repository.Miai.RB_Miai_MessageRepository();
        /// <summary>
        /// 课程
        /// </summary>
        private readonly RB_Goods_WK_CourseRepository goods_WK_CourseRepository = new RB_Goods_WK_CourseRepository();
        /// <summary>
        /// 教师
        /// </summary>
        private readonly RB_Goods_WK_TeacherRepository goods_WK_TeacherRepository = new RB_Goods_WK_TeacherRepository();
        /// <summary>
        /// 商品
        /// </summary>
        private readonly RB_GoodsRepository goodsRepository = new RB_GoodsRepository();
        /// <summary>
        /// 商品日志
        /// </summary>
        private readonly RB_Goods_LogRepository goods_LogRepository = new RB_Goods_LogRepository();
        /// <summary>
        /// 商品区域
        /// </summary>
        private readonly RB_Goods_AreaRepository goods_AreaRepository = new RB_Goods_AreaRepository();
        /// <summary>
        /// 商品分类
        /// </summary>
        private readonly RB_Goods_CategoryRepository goods_CategoryRepository = new RB_Goods_CategoryRepository();
        /// <summary>
        /// 订单商品
        /// </summary>
        private readonly RB_Goods_OrderRepository goods_OrderRepository = new RB_Goods_OrderRepository();
        /// <summary>
        /// 订单明细
        /// </summary>
        private readonly RB_Goods_OrderDetailRepository goods_OrderDetailRepository = new RB_Goods_OrderDetailRepository();
        /// <summary>
        /// 商品分销佣金
        /// </summary>
        private readonly RB_Goods_DistributionCommissionRepository goods_DistributionCommissionRepository = new RB_Goods_DistributionCommissionRepository();
        /// <summary>
        /// 商品会员价格
        /// </summary>
        private readonly RB_Goods_MemberPriceRepository goods_MemberPriceRepository = new RB_Goods_MemberPriceRepository();
        /// <summary>
        /// 分销商等级
        /// </summary>
        private readonly RB_Distributor_GradeRepository distributor_GradeRepository = new RB_Distributor_GradeRepository();
        /// <summary>
        /// 会员等级
        /// </summary>
        private readonly RB_Member_GradeRepository member_GradeRepository = new RB_Member_GradeRepository();

        /// <summary>
        /// 会员信息
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();

        /// <summary>
        /// 资讯
        /// </summary>
        private readonly RB_Education_ArticleRepository educationArticleRepository = new RB_Education_ArticleRepository();

        /// <summary>
        /// 资讯评论信息
        /// </summary>
        private readonly RB_Education_ArticleCommentRepository educationArticleCommentRepository = new RB_Education_ArticleCommentRepository();

        /// <summary>
        /// 网课学习
        /// </summary>
        private readonly RB_Goods_WK_CourseStudyRepository goods_WK_CourseStudyRepository = new RB_Goods_WK_CourseStudyRepository();
        /// <summary>
        /// 网课学习时间
        /// </summary>
        private readonly RB_Goods_WK_StudyTimeRepository goods_WK_StudyTimeRepository = new RB_Goods_WK_StudyTimeRepository();
        /// <summary>
        /// 课程下载
        /// </summary>
        private readonly RB_Goods_WK_DownLoadRepository goods_WK_DownLoadRepository = new RB_Goods_WK_DownLoadRepository();
        /// <summary>
        /// 启动页仓储
        /// </summary>
        private readonly RB_Education_StartUpRepository educationStartUpRepository = new RB_Education_StartUpRepository();
        /// <summary>
        ///  评论违规记录仓储
        /// </summary>
        private readonly RB_Education_ViolationLogRepository educationViolationLogRepository = new RB_Education_ViolationLogRepository();


        #region 课程管理

        /// <summary>
        /// 获取后台商品分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetProductGoodsPageList(int pageIndex, int pageSize, out long count, RB_Goods_Extend demodel)
        {
            var list = goodsRepository.GetPageListForCommission(pageIndex, pageSize, out count, demodel, 2);
            if (list.Any())
            {
                //查询分类
                string ids = string.Join(",", list.Select(x => x.Id));
                var clist = goods_CategoryRepository.GetList(new RB_Goods_Category_Extend() { GoodsIds = ids, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                var olist = goods_OrderRepository.GetGoodsOrderNum(ids);

                foreach (var item in list)
                {
                    item.CategoryList = clist.Where(x => x.GoodsId == item.Id).ToList();
                    //轮播图
                    item.CoverImage = "";
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<string> CarouselIdList = JsonConvert.DeserializeObject<List<string>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = CarouselIdList[0];
                    }

                    item.GoodsBuyNum = olist.Where(x => x.GoodsId == item.Id).FirstOrDefault()?.OrderNum ?? 0;
                }
            }
            return list;
        }

        /// <summary>
        /// 获取后台商品分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetProductGoodsPageListToExcel(int pageIndex, int pageSize, out long count, RB_Goods_Extend demodel)
        {
            var list = goodsRepository.GetPageListForCommission(pageIndex, pageSize, out count, demodel, 2);
            if (list.Any())
            {
                //查询分类
                string ids = string.Join(",", list.Select(x => x.Id));
                var clist = goods_CategoryRepository.GetList(new RB_Goods_Category_Extend() { GoodsIds = ids, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                var olist = goods_OrderRepository.GetGoodsOrderNum(ids);
                //区域
                var AreaList = new List<RB_Goods_Area_Extend>();
                if (list.Where(x => x.IsAreaBuy == 1).Any())
                {
                    string goodssid = string.Join(",", list.Where(x => x.IsAreaBuy == 1).Select(x => x.Id));
                    AreaList = goods_AreaRepository.GetList(new RB_Goods_Area_Extend() { GoodsIds = goodssid, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                #region 查询讲师信息
                var teacherList = goods_WK_TeacherRepository.GetList(new RB_Goods_WK_Teacher_Extend() { GoodsIds = ids });
                #endregion
                foreach (var item in list)
                {
                    item.CategoryList = clist.Where(x => x.GoodsId == item.Id).ToList();
                    //轮播图
                    item.CoverImage = "";
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<string> CarouselIdList = JsonConvert.DeserializeObject<List<string>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = CarouselIdList[0];
                    }

                    item.GoodsBuyNum = olist.Where(x => x.GoodsId == item.Id).FirstOrDefault()?.OrderNum ?? 0;

                    item.TeacherName = string.Join(",", teacherList.Where(x => x.GoodsId == item.Id).Select(x => x.Name));

                    item.AreaList = new List<RB_Goods_Area_Extend>();
                    if (item.IsAreaBuy == 1)
                    {
                        item.AreaList = AreaList.Where(x => x.GoodsId == item.Id).ToList();
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取会员等级列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Grade_Extend> GetMemberGradeList(RB_Member_Grade_Extend dmodel)
        {
            var list = member_GradeRepository.GetList(dmodel);
            return list;
        }

        /// <summary>
        /// 获取分销等级列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Grade_Extend> GetDistributorGradeList(RB_Distributor_Grade_Extend demodel)
        {
            var list = distributor_GradeRepository.GetList(demodel);
            return list;
        }

        /// <summary>
        /// 获取商品详情
        /// </summary>
        /// <param name="goodsId"></param>
        /// <returns></returns>
        public RB_Goods_Extend GetProductGoodsInfo(int goodsId, int TenantId, int MallBaseId)
        {
            var model = goodsRepository.GetEntity(goodsId).RefMapperTo<RB_Goods_Extend>();
            if (model == null || model.TenantId != TenantId || model.MallBaseId != MallBaseId)
            {
                return null;
            }
            model.CategoryList = goods_CategoryRepository.GetList(new RB_Goods_Category_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            model.AreaList = new List<RB_Goods_Area_Extend>();
            if (model.IsAreaBuy == 1)
            {
                model.AreaList = goods_AreaRepository.GetList(new RB_Goods_Area_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            }
            model.DistributionCommissionList = new List<RB_Goods_DistributionCommission_Extend>();
            model.DistributionCommissionTreeList = new List<RB_Goods_DistributionCommission_Extend>();
            if (model.SeparateDistribution == 1)
            {
                model.DistributionCommissionList = goods_DistributionCommissionRepository.GetList(new RB_Goods_DistributionCommission_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });

                if (model.DistributionCommissionList.Any())
                {
                    int SortNum = 1;
                    //获取分销商启用等级
                    var dgradeList = distributor_GradeRepository.GetList(new RB_Distributor_Grade_Extend() { Enabled = 1, TenantId = TenantId, MallBaseId = MallBaseId });
                    dgradeList.Add(new RB_Distributor_Grade_Extend()
                    {
                        Grade = 0,
                        Name = "默认等级",
                        Id = 0
                    });
                    string zdgradeStr = string.Join(",", dgradeList.Select(x => x.Id).OrderBy(x => x));
                    string ndgradeStr = string.Join(",", model.DistributionCommissionList.Select(x => x.DistributorGrade).Distinct().OrderBy(x => x));
                    var KeyList = model.DistributionCommissionList.Select(x => x.SpecificationSort ?? "").Distinct().ToList();
                    if (zdgradeStr == ndgradeStr)
                    {
                        foreach (var qitem in KeyList)
                        {
                            var treemodel = model.DistributionCommissionList.Where(x => (x.SpecificationSort ?? "") == qitem).FirstOrDefault();
                            treemodel.GradeCommissionList = model.DistributionCommissionList.Where(x => (x.SpecificationSort ?? "") == qitem).ToList();
                            if (model.SeparateDistributionType == 2)
                            {
                                if (!string.IsNullOrEmpty(qitem))
                                {
                                    var ssarr = qitem.Split(':');
                                    int Sort = Convert.ToInt32(ssarr[0]);
                                    string pic_url = model.SpecificationList[0].SpecificationValueList.Where(x => x.Sort == Sort).FirstOrDefault()?.ImagePath;
                                    List<object> AttrList = new List<object>();
                                    for (int i = 0; i < ssarr.Length; i++)
                                    {
                                        var smodel = model.SpecificationList[i];
                                        var svmodel = smodel.SpecificationValueList.Where(x => x.Sort == Convert.ToInt32(ssarr[i])).FirstOrDefault();
                                        AttrList.Add(new
                                        {
                                            SName = smodel.Name,
                                            SId = smodel.Id,
                                            SVId = svmodel.Sort,
                                            SVName = svmodel.Name
                                        });
                                    }
                                    treemodel.AttrList = AttrList;
                                }
                            }
                            treemodel.Sort = SortNum;
                            treemodel.GradeCommissionList = treemodel.GradeCommissionList.OrderBy(x => x.DistributorGrade).ToList();
                            model.DistributionCommissionTreeList.Add(treemodel);
                        }
                    }
                    else
                    {//分销商等级有变更
                        foreach (var qitem in KeyList)
                        {
                            var treemodel = model.DistributionCommissionList.Where(x => (x.SpecificationSort ?? "") == qitem).FirstOrDefault();
                            treemodel.GradeCommissionList = new List<RB_Goods_DistributionCommission_Extend>();
                            var gradeCommList = model.DistributionCommissionList.Where(x => (x.SpecificationSort ?? "") == qitem).ToList();
                            dgradeList = dgradeList.OrderByDescending(x => x.Grade).ToList();
                            foreach (var grade in dgradeList)
                            {
                                var gradeMList = gradeCommList.Where(x => x.DistributorGrade == grade.Id && x.SpecificationSort == qitem);
                                if (gradeMList.Any())
                                {
                                    treemodel.GradeCommissionList.AddRange(gradeMList);
                                }
                                else
                                {
                                    //表示新的
                                    treemodel.GradeCommissionList.Add(new RB_Goods_DistributionCommission_Extend()
                                    {
                                        DistributorGrade = grade.Id,
                                        OneCommission = 0,
                                        TwoCommission = 0,
                                        ThreeCommission = 0
                                    });
                                }
                            }
                            if (model.SeparateDistributionType == 2)
                            {
                                if (!string.IsNullOrEmpty(qitem))
                                {
                                    var ssarr = qitem.Split(':');
                                    int Sort = Convert.ToInt32(ssarr[0]);
                                    string pic_url = model.SpecificationList[0].SpecificationValueList.Where(x => x.Sort == Sort).FirstOrDefault()?.ImagePath;
                                    List<object> AttrList = new List<object>();
                                    for (int i = 0; i < ssarr.Length; i++)
                                    {
                                        var smodel = model.SpecificationList[i];
                                        var svmodel = smodel.SpecificationValueList.Where(x => x.Sort == Convert.ToInt32(ssarr[i])).FirstOrDefault();
                                        AttrList.Add(new
                                        {
                                            SName = smodel.Name,
                                            SId = smodel.Id,
                                            SVId = svmodel.Sort,
                                            SVName = svmodel.Name
                                        });
                                    }
                                    treemodel.AttrList = AttrList;
                                }
                            }
                            treemodel.Sort = SortNum;
                            treemodel.GradeCommissionList = treemodel.GradeCommissionList.OrderBy(x => x.DistributorGrade).ToList();
                            model.DistributionCommissionTreeList.Add(treemodel);
                        }
                    }
                    SortNum++;
                    if (model.DistributionCommissionTreeList.Any())
                    {
                        //倒序排一次
                        model.DistributionCommissionTreeList = model.DistributionCommissionTreeList.OrderByDescending(x => x.Sort).ToList();
                    }
                }
            }
            model.MemberPriceList = new List<RB_Goods_MemberPrice_Extend>();
            model.MemberPriceTreeList = new List<RB_Goods_MemberPrice_Extend>();
            if (model.EnjoyMember == 1 && model.SeparateSetMember == 1)
            {
                model.MemberPriceList = goods_MemberPriceRepository.GetList(new RB_Goods_MemberPrice_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
                if (model.MemberPriceList.Any())
                {
                    int SortNum = 1;
                    var mgradeList = member_GradeRepository.GetList(new RB_Member_Grade_Extend() { Enabled = 1, TenantId = 1, MallBaseId = 1 });

                    string zdgradeStr = string.Join(",", mgradeList.Select(x => x.Id).OrderBy(x => x));
                    string ndgradeStr = string.Join(",", model.MemberPriceList.Select(x => x.MemberGrade).Distinct().OrderBy(x => x));
                    if (zdgradeStr == ndgradeStr)
                    {
                        var KeyList = model.MemberPriceList.Select(x => x.SpecificationSort ?? "").Distinct().ToList();
                        foreach (var qitem in KeyList)
                        {
                            var treemodel = model.MemberPriceList.Where(x => (x.SpecificationSort ?? "") == qitem).FirstOrDefault();
                            treemodel.GradePriceList = model.MemberPriceList.Where(x => (x.SpecificationSort ?? "") == qitem).ToList();
                            if (!string.IsNullOrEmpty(qitem))
                            {
                                var ssarr = qitem.Split(':');
                                int Sort = Convert.ToInt32(ssarr[0]);
                                string pic_url = model.SpecificationList[0].SpecificationValueList.Where(x => x.Sort == Sort).FirstOrDefault()?.ImagePath;
                                List<object> AttrList = new List<object>();
                                for (int i = 0; i < ssarr.Length; i++)
                                {
                                    var smodel = model.SpecificationList[i];
                                    var svmodel = smodel.SpecificationValueList.Where(x => x.Sort == Convert.ToInt32(ssarr[i])).FirstOrDefault();
                                    AttrList.Add(new
                                    {
                                        SName = smodel.Name,
                                        SId = smodel.Id,
                                        SVId = svmodel.Sort,
                                        SVName = svmodel.Name
                                    });
                                }
                                treemodel.AttrList = AttrList;
                            }
                            treemodel.Sort = SortNum;
                            treemodel.GradePriceList = treemodel.GradePriceList.OrderBy(x => x.MemberGrade).ToList();
                            model.MemberPriceTreeList.Add(treemodel);
                        }
                    }
                    else
                    {//会员等级有变更
                        var KeyList = model.MemberPriceList.Select(x => x.SpecificationSort ?? "").Distinct().ToList();
                        foreach (var qitem in KeyList)
                        {
                            var treemodel = model.MemberPriceList.Where(x => (x.SpecificationSort ?? "") == qitem).FirstOrDefault();
                            //treemodel.GradePriceList = model.MemberPriceList.Where(x => (x.SpecificationSort ?? "") == qitem).ToList();
                            treemodel.GradePriceList = new List<RB_Goods_MemberPrice_Extend>() { };
                            var gradePrice = model.MemberPriceList.Where(x => (x.SpecificationSort ?? "") == qitem).ToList();
                            mgradeList = mgradeList.OrderByDescending(x => x.Grade).ToList();
                            foreach (var grade in mgradeList)
                            {
                                var gradeMList = gradePrice.Where(x => x.MemberGrade == grade.Id && x.SpecificationSort == qitem);
                                if (gradeMList.Any())
                                {
                                    treemodel.GradePriceList.AddRange(gradeMList);
                                }
                                else
                                {
                                    //表示新的
                                    treemodel.GradePriceList.Add(new RB_Goods_MemberPrice_Extend()
                                    {
                                        MemberGrade = grade.Id,
                                        MemberPrice = 0,
                                    });
                                }
                            }
                            if (!string.IsNullOrEmpty(qitem))
                            {
                                var ssarr = qitem.Split(':');
                                int Sort = Convert.ToInt32(ssarr[0]);
                                string pic_url = model.SpecificationList[0].SpecificationValueList.Where(x => x.Sort == Sort).FirstOrDefault()?.ImagePath;
                                List<object> AttrList = new List<object>();
                                for (int i = 0; i < ssarr.Length; i++)
                                {
                                    var smodel = model.SpecificationList[i];
                                    var svmodel = smodel.SpecificationValueList.Where(x => x.Sort == Convert.ToInt32(ssarr[i])).FirstOrDefault();
                                    AttrList.Add(new
                                    {
                                        SName = smodel.Name,
                                        SId = smodel.Id,
                                        SVId = svmodel.Sort,
                                        SVName = svmodel.Name
                                    });
                                }
                                treemodel.AttrList = AttrList;
                            }
                            treemodel.Sort = SortNum;
                            treemodel.GradePriceList = treemodel.GradePriceList.OrderBy(x => x.MemberGrade).ToList();
                            model.MemberPriceTreeList.Add(treemodel);
                        }
                    }

                    SortNum++;
                    if (model.MemberPriceTreeList.Any())
                    {
                        //倒序排一次
                        model.MemberPriceTreeList = model.MemberPriceTreeList.OrderByDescending(x => x.Sort).ToList();
                    }
                }
            }
            model.CarouselImageList = new List<RB_ImageCommonModel>();
            if (!string.IsNullOrEmpty(model.CarouselImage) && model.CarouselImage != "[]")
            {
                List<string> CarouselIdList = JsonConvert.DeserializeObject<List<string>>(model.CarouselImage);
                //轮播图
                foreach (var item in CarouselIdList)
                {
                    model.CarouselImageList.Add(new RB_ImageCommonModel()
                    {
                        Id = 0,
                        Name = "",
                        Path = item
                    });
                }
            }
            model.CustomShareImagePath = model.CustomShareImage;

            #region 教师列表
            model.TeacherList = goods_WK_TeacherRepository.GetList(new RB_Goods_WK_Teacher_Extend() { GoodsId = goodsId });
            #endregion

            #region 课程列表
            model.CourseList = goods_WK_CourseRepository.GetList(new RB_Goods_WK_Course_Extend() { GoodsId = goodsId });
            #endregion
            return model;
        }

        /// <summary>
        /// 新增修改商品信息
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetProductGoodsInfo(RB_Goods_Extend demodel)
        {
            try
            {
                if (demodel.Id > 0)
                {
                    var goodsModel = goodsRepository.GetEntity(demodel.Id);
                    if (goodsModel == null)
                    {
                        return false;
                    }
                    //修改
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Goods.Name),demodel.Name},
                        { nameof(RB_Goods.CarouselImage),demodel.CarouselImage},
                        { nameof(RB_Goods.VideoAddress),demodel.VideoAddress},
                        { nameof(RB_Goods.CustomShareTitles),demodel.CustomShareTitles},
                        { nameof(RB_Goods.CustomShareImage),demodel.CustomShareImage},
                        { nameof(RB_Goods.GoodsStatus),demodel.GoodsStatus},
                        { nameof(RB_Goods.InventoryNum),demodel.InventoryNum},
                        { nameof(RB_Goods.DefaultSpecificationName),demodel.DefaultSpecificationName},
                        { nameof(RB_Goods.IsCustomSpecification),demodel.IsCustomSpecification},
                        { nameof(RB_Goods.Sort),demodel.Sort},
                        { nameof(RB_Goods.SellingPrice),demodel.SellingPrice},
                        { nameof(RB_Goods.OriginalPrice),demodel.OriginalPrice},
                        { nameof(RB_Goods.Unit),demodel.Unit},
                        { nameof(RB_Goods.CostPrice),demodel.CostPrice},
                        { nameof(RB_Goods.IsGoodsNegotiable),demodel.IsGoodsNegotiable},
                        { nameof(RB_Goods.SalesNum),demodel.SalesNum},
                        { nameof(RB_Goods.GoodsNumbers),demodel.GoodsNumbers},
                        { nameof(RB_Goods.GoodsWeight),demodel.GoodsWeight},
                        { nameof(RB_Goods.IsDefaultService),demodel.IsDefaultService},
                        { nameof(RB_Goods.GoodsService),demodel.GoodsService},
                        { nameof(RB_Goods.FreightId),demodel.FreightId},
                        { nameof(RB_Goods.FormsId),demodel.FormsId},
                        { nameof(RB_Goods.LimitBuyGoodsNum),demodel.LimitBuyGoodsNum},
                        { nameof(RB_Goods.LimitBuyOrderNum),demodel.LimitBuyOrderNum},
                        { nameof(RB_Goods.FullNumPinkage),demodel.FullNumPinkage},
                        { nameof(RB_Goods.FullMoneyPinkage),demodel.FullMoneyPinkage},
                        { nameof(RB_Goods.IsAreaBuy),demodel.IsAreaBuy},
                        { nameof(RB_Goods.IntegralPresent),demodel.IntegralPresent},
                        { nameof(RB_Goods.IntegralPresentType),demodel.IntegralPresentType},
                        { nameof(RB_Goods.PointsDeduction),demodel.PointsDeduction},
                        { nameof(RB_Goods.PointsDeductionType),demodel.PointsDeductionType},
                        { nameof(RB_Goods.IsMultipleDeduction),demodel.IsMultipleDeduction},
                        { nameof(RB_Goods.GoodsDetails),demodel.GoodsDetails},
                        { nameof(RB_Goods.UpdateDate),demodel.UpdateDate},
                        { nameof(RB_Goods.SeparateDistribution),demodel.SeparateDistribution},
                        { nameof(RB_Goods.SeparateDistributionType),demodel.SeparateDistributionType},
                        { nameof(RB_Goods.SeparateDistributionMoneyType),demodel.SeparateDistributionMoneyType},
                        { nameof(RB_Goods.EnjoyMember),demodel.EnjoyMember},
                        { nameof(RB_Goods.SeparateSetMember),demodel.SeparateSetMember},
                        { nameof(RB_Goods.IsQuickBuy),demodel.IsQuickBuy},
                        { nameof(RB_Goods.SupplierId),demodel.SupplierId},
                        { nameof(RB_Goods.IsProxy),demodel.IsProxy},
                        { nameof(RB_Goods.ProxyType),demodel.ProxyType},
                        { nameof(RB_Goods.ProxyRises),demodel.ProxyRises},
                        { nameof(RB_Goods.ProxyMoney),demodel.ProxyMoney},
                        { nameof(RB_Goods.Commission),demodel.Commission},
                        { nameof(RB_Goods.PresentFXGrade),demodel.PresentFXGrade},
                        { nameof(RB_Goods.PresentFXMonth),demodel.PresentFXMonth},
                        { nameof(RB_Goods.Advertising),demodel.Advertising},
                        { nameof(RB_Goods.SubName),demodel.SubName},
                        { nameof(RB_Goods.MarketingLogo),demodel.MarketingLogo},
                        { nameof(RB_Goods.IsLiveGoods),demodel.IsLiveGoods},
                        { nameof(RB_Goods.ShelvesDate),demodel.ShelvesDate },
                        { nameof(RB_Goods.DownDate),demodel.DownDate },
                        { nameof(RB_Goods.SendArea),demodel.SendArea },
                        { nameof(RB_Goods.SiteId),demodel.SiteId },
                        { nameof(RB_Goods.GuideId),demodel.GuideId },
                        { nameof(RB_Goods.CarId),demodel.CarId },
                        { nameof(RB_Goods.CarColorId),demodel.CarColorId },
                        { nameof(RB_Goods.CarNumber),demodel.CarNumber },
                        { nameof(RB_Goods.CarBuyYear),demodel.CarBuyYear },
                        { nameof(RB_Goods.CarType),demodel.CarType },
                        { nameof(RB_Goods.UseDay),demodel.UseDay },
                        { nameof(RB_Goods.LineName),demodel.LineName },
                        { nameof(RB_Goods.LineDescription),demodel.LineDescription },
                        { nameof(RB_Goods.IsSpell),demodel.IsSpell },
                        { nameof(RB_Goods.RideNum),demodel.RideNum },
                        { nameof(RB_Goods.AdvanceDay),demodel.AdvanceDay },
                        { nameof(RB_Goods.VideoType),demodel.VideoType },
                        { nameof(RB_Goods.IntegralComment),demodel.IntegralComment },
                        { nameof(RB_Goods.IntegralCommentType),demodel.IntegralCommentType },
                        { nameof(RB_Goods.GoodsType),demodel.GoodsType },
                        { nameof(RB_Goods.GoodsPageType),demodel.GoodsPageType },
                        { nameof(RB_Goods.CourseLable),demodel.CourseLable}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods.Id),
                              FiledValue=demodel.Id,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods.TenantId),
                              FiledValue=demodel.TenantId,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods.MallBaseId),
                              FiledValue=demodel.MallBaseId,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    bool flag = goodsRepository.Update(keyValues, wheres);
                    if (flag)
                    {
                        #region 修改分类
                        var clist = goods_CategoryRepository.GetList(new RB_Goods_Category_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                        var insertList = demodel.CategoryList.Where(x => !clist.Select(y => y.CategoryId).Contains(x.CategoryId)).ToList();
                        var deleteList = clist.Where(x => !demodel.CategoryList.Select(y => y.CategoryId).Contains(x.CategoryId)).ToList();
                        foreach (var item in insertList)
                        {
                            goods_CategoryRepository.Insert(new RB_Goods_Category()
                            {
                                CategoryId = item.CategoryId,
                                CreateDate = demodel.CreateDate,
                                GoodsId = demodel.Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            });
                        }
                        foreach (var item in deleteList)
                        {
                            goods_CategoryRepository.Delete(item.Id);
                        }
                        #endregion

                        #region 修改区域
                        var alist = goods_AreaRepository.GetList(new RB_Goods_Area_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                        var insertList1 = demodel.AreaList.Where(x => !alist.Select(y => y.AreaId).Contains(x.AreaId)).ToList();
                        var deleteList1 = alist.Where(x => !demodel.AreaList.Select(y => y.AreaId).Contains(x.AreaId)).ToList();
                        foreach (var item in insertList1)
                        {
                            goods_AreaRepository.Insert(new RB_Goods_Area()
                            {
                                AreaId = item.AreaId,
                                AreaType = item.AreaType,
                                CreateDate = demodel.CreateDate,
                                GoodsId = demodel.Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            });
                        }
                        foreach (var item in deleteList1)
                        {
                            goods_AreaRepository.Delete(item.Id);
                        }


                        #endregion

                        #region 修改分销佣金
                        if (demodel.SeparateDistribution == 1)
                        {
                            //价格新增/更新
                            var dclist = goods_DistributionCommissionRepository.GetList(new RB_Goods_DistributionCommission_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                            if (dclist.Count() != demodel.DistributionCommissionList.Count()
                                || dclist.Count() != demodel.DistributionCommissionList.Where(x => dclist.Select(y => y.SpecificationSort).Contains(x.SpecificationSort)).Count()
                                || dclist.Select(x => x.DistributorGrade).Distinct().Count() != demodel.DistributionCommissionList.Select(x => x.DistributorGrade).Distinct().Count()
                                || dclist.Select(x => x.DistributorGrade).Distinct().Count() != dclist.Select(x => x.DistributorGrade).Distinct().Where(x => demodel.DistributionCommissionList.Select(y => y.DistributorGrade).Distinct().Contains(x)).Count())
                            {
                                goods_DistributionCommissionRepository.DeleteBatch(dclist);
                                foreach (var item in demodel.DistributionCommissionList)
                                {
                                    goods_DistributionCommissionRepository.Insert(new RB_Goods_DistributionCommission()
                                    {
                                        CreateDate = demodel.CreateDate,
                                        GoodsId = demodel.Id,
                                        Id = 0,
                                        DistributorGrade = item.DistributorGrade,
                                        OneCommission = item.OneCommission,
                                        ThreeCommission = item.ThreeCommission,
                                        TwoCommission = item.TwoCommission,
                                        MallBaseId = demodel.MallBaseId,
                                        SpecificationSort = item.SpecificationSort,
                                        Status = 0,
                                        TenantId = demodel.TenantId,
                                        UpdateDate = demodel.UpdateDate
                                    });
                                }
                            }
                            else
                            {

                                foreach (var item in dclist)
                                {
                                    var pupmodel = demodel.DistributionCommissionList.Where(x => x.SpecificationSort == item.SpecificationSort && x.DistributorGrade == item.DistributorGrade).FirstOrDefault();
                                    if (item.OneCommission != pupmodel.OneCommission || item.TwoCommission != pupmodel.TwoCommission || item.ThreeCommission != pupmodel.ThreeCommission)
                                    {
                                        Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                            { nameof(RB_Goods_DistributionCommission.OneCommission),pupmodel.OneCommission},
                                            { nameof(RB_Goods_DistributionCommission.TwoCommission),pupmodel.TwoCommission},
                                            { nameof(RB_Goods_DistributionCommission.ThreeCommission),pupmodel.ThreeCommission}
                                        };
                                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                            new WhereHelper(){
                                                    FiledName=nameof(RB_Goods_DistributionCommission.Id),
                                                    FiledValue=item.Id,
                                                    OperatorEnum=OperatorEnum.Equal
                                            }
                                        };
                                        goods_DistributionCommissionRepository.Update(keyValues1, wheres1);
                                    }
                                }
                            }
                        }
                        #endregion

                        #region 修改会员价格
                        if (demodel.EnjoyMember == 1 && demodel.SeparateSetMember == 1)
                        {
                            var mplist = goods_MemberPriceRepository.GetList(new RB_Goods_MemberPrice_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                            if (mplist.Count() != demodel.MemberPriceList.Count()
                                || mplist.Count() != demodel.MemberPriceList.Where(x => mplist.Select(y => y.SpecificationSort).Contains(x.SpecificationSort)).Count()
                                || mplist.Select(x => x.MemberGrade).Distinct().Count() != demodel.MemberPriceList.Select(x => x.MemberGrade).Distinct().Count()
                                || mplist.Select(x => x.MemberGrade).Distinct().Count() != mplist.Select(x => x.MemberGrade).Distinct().Where(x => demodel.MemberPriceList.Select(y => y.MemberGrade).Distinct().Contains(x)).Count())
                            {
                                goods_MemberPriceRepository.DeleteBatch(mplist);
                                foreach (var item in demodel.MemberPriceList)
                                {
                                    goods_MemberPriceRepository.Insert(new RB_Goods_MemberPrice()
                                    {
                                        CreateDate = demodel.CreateDate,
                                        GoodsId = demodel.Id,
                                        Id = 0,
                                        MemberGrade = item.MemberGrade,
                                        MemberPrice = item.MemberPrice,
                                        MallBaseId = demodel.MallBaseId,
                                        SpecificationSort = item.SpecificationSort,
                                        Status = 0,
                                        TenantId = demodel.TenantId,
                                        UpdateDate = demodel.UpdateDate
                                    });
                                }
                            }
                            else
                            {

                                foreach (var item in mplist)
                                {
                                    var pupmodel = demodel.MemberPriceList.Where(x => x.SpecificationSort == item.SpecificationSort && x.MemberGrade == item.MemberGrade).FirstOrDefault();
                                    if (item.MemberPrice != pupmodel.MemberPrice)
                                    {
                                        Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                            { nameof(RB_Goods_MemberPrice.MemberPrice),pupmodel.MemberPrice}
                                        };
                                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                            new WhereHelper(){
                                                    FiledName=nameof(RB_Goods_MemberPrice.Id),
                                                    FiledValue=item.Id,
                                                    OperatorEnum=OperatorEnum.Equal
                                            }
                                        };
                                        goods_MemberPriceRepository.Update(keyValues1, wheres1);
                                    }
                                }
                            }
                        }
                        #endregion

                        #region 修改绑定教师
                        var tdlist = goods_WK_TeacherRepository.GetList(new RB_Goods_WK_Teacher_Extend() { GoodsId = demodel.Id });
                        var tdinsertList = demodel.TeacherList.Where(x => !tdlist.Select(y => y.TeacherId).Contains(x.TeacherId)).ToList();
                        var tddeleteList = tdlist.Where(x => !demodel.TeacherList.Select(y => y.TeacherId).Contains(x.TeacherId)).ToList();
                        foreach (var item in tdinsertList)
                        {
                            goods_WK_TeacherRepository.Insert(new RB_Goods_WK_Teacher()
                            {
                                Id = 0,
                                GoodsId = demodel.Id,
                                Status = 0,
                                TeacherId = item.TeacherId,
                                CreateDate = DateTime.Now,
                                MallBaseId = demodel.MallBaseId,
                                TenantId = demodel.TenantId
                            });
                        }
                        foreach (var item in tddeleteList)
                        {
                            goods_WK_TeacherRepository.Delete(item);
                        }
                        #endregion

                        #region 修改课程
                        var courselist = goods_WK_CourseRepository.GetList(new RB_Goods_WK_Course_Extend() { GoodsId = demodel.Id });
                        var coinsertList = demodel.CourseList.Where(x => !courselist.Select(y => y.Id).Contains(x.Id)).ToList();
                        var codeleteList = courselist.Where(x => !demodel.CourseList.Select(y => y.Id).Contains(x.Id)).ToList();
                        var coupdateList = courselist.Where(x => demodel.CourseList.Select(y => y.Id).Contains(x.Id)).ToList();
                        foreach (var item in coinsertList)
                        {
                            int courseId = goods_WK_CourseRepository.Insert(new RB_Goods_WK_Course()
                            {
                                Id = 0,
                                FilePath = item.FilePath,
                                GoodsId = demodel.Id,
                                CreateDate = DateTime.Now,
                                Image = "[]",
                                IsCache = item.IsCache,
                                IsImageOK = 2,
                                IsTrySee = item.IsTrySee,
                                MallBaseId = demodel.MallBaseId,
                                Name = item.Name,
                                Number = item.Number,
                                Sort = item.Sort,
                                SortName = item.SortName,
                                Status = 0,
                                TenantId = demodel.TenantId,
                                Type = item.Type,
                                UpdateDate = DateTime.Now,
                                PathType = item.PathType,
                                VideoImage = item.VideoImage,
                                VideoTime = item.VideoTime
                            });
                            if (courseId > 0 && item.Type != Common.Enum.Goods.GoodsCourseTypeEnum.Video)
                            {
                                //发送消息队列 处理文件图片
                                RabbiMQManager.SendMessage(new RabbitConfig()
                                {
                                    HostName = "47.96.25.130",
                                    Port = 5672,
                                    UserName = "guest",
                                    Password = "viitto2019",
                                    QueenName = Config.IsNormalServer == "1" ? RabbitKey.QUEEN_GENERATE_EDUCARION : RabbitKey.QUEEN_GENERATE_EDUCARION_LOCAL
                                }, JsonConvert.SerializeObject(new
                                {
                                    GoodsId = demodel.Id,
                                    CourseId = courseId,
                                    item.FilePath,
                                    item.PathType,
                                    demodel.MallBaseId
                                }));
                            }
                        }
                        foreach (var item in coupdateList)
                        {
                            var courseModel = demodel.CourseList.Where(x => x.Id == item.Id).FirstOrDefault();
                            if (courseModel == null) { continue; }
                            bool IsUpdateImage = false;
                            if (item.FilePath != courseModel.FilePath)
                            {
                                IsUpdateImage = true;
                            }
                            Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                { nameof(RB_Goods_WK_Course.Sort),courseModel.Sort},
                                { nameof(RB_Goods_WK_Course.SortName),courseModel.SortName},
                                { nameof(RB_Goods_WK_Course.Name),courseModel.Name},
                                { nameof(RB_Goods_WK_Course.Type),courseModel.Type},
                                { nameof(RB_Goods_WK_Course.IsTrySee),courseModel.IsTrySee},
                                { nameof(RB_Goods_WK_Course.Number),courseModel.Number},
                                { nameof(RB_Goods_WK_Course.IsCache),courseModel.IsCache},
                                { nameof(RB_Goods_WK_Course.FilePath),courseModel.FilePath},
                                { nameof(RB_Goods_WK_Course.PathType),courseModel.PathType},
                                { nameof(RB_Goods_WK_Course.VideoImage),courseModel.VideoImage},
                                { nameof(RB_Goods_WK_Course.VideoTime),courseModel.VideoTime},
                                { nameof(RB_Goods_WK_Course.UpdateDate),courseModel.UpdateDate},
                            };
                            if (IsUpdateImage)
                            {
                                keyValues1.Add(nameof(RB_Goods_WK_Course.Image), "[]");
                                keyValues1.Add(nameof(RB_Goods_WK_Course.IsImageOK), 2);
                            }
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_Goods_WK_Course.Id),
                                      FiledValue=item.Id,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                            bool flagc = goods_WK_CourseRepository.Update(keyValues1, wheres1);
                            if (flagc && IsUpdateImage && courseModel.Type != Common.Enum.Goods.GoodsCourseTypeEnum.Video)
                            {
                                //发送消息队列 处理文件图片
                                RabbiMQManager.SendMessage(new RabbitConfig()
                                {
                                    HostName = "47.96.25.130",
                                    Port = 5672,
                                    UserName = "guest",
                                    Password = "viitto2019",
                                    QueenName = Config.IsNormalServer == "1" ? RabbitKey.QUEEN_GENERATE_EDUCARION : RabbitKey.QUEEN_GENERATE_EDUCARION_LOCAL
                                }, JsonConvert.SerializeObject(new
                                {
                                    GoodsId = demodel.Id,
                                    CourseId = item.Id,
                                    courseModel.FilePath,
                                    courseModel.PathType,
                                    demodel.MallBaseId
                                }));
                            }
                        }
                        foreach (var item in codeleteList)
                        {
                            goods_WK_CourseRepository.Delete(item);
                        }
                        #endregion
                    }
                }
                else
                {
                    int Id = goodsRepository.Insert(demodel);
                    bool flag = Id > 0;
                    if (flag)
                    {
                        //插入分类
                        foreach (var item in demodel.CategoryList)
                        {
                            goods_CategoryRepository.Insert(new RB_Goods_Category()
                            {
                                CategoryId = item.CategoryId,
                                CreateDate = demodel.CreateDate,
                                GoodsId = Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            });
                        }
                        //插入区域
                        foreach (var item in demodel.AreaList)
                        {
                            goods_AreaRepository.Insert(new RB_Goods_Area()
                            {
                                AreaId = item.AreaId,
                                AreaType = item.AreaType,
                                CreateDate = demodel.CreateDate,
                                GoodsId = Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            });
                        }
                        //插入分销佣金
                        if (demodel.SeparateDistribution == 1)
                        {
                            foreach (var item in demodel.DistributionCommissionList)
                            {
                                goods_DistributionCommissionRepository.Insert(new RB_Goods_DistributionCommission()
                                {
                                    CreateDate = demodel.CreateDate,
                                    GoodsId = Id,
                                    Id = 0,
                                    DistributorGrade = item.DistributorGrade,
                                    OneCommission = item.OneCommission,
                                    ThreeCommission = item.ThreeCommission,
                                    TwoCommission = item.TwoCommission,
                                    MallBaseId = demodel.MallBaseId,
                                    SpecificationSort = item.SpecificationSort,
                                    Status = 0,
                                    TenantId = demodel.TenantId,
                                    UpdateDate = demodel.UpdateDate
                                });
                            }
                        }
                        //插入会员价格
                        if (demodel.EnjoyMember == 1 && demodel.SeparateSetMember == 1)
                        {
                            foreach (var item in demodel.MemberPriceList)
                            {
                                goods_MemberPriceRepository.Insert(new RB_Goods_MemberPrice()
                                {
                                    CreateDate = demodel.CreateDate,
                                    GoodsId = Id,
                                    Id = 0,
                                    MemberGrade = item.MemberGrade,
                                    MemberPrice = item.MemberPrice,
                                    MallBaseId = demodel.MallBaseId,
                                    SpecificationSort = item.SpecificationSort,
                                    Status = 0,
                                    TenantId = demodel.TenantId,
                                    UpdateDate = demodel.UpdateDate
                                });
                            }
                        }
                        //插入教师关联
                        foreach (var item in demodel.TeacherList)
                        {
                            goods_WK_TeacherRepository.Insert(new RB_Goods_WK_Teacher()
                            {
                                Id = 0,
                                GoodsId = Id,
                                Status = 0,
                                TeacherId = item.TeacherId,
                                CreateDate = DateTime.Now,
                                MallBaseId = demodel.MallBaseId,
                                TenantId = demodel.TenantId
                            });
                        }
                        //插入课程列表
                        foreach (var item in demodel.CourseList)
                        {
                            int courseId = goods_WK_CourseRepository.Insert(new RB_Goods_WK_Course()
                            {
                                Id = 0,
                                FilePath = item.FilePath,
                                GoodsId = Id,
                                CreateDate = DateTime.Now,
                                Image = "[]",
                                IsCache = item.IsCache,
                                IsImageOK = 2,
                                IsTrySee = item.IsTrySee,
                                MallBaseId = demodel.MallBaseId,
                                Name = item.Name,
                                Number = item.Number,
                                Sort = item.Sort,
                                SortName = item.SortName,
                                Status = 0,
                                TenantId = demodel.TenantId,
                                Type = item.Type,
                                UpdateDate = DateTime.Now,
                                PathType = item.PathType,
                                VideoImage = item.VideoImage,
                                VideoTime = item.VideoTime
                            });
                            if (courseId > 0 && item.Type != Common.Enum.Goods.GoodsCourseTypeEnum.Video)
                            {
                                //发送消息队列 处理文件图片
                                RabbiMQManager.SendMessage(new RabbitConfig()
                                {
                                    HostName = "47.96.25.130",
                                    Port = 5672,
                                    UserName = "guest",
                                    Password = "viitto2019",
                                    QueenName = Config.IsNormalServer == "1" ? RabbitKey.QUEEN_GENERATE_EDUCARION : RabbitKey.QUEEN_GENERATE_EDUCARION_LOCAL
                                }, JsonConvert.SerializeObject(new
                                {
                                    GoodsId = Id,
                                    CourseId = courseId,
                                    item.FilePath,
                                    item.PathType,
                                    demodel.MallBaseId
                                }));
                            }
                        }
                    }
                }

                return true;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetProductGoodsInfoSD:" + Common.Plugin.JsonHelper.Serialize(demodel));
                return false;
            }
        }

        /// <summary>
        /// 删除商品
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelProcudtGoodsInfo(int goodsId, int tenantId, int mallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Goods.Status),1},
                { nameof(RB_Goods.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.Id),
                        FiledValue=goodsId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return goodsRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 设置商品上下架
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetGoodsStatusInfo(int goodsId, int tenantId, int mallBaseId)
        {
            var goodsModel = goodsRepository.GetEntity(goodsId);
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Goods.GoodsStatus),(goodsModel?.GoodsStatus??0)==1?2:1},
                { nameof(RB_Goods.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.Id),
                        FiledValue=goodsId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return goodsRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 设置商品上下架
        /// </summary>
        /// <param name="goodsIds"></param>
        /// <param name="Type"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetGoodsBatchStatusInfo(string goodsIds, int Type, int tenantId, int mallBaseId)
        {
            var list = goodsRepository.GetSingleListForCommission(new RB_Goods_Extend() { GoodsIds = goodsIds }, 1);
            foreach (var goodsModel in list)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods.GoodsStatus),Type},
                    { nameof(RB_Goods.UpdateDate),DateTime.Now}
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.Id),
                        FiledValue=goodsModel.Id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
                goodsRepository.Update(keyValues, wheres);
            }
            return true;
        }



        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetListByTeacherId(int pageIndex, int pageSize, out long rowCount, RB_Goods_Extend dmodel)
        {
            var list = goodsRepository.GetListByTeacherId(pageIndex, pageSize, out rowCount, dmodel);
            if (list.Any())
            {
                foreach (var item in list)
                {

                    //轮播图
                    item.CoverImage = "";
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<string> CarouselIdList = JsonConvert.DeserializeObject<List<string>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = CarouselIdList[0];
                    }
                }
            }
            return list;
        }

        #endregion

        #region 我的学习
        /// <summary>
        /// 获取我的学习时间
        /// </summary>
        /// <param name="day"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public object GetMyStudyTime(int day, int userId)
        {
            object MyStudyTimeList = new object();
            if (day > 0)
            {
                //倒退查询几天学习时间
                string EndTime = DateTime.Now.ToString("yyyy-MM-dd");
                string StartTime = DateTime.Now.AddDays(1 - day).ToString("yyyy-MM-dd");
                var list = goods_WK_StudyTimeRepository.GetMyStudyTimeByDay(userId, StartTime, EndTime);

                if (list.Count() != day)
                {
                    while (Convert.ToDateTime(StartTime) <= Convert.ToDateTime(EndTime))
                    {
                        var model = list.Where(x => x.CreateDate == Convert.ToDateTime(StartTime)).FirstOrDefault();
                        if (model == null)
                        {
                            list.Add(new RB_Goods_WK_StudyTime_Extend()
                            {
                                CreateDate = Convert.ToDateTime(StartTime),
                                Time = 0
                            });
                        }
                        StartTime = Convert.ToDateTime(StartTime).AddDays(1).ToString("yyyy-MM-dd");
                    }
                }
                MyStudyTimeList = list.OrderBy(x => x.CreateDate).Select(x => new
                {
                    Date = x.CreateDate.Value.ToString("yyyy-MM-dd"),
                    TimeFormat = GetTimeConvert(x.Time, true)
                });
            }
            //今日学习时间
            int ToDayTime = goods_WK_StudyTimeRepository.GetMyStudyTimeByToDay(userId, DateTime.Now.ToString("yyyy-MM-dd"));
            //累积学习时间
            int TotalTime = goods_WK_StudyTimeRepository.GetMyStudyTimeByTotal(userId);
            //连续学习天数
            int StydyDay = goods_WK_StudyTimeRepository.GetMyStudyTimeByStydyDay(userId);

            return new
            {
                MyStudyTimeList,
                ToDayTime = GetTimeConvert(ToDayTime, false),
                TotalTime = GetTimeConvert(TotalTime, false),
                StydyDay
            };
        }

        /// <summary>
        /// 获取时间转换
        /// </summary>
        /// <param name="time"></param>
        /// <returns></returns>
        public object GetTimeConvert(int time, bool IsDay)
        {
            decimal minute = Convert.ToDecimal(time) / 60;
            if (minute >= 1)
            {
                if (IsDay)
                {
                    return new
                    {
                        Time = Math.Truncate(minute * 10) / 10,
                        Unit = "分钟"
                    };
                }
                else
                {
                    decimal hour = minute / 60;
                    if (hour >= 1)
                    {
                        decimal day = hour / 24;
                        if (day >= 1)
                        {
                            return new
                            {
                                Time = Math.Truncate(day * 10) / 10,
                                Unit = "天"
                            };
                        }
                        else
                        {
                            return new
                            {
                                Time = Math.Truncate(hour * 10) / 10,
                                Unit = "小时"
                            };
                        }
                    }
                    else
                    {
                        return new
                        {
                            Time = Math.Truncate(minute * 10) / 10,
                            Unit = "分钟"
                        };
                    }
                }
            }
            else
            {
                //return new
                //{
                //    Time = Convert.ToDecimal(time),
                //    Unit = "秒"
                //};
                if (time > 0)
                {
                    return new
                    {
                        Time = 1,
                        Unit = "分钟"
                    };
                }
                else
                {
                    return new
                    {
                        Time = 0,
                        Unit = "分钟"
                    };
                }
            }
        }

        /// <summary>
        /// 设置学习时间
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="time"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public bool SetMyStudyTime(int goodsId, int time, int userId)
        {
            //获取最后一条记录
            var model = goods_WK_StudyTimeRepository.GetMyStudyTimeByLast(userId);
            if (model != null && model.GoodsId == goodsId && model.CreateDate.Value.ToString("yyyy-MM-dd") == DateTime.Now.ToString("yyyy-MM-dd"))
            {
                //增加时间
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Goods_WK_StudyTime.Time),model.Time + time},
                    { nameof(RB_Goods_WK_StudyTime.UpdateDate),DateTime.Now }
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Goods_WK_StudyTime.Id),
                          FiledValue=model.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return goods_WK_StudyTimeRepository.Update(keyValues, wheres);
            }
            else
            {
                //插入
                return goods_WK_StudyTimeRepository.Insert(new RB_Goods_WK_StudyTime()
                {
                    GoodsId = goodsId,
                    CreateDate = DateTime.Now,
                    Id = 0,
                    Time = time,
                    UpdateDate = DateTime.Now,
                    UserId = userId
                }) > 0;
            }
        }

        /// <summary>
        /// 设置课程已观看
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="courseId"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public bool SetMyCourseStudyOK(int goodsId, int courseId, int userId)
        {
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Goods_WK_CourseStudy.GoodsId),
                        FiledValue=goodsId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods_WK_CourseStudy.CourseId),
                        FiledValue=courseId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods_WK_CourseStudy.UserId),
                        FiledValue=userId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            if (goods_WK_CourseStudyRepository.Exists(wheres))
            {
                return true;
            }
            else
            {
                //插入记录
                return goods_WK_CourseStudyRepository.Insert(new RB_Goods_WK_CourseStudy()
                {
                    UserId = userId,
                    CourseId = courseId,
                    CreateDate = DateTime.Now,
                    GoodsId = goodsId,
                    Id = 0
                }) > 0;
            }
        }

        /// <summary>
        /// 获取最近学习课程列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public object GetMyRecentStudyPageList(int pageIndex, int pageSize, out long count, int userId)
        {
            var list = goods_WK_StudyTimeRepository.GetMyRecentStudyPageList(pageIndex, pageSize, out count, userId);
            if (list.Any())
            {
                foreach (var item in list)
                {
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<string> CarouselList = JsonConvert.DeserializeObject<List<string>>(item.CarouselImage);
                        item.CarouselImage = CarouselList[0];
                    }
                }
            }

            return list.Select(x => new
            {
                x.GoodsId,
                x.GoodsName,
                x.CarouselImage
            });
        }

        /// <summary>
        /// 获取学习明细列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public object GetMyStudyDetailPageList(int pageIndex, int pageSize, out long count, int userId)
        {
            var list = goods_WK_StudyTimeRepository.GetMyStudyDetailPageList(pageIndex, pageSize, out count, userId);
            if (list.Any())
            {
                foreach (var item in list)
                {
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<string> CarouselList = JsonConvert.DeserializeObject<List<string>>(item.CarouselImage);
                        item.CarouselImage = CarouselList[0];
                    }
                }
            }

            return list.Select(x => new
            {
                x.GoodsId,
                x.GoodsName,
                x.CarouselImage,
                CreateDate = x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm"),
                Day = x.CreateDate.Value.ToString("yyyy-MM-dd"),
                Hour = x.CreateDate.Value.ToString("HH:mm"),
                x.CourseScore,
                CourseLableList = x.CourseLable != null && x.CourseLable != "[]" ? JsonConvert.DeserializeObject<List<string>>(x.CourseLable) : new List<string>()
            });
        }

        /// <summary>
        /// 获取我的报名记录
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public object GetMyOrderStudyRecordPageList(int pageIndex, int pageSize, out long count, int userId)
        {
            var list = goods_WK_StudyTimeRepository.GetMyOrderStudyRecordPageList(pageIndex, pageSize, out count, userId);
            if (list.Any())
            {
                //查询观看记录
                string goodsIds = string.Join(",", list.Select(x => x.GoodsId).Distinct());
                var wlist = goods_WK_CourseStudyRepository.GetCourseWatchList(userId, goodsIds);
                foreach (var item in list)
                {
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<string> CarouselList = JsonConvert.DeserializeObject<List<string>>(item.CarouselImage);
                        item.CarouselImage = CarouselList[0];
                    }
                    item.WatchNum = 0;//已看完
                    var wmodel = wlist.Where(x => x.GoodsId == item.GoodsId).FirstOrDefault();
                    if (wmodel != null)
                    {
                        if (wmodel.WNum == 0)
                        {
                            item.WatchNum = -1;//未看
                        }
                        else
                        {
                            item.WatchNum = wmodel.TNum - wmodel.WNum;
                        }
                    }
                }
            }

            return list.Select(x => new
            {
                x.GoodsId,
                x.GoodsName,
                x.CarouselImage,
                SurplusNum = x.WatchNum
            });
        }

        /// <summary>
        /// 获取未缓存小程序课程章节列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="goodsId"></param>
        /// <param name="courseName"></param>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public List<RB_Goods_WK_Course_Extend> GetMyCourseNoCachePageList(int pageIndex, int pageSize, out long count, int goodsId, string courseName, int userId, int tenantId, int mallBaseId)
        {
            var list = goods_WK_CourseRepository.GetMyCourseNoCachePageList(pageIndex, pageSize, out count, new RB_Goods_WK_Course_Extend() { GoodsId = goodsId, Name = courseName, UserId = userId, TenantId = tenantId, MallBaseId = mallBaseId });
            return list;
        }

        /// <summary>
        /// 获取已缓存小程序章节列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="goodsId"></param>
        /// <param name="courseName"></param>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public List<RB_Goods_WK_Course_Extend> GetMyCourseCachedPageList(int pageIndex, int pageSize, out long count, int goodsId, string courseName, int userId, int tenantId, int mallBaseId)
        {
            var list = goods_WK_CourseRepository.GetMyCourseCachedPageList(pageIndex, pageSize, out count, new RB_Goods_WK_Course_Extend() { GoodsId = goodsId, Name = courseName, UserId = userId, TenantId = tenantId, MallBaseId = mallBaseId });
            return list;
        }

        /// <summary>
        /// 设置缓存
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public ApiResult SetMyCourseCache(RB_Goods_WK_DownLoad_Extend demodel)
        {
            //验证一下  是否已有记录
            var dmodel = goods_WK_DownLoadRepository.GetList(new RB_Goods_WK_DownLoad_Extend() { UserId = demodel.UserId, CourseId = demodel.CourseId }).FirstOrDefault();
            if (dmodel == null)
            {
                //插入
                bool flag = goods_WK_DownLoadRepository.Insert(new RB_Goods_WK_DownLoad()
                {
                    Id = 0,
                    UserId = demodel.UserId,
                    CourseId = demodel.CourseId,
                    CreateDate = DateTime.Now,
                    FilePath = demodel.FilePath,
                    FileState = 1,
                    FileType = demodel.FileType,
                    GoodsId = demodel.GoodsId,
                    Size = demodel.Size,
                    Unit = demodel.Unit,
                    UpdateDate = DateTime.Now
                }) > 0;
                if (flag)
                {
                    return ApiResult.Success();
                }
                else
                {
                    return ApiResult.Failed();
                }
            }
            else
            {
                if (dmodel.FileState == 3)
                {
                    //更新  失败的直接重新更新
                    dmodel.FilePath = demodel.FilePath;
                    dmodel.FileState = 1;
                    dmodel.FileType = demodel.FileType;
                    dmodel.Size = demodel.Size;
                    dmodel.Unit = demodel.Unit;
                    dmodel.UpdateDate = DateTime.Now;
                    bool flag = goods_WK_DownLoadRepository.Update(dmodel);
                    if (flag)
                    {
                        return ApiResult.Success();
                    }
                    else
                    {
                        return ApiResult.Failed();
                    }
                }
                else
                {
                    return ApiResult.Failed("已存在下载，请删除后再试");
                }
            }
        }

        /// <summary>
        /// 设置缓存状态
        /// </summary>
        /// <param name="courseId"></param>
        /// <param name="userId"></param>
        /// <param name="fileState"></param>
        /// <returns></returns>
        public bool SetMyCourseCacheState(int courseId, int userId, int fileState)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Goods_WK_DownLoad.FileState),fileState},
                { nameof(RB_Goods_WK_DownLoad.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_Goods_WK_DownLoad.CourseId),
                      FiledValue=courseId,
                       OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName = nameof(RB_Goods_WK_DownLoad.UserId),
                     FiledValue=userId,
                     OperatorEnum=OperatorEnum.Equal
                }
            };
            return goods_WK_DownLoadRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 删除缓存
        /// </summary>
        /// <param name="courseIds"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public bool DelMyCourseCache(string courseIds, int userId)
        {
            var list = goods_WK_DownLoadRepository.GetList(new RB_Goods_WK_DownLoad_Extend() { CourseIds = courseIds, UserId = userId });
            foreach (var item in list)
            {
                goods_WK_DownLoadRepository.Delete(item);
            }
            return true;
        }
        #endregion

        #region 教师管理
        /// <summary>
        ///教师配置列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Teacher_Extend> GetTeacherPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Education_Teacher_Extend query)
        {
            List<RB_Education_Teacher_Extend> list = educationTeacherRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);

            return list;
        }

        /// <summary>
        /// 教师配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Education_Teacher_Extend GetTeacherModel(RB_Education_Teacher_Extend query)
        {
            RB_Education_Teacher_Extend model = educationTeacherRepository.GetTeacherList(query).FirstOrDefault();

            return model;
        }


        /// <summary>
        ///教师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_Education_Teacher_Extend GetTeacherOrderInfo(RB_Education_Teacher_Extend query)
        {
            RB_Education_Teacher_Extend model = educationTeacherRepository.GetTeacherList(query).FirstOrDefault();

            return model;
        }


        /// <summary>
        /// 教师配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Teacher_Extend> GetTeacherList(RB_Education_Teacher_Extend query)
        {
            return educationTeacherRepository.GetTeacherList(query);
        }
        /// <summary>
        /// 新增/修改教师配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateTeacher(RB_Education_Teacher_Extend model)
        {
            bool flag = false;
            try
            {

                if (model.ID == 0)
                {
                    flag = educationTeacherRepository.Insert(model) > 0;
                }
                else
                {
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Education_Teacher_Extend.TeacherLogo),model.TeacherLogo},
                        { nameof(RB_Education_Teacher_Extend.Name),model.Name},
                        { nameof(RB_Education_Teacher_Extend.Telephone),model.Telephone},
                        { nameof(RB_Education_Teacher_Extend.Introduction),model.Introduction},
                         { nameof(RB_Education_Teacher_Extend.LableName),model.LableName},
                          { nameof(RB_Education_Teacher_Extend.TeacherStatus),model.TeacherStatus},
                          { nameof(RB_Education_Teacher_Extend.Major),model.Major},
                           { nameof(RB_Education_Teacher_Extend.WorkYears),model.WorkYears},
                           { nameof(RB_Education_Teacher_Extend.Nationality),model.Nationality},
                           { nameof(RB_Education_Teacher_Extend.ForeignersUrl),model.ForeignersUrl},
                           { nameof(RB_Education_Teacher_Extend.UserId),model.UserId},
                           { nameof(RB_Education_Teacher_Extend.GoodCourse),model.GoodCourse},
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Education_Teacher_Extend.ID),
                              FiledValue=model.ID,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    flag = educationTeacherRepository.Update(keyValues, wheres);
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateTeacher");
                return false;
            }
            return flag;
        }



        /// <summary>
        /// 批量上下架教师
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool EnableTeacherInfo(List<string> ids, int TeacherStatus, int uid, int mallBaseId)
        {
            var trans = educationTeacherRepository.DbTransaction;
            bool flag = false;
            try
            {
                foreach (var item in ids)
                {
                    if (!string.IsNullOrWhiteSpace(item))
                    {
                        Dictionary<string, object> cols = new Dictionary<string, object>()
                        {
                            { nameof(RB_Education_Teacher.TeacherStatus),TeacherStatus},
                            { nameof(RB_Education_Teacher.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Teacher.ID),
                                    FiledValue=Convert.ToInt32(item),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Teacher.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Teacher.MallBaseId),
                                    FiledValue=Convert.ToInt32(mallBaseId),
                                    OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        flag = educationTeacherRepository.Update(cols, wheres1, trans);
                    }
                }
                educationTeacherRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "EnableTeacherInfo");
                educationTeacherRepository.DBSession.Rollback("EnableTeacherInfo");
                return false;
            }
            return flag;
        }
        #endregion


        #region 卡劵
        /// <summary>
        /// 卡劵信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Coupon_Extend> GetDiscountCouponPageList(int pageIndex, int pageSize, out long rowCount, RB_Education_Coupon_Extend query)
        {
            return discountCouponRepository.GetDiscountCouponPageList(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 卡劵信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Coupon_Extend> GetDiscountCouponList(RB_Education_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetDiscountCouponList(query);
            if (list != null && list.Any())
            {

                string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category || x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list)
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            return list;

        }

        /// <summary>
        /// 卡劵信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Coupon_Extend> GetAllDiscountCouponList(RB_Education_Coupon_Extend query)
        {
            return discountCouponRepository.GetDiscountCouponList(query);

        }



        /// <summary>
        /// 新增/修改卡劵
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateDiscountCoupon(RB_Education_Coupon_Extend model)
        {
            bool flag = false;
            var trans = discountCouponRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = discountCouponRepository.Insert(model, trans);
                    if (id > 0 && model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.DiscountCouponType = model.UseType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.CouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = discountCouponRepository.Update(model, trans);


                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Education_CouponProduct.Status),1},
                             { nameof(RB_Education_CouponProduct.UpdateDate),model.UpdateDate},
                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Education_CouponProduct.CouponId),FiledValue=id,OperatorEnum=OperatorEnum.Equal}
                        };
                    productRepository.Update(fileds, whereHelpers, trans);

                    if (model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.DiscountCouponType = model.UseType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.CouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                }
                discountCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateDiscountCoupon");
                discountCouponRepository.DBSession.Rollback("AddOrUpdateDiscountCoupon");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除卡劵
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelDiscountCoupon(int id, int uid, int mallBaseId)
        {
            var trans = discountCouponRepository.DbTransaction;
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_Coupon.Status),1},
                        { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = discountCouponRepository.Update(cols1, wheres1);

                Dictionary<string, object> cols = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_Coupon.Status),1},
                        { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponProduct.CouponId),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponProduct.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponProduct.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                productRepository.Update(cols, wheres);


                discountCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelDiscountCoupon");
                discountCouponRepository.DBSession.Rollback("DelDiscountCoupon");
                return false;
            }
            return flag;
        }





        /// <summary>
        /// 删除会员卡劵
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelMemberCoupon(int id, int uid, int mallBaseId)
        {
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_MemberCoupon.Status),1},
                        { nameof(RB_Education_MemberCoupon.Remarks),System.DateTime.Now+"删除"},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_MemberCoupon.Id),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_MemberCoupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_MemberCoupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = memberCouponRepository.Update(cols1, wheres1);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelMemberCoupon");
                return false;
            }
            return flag;
        }



        /// <summary>
        /// 领劵中心
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool UpdatePickupType(int id, int uid, int mallBaseId)
        {
            try
            {
                var model = discountCouponRepository.GetEntity(id);

                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_Coupon.PickupCenter),model.PickupCenter==0?1:0},
                        { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                return discountCouponRepository.Update(cols1, wheres1);


            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "UpdatePickupType");
                return false;
            }
        }



        /// <summary>
        /// 发放卡劵
        /// </summary>
        /// <param name="list"></param>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool GrantCoupon(List<RB_Education_MemberCoupon_Extend> list, RB_Education_Coupon_Extend model)
        {
            var trans = memberCouponRepository.DbTransaction;
            bool flag;
            try
            {
                flag = memberCouponRepository.InsertBatch(list, trans);
                if (model != null && flag)
                {
                    Dictionary<string, object> cols1;
                    if (model.TotalNum != -1)
                    {
                        cols1 = new Dictionary<string, object>()
                        {
                            { nameof(RB_Education_Coupon.ReceiveNum),model.ReceiveNum+list.Count()},
                            { nameof(RB_Education_Coupon.TotalNum),model.TotalNum - list.Count()},
                            { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                        };
                    }
                    else
                    {
                        cols1 = new Dictionary<string, object>()
                        {
                            { nameof(RB_Education_Coupon.ReceiveNum),model.ReceiveNum+list.Count()},

                            { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                        };
                    }
                    List<WhereHelper> wheres1 = new List<WhereHelper>()
                    {
                    new WhereHelper(){
                            FiledName=nameof(RB_Education_Coupon.ID),
                            FiledValue=model.ID,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_Education_Coupon.TenantId),
                            FiledValue=model.TenantId,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_Education_Coupon.MallBaseId),
                            FiledValue=model.MallBaseId,
                            OperatorEnum=OperatorEnum.Equal
                    }
                    };
                    flag = discountCouponRepository.Update(cols1, wheres1, trans);
                }
                memberCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "GrantCoupon");
                memberCouponRepository.DBSession.Rollback("GrantCoupon");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 根据用户id和商品分类以及商品id获取未使用的卡劵信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Coupon_Extend> GetNoUseCouponList(RB_Education_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetNoUseCouponList(query);
            //获取特定商品或者分类的数据
            string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Category;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category))
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Product;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product))
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }

            return list;
        }


        #endregion


        #region 自动发放优惠券规则
        /// <summary>
        /// 自动发放优惠券规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_CSelfMotion_Extend> GetSelfMotionPageLis(int pageIndex, int pageSize, out long rowCount, RB_Education_CSelfMotion_Extend query)
        {
            return selfMotionRepository.GetSelfMotionPageLis(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 自动发放优惠券规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_CSelfMotion_Extend> GettRepositoryList(RB_Education_CSelfMotion_Extend query)
        {
            var list = selfMotionRepository.GettRepositoryList(query);

            return list;
        }



        /// <summary>
        /// 获取发放优惠券的人员信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_CSelfMotionMember_Extend> GetSelfMotionMemberList(RB_Education_CSelfMotionMember_Extend query)
        {
            return selfMotionMemberRepository.GetListRepository(query);
        }


        /// <summary>
        /// 新增/修改自动发放优惠券
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateSelfMotion(RB_Education_CSelfMotion_Extend model)
        {
            bool flag = false;
            var trans = selfMotionRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = selfMotionRepository.Insert(model, trans);
                    if (id > 0 && model.UserList != null && model.UserList.Any())
                    {
                        model.UserList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.UserList.ForEach(x => x.TenantId = model.TenantId);
                        model.UserList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.UserList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.UserList.ForEach(x => x.SelfMotionId = id);
                        flag = selfMotionMemberRepository.InsertBatch(model.UserList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = selfMotionRepository.Update(model, trans);

                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Education_CouponSelfMotionMember.Status),1},
                             { nameof(RB_Education_CouponSelfMotionMember.UpdateDate),model.UpdateDate},
                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Education_CouponSelfMotionMember.SelfMotionId),FiledValue=model.ID,OperatorEnum=OperatorEnum.Equal},
                             new WhereHelper (){ FiledName=nameof(RB_Education_CouponSelfMotionMember.MallBaseId),FiledValue=model.MallBaseId,OperatorEnum=OperatorEnum.Equal},
                              new WhereHelper (){ FiledName=nameof(RB_Education_CouponSelfMotionMember.TenantId),FiledValue=model.TenantId,OperatorEnum=OperatorEnum.Equal}
                        };
                    selfMotionMemberRepository.Update(fileds, whereHelpers, trans);


                    if (model.UserList != null && model.UserList.Any())
                    {
                        model.UserList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.UserList.ForEach(x => x.TenantId = model.TenantId);
                        model.UserList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.UserList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.UserList.ForEach(x => x.SelfMotionId = id);
                        flag = selfMotionMemberRepository.InsertBatch(model.UserList, trans);
                    }
                }
                selfMotionRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateSelfMotion");
                selfMotionRepository.DBSession.Rollback("AddOrUpdateSelfMotion");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除自动发放优惠券
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelDiscountSelfMotion(int id, int uid, int mallBaseId)
        {
            var trans = selfMotionRepository.DbTransaction;
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_CouponSelfMotion.Status),1},
                        { nameof(RB_Education_CouponSelfMotion.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotion.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotion.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotion.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = selfMotionRepository.Update(cols1, wheres1);

                Dictionary<string, object> cols = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_CouponSelfMotionMember.Status),1},
                        { nameof(RB_Education_CouponSelfMotionMember.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotionMember.SelfMotionId),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotionMember.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotionMember.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                selfMotionMemberRepository.Update(cols, wheres);


                selfMotionRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelDiscountSelfMotion");
                selfMotionRepository.DBSession.Rollback("DelDiscountSelfMotion");
                return false;
            }
            return flag;
        }


        #endregion


        #region 会员优惠券
        /// <summary>
        /// 我的优惠券
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Coupon_Extend> GetMemberDisCouponList(int pageIndex, int pageSize, out long rowCount, RB_Education_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetMemberDisCouponList(pageIndex, pageSize, out rowCount, query);
            //获取特定商品或者分类的数据
            string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Category;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category))
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Product;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product))
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            return list;
        }
        #endregion

        #region  教育-资讯管理
        /// <summary>
        ///资讯配置列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Article_Extend> GetArticlePageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Education_Article_Extend query)
        {
            List<RB_Education_Article_Extend> list = educationArticleRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);

            return list;
        }

        /// <summary>
        /// 资讯配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Education_Article_Extend GetArticleModel(RB_Education_Article_Extend query)
        {
            RB_Education_Article_Extend model = educationArticleRepository.GetTeacherList(query).FirstOrDefault();

            return model;
        }



        /// <summary>
        ///资讯列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_Education_Article_Extend GetArticleInfo(RB_Education_Article_Extend query)
        {
            RB_Education_Article_Extend model = educationArticleRepository.GetTeacherList(query).FirstOrDefault();

            return model;
        }


        /// <summary>
        /// 获取资讯实体
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public RB_Education_Article GetArticleEntity(int id)
        {
            return educationArticleRepository.GetEntity(id);


        }


        /// <summary>
        /// 资讯配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Article_Extend> GetArticleList(RB_Education_Article_Extend query)
        {
            return educationArticleRepository.GetTeacherList(query);
        }
        /// <summary>
        /// 新增/修改资讯配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateArticle(RB_Education_Article_Extend model)
        {
            bool flag = false;
            try
            {

                if (model.ID == 0)
                {
                    flag = educationArticleRepository.Insert(model) > 0;
                }
                else
                {
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Education_Article_Extend.LableName),model.LableName},
                        { nameof(RB_Education_Article_Extend.Name),model.Name},
                        { nameof(RB_Education_Article_Extend.IsComment),model.IsComment},
                        { nameof(RB_Education_Article_Extend.Describe),model.Describe},
                        { nameof(RB_Education_Article_Extend.ArticleStatus),model.ArticleStatus},
                        { nameof(RB_Education_Article_Extend.DownDate),model.DownDate},
                        { nameof(RB_Education_Article_Extend.FictitiousBrowseNum),model.FictitiousBrowseNum},
                        { nameof(RB_Education_Article_Extend.ShelvesDate),model.ShelvesDate},
                        { nameof(RB_Education_Article_Extend.Sort),model.Sort},
                        { nameof(RB_Education_Article_Extend.ArticlePic),model.ArticlePic},
                        { nameof(RB_Education_Article_Extend.TeacherId),model.TeacherId},
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Education_Article_Extend.ID),
                              FiledValue=model.ID,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    flag = educationArticleRepository.Update(keyValues, wheres);
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateArticle");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 更新资讯浏览数
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool UpdateArticleBrowseNum(RB_Education_Article_Extend model)
        {
            bool flag = false;
            try
            {
                flag = educationArticleRepository.UpdateBrowseNum(model.ID);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "UpdateArticleBrowseNum");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 批量上下架资讯
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool EnableArticleInfo(List<string> ids, int ArticleStatus, int uid, int mallBaseId)
        {
            var trans = educationArticleRepository.DbTransaction;
            bool flag = false;
            try
            {
                foreach (var item in ids)
                {
                    if (!string.IsNullOrWhiteSpace(item))
                    {
                        Dictionary<string, object> cols = new Dictionary<string, object>()
                        {
                            { nameof(RB_Education_Article.ArticleStatus),ArticleStatus},
                            { nameof(RB_Education_Article.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.ID),
                                    FiledValue=Convert.ToInt32(item),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.MallBaseId),
                                    FiledValue=Convert.ToInt32(mallBaseId),
                                    OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        flag = educationArticleRepository.Update(cols, wheres1, trans);
                    }
                }
                educationArticleRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "EnableArticleInfo");
                educationArticleRepository.DBSession.Rollback("EnableArticleInfo");
                return false;
            }
            return flag;
        }



        /// <summary>
        /// 批量删除资讯
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelArticleInfo(List<string> ids, int uid, int mallBaseId)
        {
            var trans = educationArticleRepository.DbTransaction;
            bool flag = false;
            try
            {
                foreach (var item in ids)
                {
                    if (!string.IsNullOrWhiteSpace(item))
                    {
                        Dictionary<string, object> cols = new Dictionary<string, object>()
                        {
                            { nameof(RB_Education_Article.Status),1},
                            { nameof(RB_Education_Article.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.ID),
                                    FiledValue=Convert.ToInt32(item),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.MallBaseId),
                                    FiledValue=Convert.ToInt32(mallBaseId),
                                    OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        flag = educationArticleRepository.Update(cols, wheres1, trans);
                    }
                }
                educationArticleRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelArticleInfo");
                educationArticleRepository.DBSession.Rollback("DelArticleInfo");
                return false;
            }
            return flag;
        }
        #endregion

        #region  教育-资讯评论管理

        /// <summary>
        /// 获取订单评论分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Education_ArticleComment_Extend> GetArticleCommentPageList(int pageIndex, int pageSize, out long count, RB_Education_ArticleComment_Extend demodel)
        {
            var list = educationArticleCommentRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                List<RB_Member_User_Extend> userList = new List<RB_Member_User_Extend>();
                if (list.Where(x => x.UserId > 0).Any())
                {
                    string uids = string.Join(",", list.Where(x => x.UserId > 0).Select(x => x.UserId ?? 0));
                    userList = member_UserRepository.GetList(new RB_Member_User_Extend() { UserIds = uids, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    //评论图片
                    item.CommentImgList = new List<string>();
                    if (!string.IsNullOrEmpty(item.CommentImage))
                    {
                        item.CommentImgList = JsonConvert.DeserializeObject<List<string>>(item.CommentImage);
                    }
                    if (item.UserId > 0)
                    {
                        item.UserPhotoPath = userList.Where(x => x.Id == item.UserId).FirstOrDefault()?.Photo ?? "";
                    }
                    if (item.UserId == 0 && item.UserPhoto > 0)
                    {
                        item.UserPhotoPath = material_InfoRepository.GetEntity(item.UserPhoto)?.Path ?? "";
                    }
                }
            }
            return list;
        }



        /// <summary>
        /// 管理新增评论
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetArticleCommentInfo(RB_Education_ArticleComment_Extend demodel)
        {

            bool flag = educationArticleCommentRepository.Insert(demodel) > 0;

            return flag;
        }


        /// <summary>
        /// 批量操作
        /// </summary>
        /// <param name="commentIds"></param>
        /// <param name="type"></param>
        /// <param name="content"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetArticleCommentBatch(string commentIds, int type, string content, int tenantId, int mallBaseId)
        {
            //1批量回复   2批量隐藏  3批量显示  4批量置顶  5取消置顶  6批量删除
            Dictionary<string, object> keyValues = new Dictionary<string, object>() { };
            if (type == 1)
            { //回复
                keyValues.Add(nameof(RB_Education_ArticleComment.Reply), content);
                keyValues.Add(nameof(RB_Education_ArticleComment.UpdateDate), DateTime.Now);
            }
            else if (type == 2)
            { //影藏
                keyValues.Add(nameof(RB_Education_ArticleComment.Is_Show), 2);
                keyValues.Add(nameof(RB_Education_ArticleComment.UpdateDate), DateTime.Now);
            }
            else if (type == 3)
            {
                keyValues.Add(nameof(RB_Education_ArticleComment.Is_Show), 1);
                keyValues.Add(nameof(RB_Education_ArticleComment.UpdateDate), DateTime.Now);
            }
            else if (type == 4)
            {
                keyValues.Add(nameof(RB_Education_ArticleComment.Is_Top), 1);
                keyValues.Add(nameof(RB_Education_ArticleComment.UpdateDate), DateTime.Now);
            }
            else if (type == 5)
            {
                keyValues.Add(nameof(RB_Education_ArticleComment.Is_Top), 2);
                keyValues.Add(nameof(RB_Education_ArticleComment.UpdateDate), DateTime.Now);
            }
            else if (type == 6)
            {
                keyValues.Add(nameof(RB_Education_ArticleComment.Status), 1);
                keyValues.Add(nameof(RB_Education_ArticleComment.UpdateDate), DateTime.Now);
            }
            else
            {
                return false;
            }

            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_ArticleComment.ID),
                        FiledValue=commentIds,
                        OperatorEnum=OperatorEnum.IN
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_ArticleComment.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_ArticleComment.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return educationArticleCommentRepository.Update(keyValues, wheres);
        }
        #endregion


        #region 自动发放给会员优惠券
        /// <summary>
        /// 自动给会员发放优惠券
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="getType">1-分享，2-购买并付款，3-新人领券</param>
        /// <returns></returns>
        public RB_Education_Coupon_Extend AutoEducationCoupon(RB_Education_Coupon_Extend model)
        {
            RB_Education_Coupon_Extend resultModel = new RB_Education_Coupon_Extend();
            //先查找会员是否存在
            var memberUserModel = member_UserRepository.GetEntity(model.UserId);
            if (memberUserModel == null)
            {
                return resultModel;
            }
            //根据发放类型获取对应的优惠券信息
            model.SmallShopId = memberUserModel.SmallShopId;
            if (model.TriggerType == 4)
            {
                model.RegisterDate = memberUserModel.CreateDate;
            }
            var couponList = discountCouponRepository.GetSelfmotionCouponList(model);
            if (couponList != null && couponList.Any(x => x.TotalNum == -1 || x.TotalNum > 0))//存在满足条件的优惠券可以发放
            {
                bool isReceive = false;
                //查询已发放的优惠券信息
                var memberCouponList = memberCouponRepository.GetAutoMemberCouponPageList(new RB_Education_MemberCoupon_Extend { UserId = model.UserId, GetType = model.TriggerType, TenantId = model.TenantId, MallBaseId = model.MallBaseId });
                foreach (var item in couponList.Where(x => x.TotalNum == -1 || x.TotalNum > 0))//判断当前优惠券是否已超过领取数
                {
                    int membercouponCoun = memberCouponList.Where(x => x.CouponId == item.ID).Count();
                    if (!isReceive && membercouponCoun < item.GrantNum)//此次没有领取，并且当前优惠券没有超过领取数量
                    {
                        var trans = memberCouponRepository.DbTransaction;
                        try
                        {
                            RB_Education_MemberCoupon nowMemberCoupon = new RB_Education_MemberCoupon
                            {
                                Id = 0,
                                TenantId = item.TenantId,
                                MallBaseId = item.MallBaseId,
                                Status = 0,
                                CreateDate = System.DateTime.Now,
                                UserId = model.UserId,
                                Description = item.TriggerType == 1 ? "分享自动发放优惠券" : (item.TriggerType == 2 ? "购买并付款自动发放优惠券" : (item.TriggerType == 3 ? "新人领劵自动发放优惠券" : "新人购买并付款自动发放优惠券")),
                                Remarks = item.TriggerType == 1 ? "分享" : (item.TriggerType == 2 ? "购买并付款" : (item.TriggerType == 3 ? "新人领劵" : "新人购买并付款")),
                                CouponId = item.ID,
                                StartDate = item.IndateType == Common.Enum.MarketingCenter.IndateTypeEnum.DayHorizon ? System.DateTime.Now : item.StartDate,
                                EndDate = item.IndateType == Common.Enum.MarketingCenter.IndateTypeEnum.DayHorizon ? System.DateTime.Now.AddDays(item.IndateDay) : item.EndDate,
                                GetType = item.TriggerType,
                                UseType = item.UseType,
                                Name = item.Name,
                                HeXiao = item.HeXiao,
                                UseHeXiao = 0
                            };

                            isReceive = memberCouponRepository.Insert(nowMemberCoupon, trans) > 0;
                            if (isReceive)//更新当前优惠券的领取数量
                            {
                                Dictionary<string, object> cols1;

                                if (item.TotalNum != -1)
                                {
                                    cols1 = new Dictionary<string, object>()
                                    {
                                        { nameof(RB_Education_Coupon.ReceiveNum),item.ReceiveNum+1},
                                        { nameof(RB_Education_Coupon.TotalNum),item.TotalNum - 1},
                                        { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                                    };
                                }
                                else
                                {
                                    cols1 = new Dictionary<string, object>()
                                    {
                                        { nameof(RB_Education_Coupon.ReceiveNum),item.ReceiveNum+1},
                                        { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                                    };
                                }
                                List<WhereHelper> wheres1 = new List<WhereHelper>()
                                {
                                    new WhereHelper(){
                                            FiledName=nameof(RB_Education_Coupon.ID),
                                            FiledValue=item.ID,
                                            OperatorEnum=OperatorEnum.Equal
                                    },
                                    new WhereHelper(){
                                            FiledName=nameof(RB_Education_Coupon.TenantId),
                                            FiledValue=item.TenantId,
                                            OperatorEnum=OperatorEnum.Equal
                                    },
                                    new WhereHelper(){
                                            FiledName=nameof(RB_Education_Coupon.MallBaseId),
                                            FiledValue=item.MallBaseId,
                                            OperatorEnum=OperatorEnum.Equal
                                    }
                                };
                                discountCouponRepository.Update(cols1, wheres1, trans);
                            }
                            memberCouponRepository.DBSession.Commit();
                            return item;
                        }
                        catch (Exception ex)
                        {
                            LogHelper.Write(ex, "AutoEducationCoupon");
                            memberCouponRepository.DBSession.Rollback("AutoEducationCoupon");
                            return resultModel;
                        }
                    }
                }
            }
            return resultModel;
        }
        #endregion


        #region 网课小程序个人中心-学习卡中心

        /// <summary>
        /// 领劵中心优惠券
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Coupon_Extend> GetAllCouponList(int pageIndex, int pageSize, out long rowCount, RB_Education_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetAllCouponList(pageIndex, pageSize, out rowCount, query);

            //获取特定商品或者分类的数据
            string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Category;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category))
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Product;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product))
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            return list;
        }



        /// <summary>
        /// 会员优惠券
        /// </summary>
        /// <returns></returns>
        public List<RB_Education_MemberCoupon_Extend> GetMemberDiscountCouponList(RB_Education_MemberCoupon_Extend query)
        {
            return memberCouponRepository.GetList(query);
        }
        #endregion


        #region 我的订单
        /// <summary>
        /// 小程序我的订单列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Order_Extend> GetAppletGoodsMyOrderPageList(int pageIndex, int pageSize, out long count, RB_Goods_Order_Extend demodel)
        {
            var list = goods_OrderRepository.GetEducationOrderPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                //查询订单明细
                var dlist = goods_OrderDetailRepository.GetOrderDetailList(new RB_Goods_OrderDetail_Extend() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId, OrderIds = string.Join(",", list.Select(x => x.OrderId)) });
                foreach (var item in dlist)
                {
                    item.CoverImagePath = item.CoverImage;
                }
                foreach (var item in list)
                {
                    item.DetailList = dlist.Where(x => x.OrderId == item.OrderId).ToList();
                }
            }
            return list;
        }


        /// <summary>
        /// 获取我的订单详情
        /// </summary>
        /// <param name="orderId"></param>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public Common.API.ApiResult GetAppletMyOrderInfo(int orderId, int userId, int tenantId, int mallBaseId)
        {
            var model = goods_OrderRepository.GetEntity(orderId).RefMapperTo<RB_Goods_Order_Extend>();
            if (model == null || model.UserId != userId)
            {
                return Common.API.ApiResult.Failed("订单信息不存在，请核实后再试");
            }
            //查询订单明细
            var dlist = goods_OrderDetailRepository.GetOrderDetailList(new RB_Goods_OrderDetail_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, OrderId = orderId });
            if (dlist.Any())
            {
                string orderDetailIds = string.Join(",", dlist.Select(x => x.Id));
                foreach (var item in dlist)
                {
                    item.CoverImagePath = item.CoverImage;
                    item.IsApplyForAfterSale = 2;
                    if (item.PresentFXGrade > 0)
                    {
                        model.PresentFXGrade = 1;
                    }
                }
            }
            model.DetailList = dlist;

            //是否可以申请售后
            model.IsCanApplyForAfterSale = 2;

            //获取订阅消息
            var miniModel = miniProgramRepository.GetListRepository(new RB_MiniProgram_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId }).FirstOrDefault();

            List<string> template_message_list = new List<string>();

            if (miniModel != null)
            {
                if (!string.IsNullOrWhiteSpace(miniModel.RefundTpl))
                {
                    template_message_list.Add(miniModel.RefundTpl);
                }
                if (!string.IsNullOrWhiteSpace(miniModel.OrderCancelTpl))
                {
                    template_message_list.Add(miniModel.OrderCancelTpl);
                }
            }

            return Common.API.ApiResult.Success("", new
            {
                template_message_list,
                model.OrderId,
                model.OrderNo,
                model.OrderStatus,
                OrderStatusName = model.OrderStatus.GetEnumName(),
                CreateDate = model.CreateDate.HasValue ? model.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                CancelTime = model.CancelTime.HasValue ? model.CancelTime.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                model.PaymentWay,
                PaymentWayName = model.PaymentWay.GetEnumName(),
                model.DeliveryMethod,
                DeliveryMethodName = model.DeliveryMethod.GetEnumName(),
                model.PreferPrice,
                model.Income,
                model.CouponMoney,
                model.FreightMoney,
                model.Consignee,
                model.Mobile,
                DetailList = model.DetailList.Select(x => new
                {
                    DetailId = x.Id,
                    x.GoodsId,
                    x.GoodsName,
                    x.CoverImagePath,
                    SpecificationList = JsonConvert.DeserializeObject<List<string>>(x.Specification),
                    x.Number,
                    x.Final_Price,
                    x.IsComment,
                    x.IsApplyForAfterSale,
                    x.FreeShippingRemarks
                }),
                model.IsApplyForCancel,
                model.RejectRemark,
                model.IsCanApplyForAfterSale,
                model.PresentFXGrade,
                model.BuyerMessage
            });
        }
        #endregion


        #region 我关注的老师
        /// <summary>
        ///我关注的教师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_FollowTeacher_Extend> GetFollowTeacherPageList(int pageIndex, int pageSize, out long rowCount, RB_Education_FollowTeacher_Extend query)
        {
            List<RB_Education_FollowTeacher_Extend> list = followTeacherRepository.GetFollowPageList(pageIndex, pageSize, out rowCount, query);

            return list;
        }

        /// <summary>
        /// 我关注的教师
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Education_FollowTeacher_Extend GetFollowTeacherModel(RB_Education_FollowTeacher_Extend query)
        {
            RB_Education_FollowTeacher_Extend model = followTeacherRepository.GetFollowTeacherList(query).FirstOrDefault();

            return model;
        }

        /// <summary>
        /// 网课-我关注的老师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_FollowTeacher_Extend> GetFollowUserList(RB_Education_FollowTeacher_Extend query)
        {
            List<RB_Education_FollowTeacher_Extend> list = followTeacherRepository.GetFollowUserList(query);

            return list;
        }


        /// <summary>
        /// 我关注的教师
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_FollowTeacher_Extend> GetFollowTeacherList(RB_Education_FollowTeacher_Extend query)
        {
            return followTeacherRepository.GetFollowTeacherList(query);
        }
        /// <summary>
        /// 新增/修改我关注的教师配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateFollowTeacher(RB_Education_FollowTeacher model)
        {
            bool flag = false;
            try
            {

                if (model.ID == 0)
                {
                    flag = followTeacherRepository.Insert(model) > 0;
                }
                else
                {
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Education_FollowTeacher.UpdateDate),System.DateTime.Now},
                        { nameof(RB_Education_FollowTeacher.Status),model.Status}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Education_FollowTeacher.ID),
                              FiledValue=model.ID,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    flag = followTeacherRepository.Update(keyValues, wheres);
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateFollowTeacher");
                return false;
            }
            return flag;
        }
        #endregion

        #region 我的收藏


        /// <summary>
        /// 获取用户收藏商品分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetCollectEducationGoodsPageList(int pageIndex, int pageSize, out long count, RB_Goods_Extend demodel)
        {
            var list = goodsRepository.GetCollectEducationGoodsPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                foreach (var item in list)
                {
                    item.CoverImage = "";
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<string> CarouselIdList = JsonConvert.DeserializeObject<List<string>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = CarouselIdList[0];
                    }
                }
            }
            return list;
        }
        #endregion

        #region 启动页管理
        /// <summary>
        /// 获取启动页信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_StartUp> GetEducationStartUpListRepository(RB_Education_StartUp query)
        {
            return educationStartUpRepository.GetListRepository(query);
        }

        /// <summary>
        /// 新增/修改小程序启动页
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public bool AddOrUpdateEducationStartUp(RB_Education_StartUp query)
        {
            if (query.ID == 0)
            {
                return educationStartUpRepository.Insert(query) > 0;
            }
            else
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Education_StartUp.IsShow),query.IsShow},
                    { nameof(RB_Education_StartUp.PicUrl),query.PicUrl},
                    { nameof(RB_Education_StartUp.MusicUrl),query.MusicUrl},
                    { nameof(RB_Education_StartUp.Seconds),query.Seconds},
                     { nameof(RB_Education_StartUp.UpdateDate),query.UpdateDate},
                };
                return educationStartUpRepository.Update(fileds, new WhereHelper(nameof(RB_Education_StartUp.ID), query.ID));
            }
        }
        #endregion


        #region 评论违规记录
        /// <summary>
        /// 获取用户的违规记录
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_ViolationLog> GetViolationLogList(RB_Education_ViolationLog query)
        {
            return educationViolationLogRepository.GetListRepository(query);
        }

        /// <summary>
        /// 新增用户的违规记录
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetEducationViolationLog(RB_Education_ViolationLog model)
        {
            //设置消息推送
            miai_MessageRepository.Insert(new Model.Extend.Miai.RB_Miai_Message_Extend()
            {
                Id = 0,
                Type = Common.Enum.MiAi.MessageTypeEnum.ViolationNotice,
                UserId = model.UserId ?? 0,
                SourceId =0,
                Content = "您评论内容出现违规文字",
                Status = 0,
                TenantId = model.TenantId,
                MallBaseId = model.MallBaseId,
                CreateBy = model.UserId ?? 0,
                CreateDate = DateTime.Now,
                UpdateDate = DateTime.Now
            });
            return educationViolationLogRepository.Insert(model) > 0;
        }

        /// <summary>
        /// 将用户加入黑名单
        /// </summary>
        /// <param name="TenantId"></param>
        /// <param name="MallBaseId"></param>
        /// <param name="UserId"></param>
        /// <returns></returns>
        public bool UpdateUserBlacklist(int TenantId, int MallBaseId, int UserId)
        {
            Dictionary<string, object> cols = new Dictionary<string, object>()
            {
                { nameof(RB_Member_User.Blacklist),1}
            };
            List<WhereHelper> wheres = new List<WhereHelper>()
            {
                  new WhereHelper(){
                      FiledName=nameof(RB_Member_User.Id),
                     FiledValue=UserId,
                     OperatorEnum=OperatorEnum.Equal
                  },
                    new WhereHelper(){
                                            FiledName=nameof(RB_Member_User.TenantId),
                                            FiledValue=TenantId,
                                            OperatorEnum=OperatorEnum.Equal
                                    },
                                    new WhereHelper(){
                                            FiledName=nameof(RB_Member_User.MallBaseId),
                                            FiledValue=MallBaseId,
                                            OperatorEnum=OperatorEnum.Equal
                                    }
            };
            return member_UserRepository.Update(cols, wheres);
        }
        #endregion
    }
}
