﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 海报处理类
    /// </summary>
    public class PosterModule
    {
        /// <summary>
        /// 分销海报仓储层对象
        /// </summary>
        private readonly RB_MiniProgram_FenXiaoPosterRepository fenXiaoPosterRepository = new RB_MiniProgram_FenXiaoPosterRepository();


        /// <summary>
        /// 商品分销仓储层对象
        /// </summary>
        private readonly RB_MiniProgram_GoodPosterRepository goodPosterRepository = new RB_MiniProgram_GoodPosterRepository();

        /// <summary>
        /// 根据查询条件获取分销海报实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_MiniProgram_FenXiaoPoster_Extend GetFenXiaoPosterEntityModule(RB_MiniProgram_FenXiaoPoster_Extend query)
        {
            return fenXiaoPosterRepository.GetEntityExtRepository(query);
        }

        /// <summary>
        /// 添加修改分销海报
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetFenXiaoPosterModule(RB_MiniProgram_FenXiaoPoster_Extend extModel) 
        {
            bool flag;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.PosterBgImg),extModel.PosterBgImg},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.IsShowHead),extModel.IsShowHead},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.HeadSize),extModel.HeadSize},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.HeadPaddingTop),extModel.HeadPaddingTop},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.HeadPaddingLeft),extModel.HeadPaddingLeft},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.IsShowNick),extModel.IsShowNick},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.NickSize),extModel.NickSize},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.NickPaddingTop),extModel.NickPaddingTop},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.NickPaddingLeft),extModel.NickPaddingLeft},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.NickColor),extModel.NickColor},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.IsShowQrCode),extModel.IsShowQrCode},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.QrCodeSize),extModel.QrCodeSize},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.QrCodePaddingTop),extModel.QrCodePaddingTop},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.QrCodePaddingLeft),extModel.QrCodePaddingLeft},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.QrCodeType),extModel.QrCodeType},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.IsOpenSchool),extModel.IsOpenSchool},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.IsShowCover),extModel.IsShowCover},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.CoverHeight),extModel.CoverHeight},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.CoverWidth),extModel.CoverWidth},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.CoverPaddingTop),extModel.CoverPaddingTop},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.CoverPaddingLeft),extModel.CoverPaddingLeft},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.IsShowTitle),extModel.IsShowTitle},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.TitleSize),extModel.TitleSize},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.TitleColor),extModel.TitleColor},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.TitlePaddingTop),extModel.TitlePaddingTop},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.TitlePaddingLeft),extModel.TitlePaddingLeft},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.TitleRow),extModel.TitleRow},
                };
                flag = fenXiaoPosterRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_FenXiaoPoster_Extend.Id), extModel.Id));
            }
            else
            {
                int NewId = fenXiaoPosterRepository.Insert(extModel);
                extModel.Id = NewId;
                flag = NewId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据查询条件获取商品海报实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_MiniProgram_GoodPoster_Extend GetGoodPosterEntityModule(RB_MiniProgram_GoodPoster_Extend query)
        {
            return goodPosterRepository.GetEntityExtRepository(query);
        }

        /// <summary>
        /// 添加修改商品海报
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetGoodPosterModule(RB_MiniProgram_GoodPoster_Extend extModel)
        {
            bool flag;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram_GoodPoster_Extend.PosterStyle),extModel.PosterStyle},
                    { nameof(RB_MiniProgram_GoodPoster_Extend.GoodsImgCount),extModel.GoodsImgCount},
                    { nameof(RB_MiniProgram_GoodPoster_Extend.IsOpenSchool),extModel.IsOpenSchool},
                };
                flag = goodPosterRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_GoodPoster_Extend.Id), extModel.Id));
            }
            else
            {
                int NewId = goodPosterRepository.Insert(extModel);
                extModel.Id = NewId;
                flag = NewId > 0;
            }
            return flag;
        }
    }
}
