﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 和平分销返佣仓储层
    /// </summary>
    public class RB_Distributor_HPCommissionRepository : RepositoryBase<RB_Distributor_HPCommission>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_HPCommission_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Distributor_HPCommission_Extend dmodel)
        {
            string where = $@" 1=1 and h.{nameof(RB_Distributor_HPCommission.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and h.{nameof(RB_Distributor_HPCommission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and h.{nameof(RB_Distributor_HPCommission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and h.{nameof(RB_Distributor_HPCommission.Id)}={dmodel.Id}";
            }
            if (dmodel.CategoryId > 0) {
                where += $@" and c.{nameof(RB_Distributor_HPCategory.CategoryId)}={dmodel.CategoryId}";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryIds)) {
                where += $@" and c.{nameof(RB_Distributor_HPCategory.CategoryId)} in({dmodel.CategoryIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryIdsT))
            {
                where += $@" and (c.{nameof(RB_Distributor_HPCategory.CategoryId)} in({dmodel.CategoryIdsT}) or c.{nameof(RB_Distributor_HPCategory.CategoryId)}=-1)";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and h.{nameof(RB_Distributor_HPCommission.Name)} like '%{dmodel.Name}%'";
            }
            
            string sql = $@"select h.* from RB_Distributor_HPCommission h
left join RB_Distributor_HPCategory c on h.Id = c.CommissionId
where {where} group by h.Id order by h.Id desc";
            return GetPage<RB_Distributor_HPCommission_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_HPCommission_Extend> GetList(RB_Distributor_HPCommission_Extend dmodel)
        {
            string where = $@" 1=1 and h.{nameof(RB_Distributor_HPCommission.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and h.{nameof(RB_Distributor_HPCommission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and h.{nameof(RB_Distributor_HPCommission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and h.{nameof(RB_Distributor_HPCommission.Id)}={dmodel.Id}";
            }
            if (dmodel.CategoryId > 0)
            {
                where += $@" and c.{nameof(RB_Distributor_HPCategory.CategoryId)}={dmodel.CategoryId}";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryIds))
            {
                where += $@" and c.{nameof(RB_Distributor_HPCategory.CategoryId)} in({dmodel.CategoryId})";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryIdsT))
            {
                where += $@" and (c.{nameof(RB_Distributor_HPCategory.CategoryId)} in({dmodel.CategoryIdsT}) or c.{nameof(RB_Distributor_HPCategory.CategoryId)}=-1)";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and h.{nameof(RB_Distributor_HPCommission.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.IsCommon == 1) {
                where += $@" and h.{nameof(RB_Distributor_HPCommission.IsCommon)}=1";
            }

            string sql = $@"select h.* from RB_Distributor_HPCommission h
left join RB_Distributor_HPCategory c on h.Id = c.CommissionId
where {where} group by h.Id order by h.Id desc";
            return Get<RB_Distributor_HPCommission_Extend>(sql).ToList();
        }
    }
}
