﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using VT.FW.DB.Dapper;

namespace Mall.Repository.MarketingCenter
{
    /// <summary>
    /// 分享详情实体仓储层
    /// </summary>
    public class RB_Share_FriendRepository : BaseRepository<RB_Share_Friend>
    {
        /// <summary>
        /// 获取分享详情分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowsCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Share_Friend_Extend> GetShareFriendPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Share_Friend_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,B.Name AS GoodsName
FROM rb_share_friend AS A  LEFT JOIN rb_goods AS B ON A.GoodsId=B.Id
WHERE 1=1 AND A.Status=0
");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND A.{nameof(RB_Share_Friend_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND A.{nameof(RB_Share_Friend_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.CateId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Share_Friend_Extend.CateId),query.CateId);
                }
                if (!string.IsNullOrWhiteSpace(query.CateIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Share_Friend_Extend.CateId), query.CateIds);
                }
                if (!string.IsNullOrWhiteSpace(query.KeyWords))
                {
                    builder.AppendFormat(" AND A.{0} LIKE '%{1}%' ", nameof(RB_Share_Friend_Extend.MaterialInfo), query.KeyWords);
                }
                if (!string.IsNullOrWhiteSpace(query.QStartDate))
                {
                    builder.AppendFormat(" AND A.{0}>='{1}' ", nameof(RB_Share_Friend_Extend.CreateDate), Convert.ToDateTime(query.QStartDate).ToString("yyyy-MM-dd"));
                }
                if (!string.IsNullOrWhiteSpace(query.QEndDate))
                {
                    builder.AppendFormat(" AND A.{0}<='{1} 23:59:59' ", nameof(RB_Share_Friend_Extend.CreateDate), Convert.ToDateTime(query.QEndDate).ToString("yyyy-MM-dd"));
                }
            }
            return GetPage<RB_Share_Friend_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取分享详情列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Share_Friend_Extend> GetShareFriendListRepository(RB_Share_Friend_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_share_friend
WHERE 1=1 AND Status=0
");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Friend_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Friend_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.CateId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Share_Friend_Extend.CateId), query.CateId);
                }
                if (!string.IsNullOrWhiteSpace(query.CateIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Share_Friend_Extend.CateId), query.CateIds);
                }
                if (!string.IsNullOrWhiteSpace(query.KeyWords))
                {
                    builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Share_Friend_Extend.MaterialInfo), query.KeyWords);
                }
                if (!string.IsNullOrWhiteSpace(query.QStartDate))
                {
                    builder.AppendFormat(" AND {0}>='{1}' ", nameof(RB_Share_Friend_Extend.CreateDate), Convert.ToDateTime(query.QStartDate).ToString("yyyy-MM-dd"));
                }
                if (!string.IsNullOrWhiteSpace(query.QEndDate))
                {
                    builder.AppendFormat(" AND {0}<='{1} 23:59:59' ", nameof(RB_Share_Friend_Extend.CreateDate), Convert.ToDateTime(query.QEndDate).ToString("yyyy-MM-dd"));
                }
            }
            return Get<RB_Share_Friend_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取分享详情实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_Share_Friend_Extend GetShareFriendEntityRepository(RB_Share_Friend_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,B.Name AS GoodsName
FROM rb_share_friend AS A  LEFT JOIN rb_goods AS B ON A.GoodsId=B.Id
WHERE 1=1 AND A.Status=0
");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND A.{nameof(RB_Share_Friend_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND A.{nameof(RB_Share_Friend_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.CateId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Share_Friend_Extend.CateId), query.CateId);
                }
                if (!string.IsNullOrWhiteSpace(query.CateIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Share_Friend_Extend.CateId), query.CateIds);
                }
                if (!string.IsNullOrWhiteSpace(query.KeyWords))
                {
                    builder.AppendFormat(" AND A.{0} LIKE '%{1}%' ", nameof(RB_Share_Friend_Extend.MaterialInfo), query.KeyWords);
                }
                if (!string.IsNullOrWhiteSpace(query.QStartDate))
                {
                    builder.AppendFormat(" AND A.{0}>='{1}' ", nameof(RB_Share_Friend_Extend.CreateDate), Convert.ToDateTime(query.QStartDate).ToString("yyyy-MM-dd"));
                }
                if (!string.IsNullOrWhiteSpace(query.QEndDate))
                {
                    builder.AppendFormat(" AND A.{0}<='{1} 23:59:59' ", nameof(RB_Share_Friend_Extend.CreateDate), Convert.ToDateTime(query.QEndDate).ToString("yyyy-MM-dd"));
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Share_Friend_Extend.Id), query.Id);
                }
            }
            return Get<RB_Share_Friend_Extend>(builder.ToString()).FirstOrDefault();
        }

        /// <summary>
        /// 新增修改文案信息
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetShareFrendRepository(RB_Share_Friend_Extend extModel)
        {
            bool flag = false;
            DynamicParameters dynamicParameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.Append(" SET NAMES utf8mb4; ");
            if (extModel.Id > 0)
            {
                builder.Append(@" UPDATE rb_share_friend SET CateId=@CateId,GoodsId=@GoodsId,CoverImg=@CoverImg,MaterialImg=@MaterialImg,MaterialInfo=@MaterialInfo,LinkUrl=@LinkUrl,IsTop=@IsTop,SortNum=@SortNum,UpdateBy=@UpdateBy,UpdateDate=@UpdateDate WHERE Id=@Id ");
                dynamicParameters.Add("CateId", extModel.CateId);
                dynamicParameters.Add("GoodsId", extModel.GoodsId);
                dynamicParameters.Add("CoverImg", extModel.CoverImg);
                dynamicParameters.Add("MaterialImg", extModel.MaterialImg);
                dynamicParameters.Add("MaterialInfo", extModel.MaterialInfo);
                dynamicParameters.Add("LinkUrl", extModel.LinkUrl);
                dynamicParameters.Add("IsTop", extModel.IsTop);
                dynamicParameters.Add("SortNum", extModel.SortNum);
                dynamicParameters.Add("UpdateBy", extModel.UpdateBy);
                dynamicParameters.Add("UpdateDate", extModel.UpdateDate);
                dynamicParameters.Add("Id", extModel.Id);
                flag = base.Execute(builder.ToString(),dynamicParameters) > 0;
            }
            else
            {
                builder.Append(@" INSERT INTO rb_share_friend(CateId,GoodsId,CoverImg,MaterialImg,MaterialInfo,LinkUrl,IsTop,SortNum,IsUse,Status,TenantId,MallBaseId,CreateBy,CreateDate,UpdateBy,UpdateDate) ");
                builder.Append("      VALUES(@CateId,@GoodsId,@CoverImg,@MaterialImg,@MaterialInfo,@LinkUrl,@IsTop,@SortNum,@IsUse,@Status,@TenantId,@MallBaseId,@CreateBy,@CreateDate,@UpdateBy,@UpdateDate)");
                dynamicParameters.Add("CateId", extModel.CateId);
                dynamicParameters.Add("GoodsId", extModel.GoodsId);
                dynamicParameters.Add("CoverImg", extModel.CoverImg);
                dynamicParameters.Add("MaterialImg", extModel.MaterialImg);
                dynamicParameters.Add("MaterialInfo", extModel.MaterialInfo);
                dynamicParameters.Add("LinkUrl", extModel.LinkUrl);
                dynamicParameters.Add("IsTop", extModel.IsTop);
                dynamicParameters.Add("SortNum", extModel.SortNum);
                dynamicParameters.Add("IsUse", extModel.IsUse);
                dynamicParameters.Add("Status", extModel.Status);
                dynamicParameters.Add("TenantId", extModel.TenantId);
                dynamicParameters.Add("MallBaseId", extModel.MallBaseId);
                dynamicParameters.Add("CreateBy", extModel.CreateBy);
                dynamicParameters.Add("CreateDate", extModel.CreateDate);
                dynamicParameters.Add("UpdateBy", extModel.UpdateBy);
                dynamicParameters.Add("UpdateDate", extModel.UpdateDate);
                flag = base.Execute(builder.ToString(), dynamicParameters) > 0;
            }
            return flag;
        }
    }
}