﻿using Mall.Model.Entity.AppletWeChat;
using Mall.Repository.AppletWeChat;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Module.AppletWeChat
{
    public class AppletWeChatModule
    {
        private RB_AppletWeChatRepository appletWeChatRepository = new RB_AppletWeChatRepository();
        private RB_AppletWechat_MsgEmplateRepository msgEmplateRepository = new RB_AppletWechat_MsgEmplateRepository();

        #region 微信小程序基础配置
        /// <summary>
        /// 获取微信基础配置
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_AppletWeChat> GetAppletWeChatList(RB_AppletWeChat query)
        {

            return appletWeChatRepository.GetAppletWeChatList(query);
        }


        /// <summary>
        /// 新增微信小程序配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateAppletWeChat(RB_AppletWeChat model)
        {
            if (model.ID == 0)
            {
                return appletWeChatRepository.Insert(model) > 0;
            }
            else
            {
                return appletWeChatRepository.Update(model);
            }
        }
        #endregion


        #region 微信小程序消息模板
        /// <summary>
        /// 获取微信小程序消息配置
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_AppletWechat_MsgEmplate> GetMsgEmplateList(RB_AppletWechat_MsgEmplate query)
        {

            return msgEmplateRepository.GetMsgEmplateList(query);
        }


        /// <summary>
        /// 新增/修改微信小程序消息配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateMsgEmplate(RB_AppletWechat_MsgEmplate model)
        {
            if (model.ID == 0)
            {
                return msgEmplateRepository.Insert(model) > 0;
            }
            else
            {
                return msgEmplateRepository.Update(model);
            }
        }
        #endregion
    }
}
