﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品关联规格仓储层
    /// </summary>
    public class RB_Goods_SpecificationRepository : RepositoryBase<RB_Goods_Specification>
    {

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_Specification_Extend> GetList(RB_Goods_Specification_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Goods_Specification.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Goods_Specification.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Goods_Specification.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Goods_Specification.Id)}={dmodel.Id}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and {nameof(RB_Goods_Specification.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and {nameof(RB_Goods_Specification.GoodsId)} in({dmodel.GoodsIds})";
            }
            
            string sql = $@"select * from RB_Goods_Specification where {where} order by Id desc";
            return Get<RB_Goods_Specification_Extend>(sql).ToList();
        }
    }
}
