﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Module.AppletWeChat;
using Mall.Model.Entity.AppletWeChat;

namespace Mall.WebApi.Controllers.AppletWeChat
{

    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletWeChatController : BaseController
    {

        private AppletWeChatModule appletWeChatModule = new AppletWeChatModule();

        #region 微信小程序基础配置
        /// <summary>
        /// 新增/修改微信小程序基础配置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult AddOrUpdateAppletWeChat()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_AppletWeChat>(RequestParm.msg.ToString());
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入操作的小程序配置");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.AppId))
                {
                    return ApiResult.Failed("请输入小程序AppId");
                }
                if (string.IsNullOrWhiteSpace(query.AppSecret))
                {
                    return ApiResult.Failed("请输入小程序appSecret");
                }
                if (string.IsNullOrWhiteSpace(query.BusinessNO))
                {
                    return ApiResult.Failed("请输入微信支付商户号");
                }
                if (string.IsNullOrWhiteSpace(query.ApiSecret))
                {
                    return ApiResult.Failed("请输入微信支付Api密钥");
                }
                query.TenantId = UserInfo.TenantId;
                bool result = appletWeChatModule.AddOrUpdateAppletWeChat(query);
                if (result)
                {
                    return ApiResult.Success("基础信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("基础信息保存失败");
                }

            }
        }

        /// <summary>
        /// 获取微信小程序基础信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletWeChatInfo()
        {
            var parms = RequestParm;
            var query = new RB_AppletWeChat();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var model = appletWeChatModule.GetAppletWeChatList(query).FirstOrDefault();
            if (model == null)
            {
                model = new RB_AppletWeChat();
            }
            return ApiResult.Success("获取成功", model);
        }
        #endregion


        #region 微信小程序消息模板
        /// <summary>
        /// 新增/修改微信小程序消息模板
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult AddOrUpdateMsgEmplate()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_AppletWechat_MsgEmplate>(RequestParm.msg.ToString());
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入消息通知信息");
            }
            else
            {
                query.TenantId = UserInfo.TenantId;
                bool result = appletWeChatModule.AddOrUpdateMsgEmplate(query);
                if (result)
                {
                    return ApiResult.Success("消息通知配置保存成功");
                }
                else
                {
                    return ApiResult.Failed("消息通知配置保存失败");
                }

            }
        }

        /// <summary>
        /// 获取微信小程序消息模板信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMsgEmplateInfo()
        {
            var parms = RequestParm;
            var query = new RB_AppletWechat_MsgEmplate();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var model = appletWeChatModule.GetMsgEmplateList(query).FirstOrDefault();
            if (model == null)
            {
                model = new RB_AppletWechat_MsgEmplate();
            }
            return ApiResult.Success("获取成功", model);
        }
        #endregion

    }
}