﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 榜单实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_FirstShop_List
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 榜单类型  枚举
        /// </summary>
        public ListTypeEnum ListType { get; set; }

        /// <summary>
        /// 面向群体   枚举
        /// </summary>
        public string ObjectTypeIds { get; set; }

        /// <summary>
        /// 主办方
        /// </summary>
        public string Sponsor { get; set; }

        /// <summary>
        /// 榜单名称
        /// </summary>
        public string ListName { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }

        /// <summary>
        /// 报名截止日期
        /// </summary>
        public DateTime DeadlineDate { get; set; }

        /// <summary>
        /// 公示日期
        /// </summary>
        public DateTime StartDate { get; set; }

        /// <summary>
        /// 详细内容
        /// </summary>
        public string Content { get; set; }

        /// <summary>
        /// 是否启用排名  1是
        /// </summary>
        public int EnableRank { get; set; }

        /// <summary>
        /// 入围名额
        /// </summary>
        public int PrizeNum { get; set; }

        /// <summary>
        /// 绑定状态  枚举
        /// </summary>
        public ListStateEnum ListState { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

    }
}
