﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 载体信息仓储层
    /// </summary>
    public class RB_CarrierRepository : BaseRepository<RB_Carrier>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Carrier); } }
        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Carrier_Extend> GetCarrierPageList(int pageIndex, int pageSize, out long rowCount, RB_Carrier_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_Carrier_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ProjectType.HasValue && query.ProjectType > 0)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.ProjectType)}={(int)query.ProjectType}");
                }
                if (!string.IsNullOrWhiteSpace(query.CarrierName))
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.CarrierName)} like '%{query.CarrierName}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.Developers))
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.Developers)} like '%{query.Developers}%'");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.UserId)}={query.UserId}");
                }
                if (query.OpeningStatus > -1)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.OpeningStatus)}={query.OpeningStatus}");
                }
                if (query.FirstStoreTest > -1)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.FirstStoreTest)}={query.FirstStoreTest}");
                }
                if (!string.IsNullOrWhiteSpace(query.StartOpenTime))
                {
                    builder.Append($" and  DATE_FORMAT({nameof(RB_Carrier_Extend.OpenTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.StartOpenTime}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrWhiteSpace(query.EndOpenTime))
                {
                    builder.Append($" and  DATE_FORMAT({nameof(RB_Carrier_Extend.OpenTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.EndOpenTime}','%Y-%m-%d' ) ");
                }

                if (query.MetroNum > 0 || !string.IsNullOrWhiteSpace(query.MetroName))
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.ID)} in (SELECT CarrierId from rb_carriermetro where `Status`=0  ");
                    if (query.MetroNum > 0)
                    {
                        builder.Append($" AND {nameof(RB_Carrier_Extend.MetroNum)} = {query.MetroNum}");
                    }
                    if (!string.IsNullOrWhiteSpace(query.MetroName))
                    {
                        builder.Append($" AND {nameof(RB_Carrier_Extend.MetroName)} like '%{query.MetroName}%'");
                    }
                    builder.Append(" )");
                }

                if (query.OrderBy == 1)
                {
                    builder.Append($" order by {nameof(RB_Carrier_Extend.CreateDate)} desc");
                }
                else if (query.OrderBy == 2) {
                    builder.Append($" order by {nameof(RB_Carrier_Extend.OpenTime)} desc");
                }
            }
            return GetPage<RB_Carrier_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Carrier_Extend> GetCarrierList(RB_Carrier_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Carrier_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.ID)}={query.ID}");
                }
                if (!string.IsNullOrWhiteSpace(query.QCarrierIds))
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.ID)} in ({query.QCarrierIds})");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.UserId)}={query.UserId}");
                }
                if (query.UserId == -1)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.UserId)}=0");
                }
                if (query.ProjectType.HasValue && query.ProjectType > 0)
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.ProjectType)}={(int)query.ProjectType}");
                }
                if (!string.IsNullOrWhiteSpace(query.CarrierName))
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.CarrierName)} like '%{query.CarrierName}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.Developers))
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.Developers)} like '%{query.Developers}%'");
                }

                if (!string.IsNullOrWhiteSpace(query.StartOpenTime))
                {
                    builder.Append($" and  DATE_FORMAT({nameof(RB_Carrier_Extend.OpenTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.StartOpenTime}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrWhiteSpace(query.EndOpenTime))
                {
                    builder.Append($" and  DATE_FORMAT({nameof(RB_Carrier_Extend.OpenTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.EndOpenTime}','%Y-%m-%d' ) ");
                }
                if (query.MetroNum > 0 || !string.IsNullOrWhiteSpace(query.MetroName))
                {
                    builder.Append($" AND {nameof(RB_Carrier_Extend.ID)} in (SELECT CarrierId from rb_carriermetro where `Status`=0  ");
                    if (query.MetroNum > 0)
                    {
                        builder.Append($" AND {nameof(RB_Carrier_Extend.MetroNum)} = {query.MetroNum}");
                    }
                    if (!string.IsNullOrWhiteSpace(query.MetroName))
                    {
                        builder.Append($" AND {nameof(RB_Carrier_Extend.MetroName)} like '%{query.MetroName}%'");
                    }
                    builder.Append(" )");
                }
                if (query.OrderBy == 1)
                {
                    builder.Append($" order by {nameof(RB_Carrier_Extend.CreateDate)} desc");
                }
                else if (query.OrderBy == 2)
                {
                    builder.Append($" order by {nameof(RB_Carrier_Extend.OpenTime)} desc");
                }
            }
            return Get<RB_Carrier_Extend>(builder.ToString()).ToList();
        }
    }
}
