﻿using Mall.Common.AOP;
using Mall.Common.Enum.MallBase;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 小程序实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public  class RB_MiniProgram
    {
        /// <summary>
        /// 小程序主键Id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 商城名称
        /// </summary>        
        public string MallName
        {
            get;
            set;
        }

        /// <summary>
        /// 是否永久有效(1-永久有效）
        /// </summary>        
        public int? IsEffective
        {
            get;
            set;
        }

        /// <summary>
        /// 商城有效期
        /// </summary>        
        public DateTime? MallValidate
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 状态(0-正常，1-禁用)
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 版权文字
        /// </summary>
        public string CopyRightWord { get; set; }

        /// <summary>
        /// 版权图片
        /// </summary>
        public string CopyRightImg { get; set; }

        /// <summary>
        /// 版权链接页面
        /// </summary>
        public string CopyRightLink { get; set; }

        /// <summary>
        /// 商城风格
        /// </summary>
        public MallShopStyleEnum MallShopStyle { get; set; }

        /// <summary>
        /// 顶部标题文件颜色类型(0-白色，1-黑色)
        /// </summary>
        public int TopNavWordType { get; set; }

        /// <summary>
        /// 顶部标题文字颜色
        /// </summary>
        public string TopNavWordColor { get; set; }

        /// <summary>
        /// 顶部导航栏背景颜色
        /// </summary>
        public string TopNavBgColor { get; set; }

        /// <summary>
        /// 底部导航栏背景颜色
        /// </summary>
        public string BottomNavBgColor { get; set; }

        /// <summary>
        /// 导航底部是否开启阴影效果(0-未开启，1-开启)
        /// </summary>
        public int BottomNavIsShadow { get; set; }

        /// <summary>
        /// 是否开启版权设置(0-开启,1-关闭)
        /// </summary>
        public int IsOpenCopyRight { get; set; }

        /// <summary>
        /// 小程序AppId
        /// </summary>        
        public string MiniAppId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序AppSecret
        /// </summary>        
        public string MiniAppSecret
        {
            get;
            set;
        }

        /// <summary>
        /// 微信支付商户号
        /// </summary>        
        public string WeChatPayMerchants
        {
            get;
            set;
        }

        /// <summary>
        /// 微信支付Api密钥
        /// </summary>        
        public string WeChatApiSecret
        {
            get;
            set;
        }

        /// <summary>
        /// 微信支付证书
        /// </summary>        
        public string WeChatPayCertificate
        {
            get;
            set;
        }

        /// <summary>
        /// 微信支付私钥
        /// </summary>        
        public string WeChatPayPrivateKey
        {
            get;
            set;
        }

        /// <summary>
        /// 下单成功提醒(类目:服装/鞋/箱包)
        /// </summary>        
        public string OrderSuccessTpl
        {
            get;
            set;
        }

        /// <summary>
        /// 订单取消提醒(类目:服装/鞋/箱包)
        /// </summary>        
        public string OrderCancelTpl
        {
            get;
            set;
        }

        /// <summary>
        /// 订单发货提醒(类目:服装/鞋/箱包)
        /// </summary>        
        public string OrderDeliverGoodsTpl
        {
            get;
            set;
        }

        /// <summary>
        /// 退款提醒(类目:服装/鞋/箱包)
        /// </summary>        
        public string RefundTpl
        {
            get;
            set;
        }

        /// <summary>
        /// 活动状态提醒(类目:服装/鞋/箱包)
        /// </summary>        
        public string ActiveStateTpl
        {
            get;
            set;
        }

        /// <summary>
        /// 审核结果提醒(类目:服装/鞋/箱包)
        /// </summary>        
        public string AuditResultTpl
        {
            get;
            set;
        }

        /// <summary>
        /// 提现成功通知(类目: 服装/鞋/箱包 )
        /// </summary>        
        public string ReflectSuccessTpl
        {
            get;
            set;
        }

        /// <summary>
        /// 提现失败通知(类目: 服装/鞋/箱包 )
        /// </summary>        
        public string ReflectFailTpl
        {
            get;
            set;
        }

        /// <summary>
        /// 会员等级变更通知(类目: 服装/鞋/箱包 )
        /// </summary>        
        public string MembersLevelChangeTpl
        {
            get;
            set;
        }

        #region 会员中心配置
        /// <summary>
        /// 会员中心默认背景
        /// </summary>        
        public string DefaultBgImg
        {
            get;
            set;
        }

        /// <summary>
        /// 会员中心普通用户背景
        /// </summary>        
        public string MemberBgImg
        {
            get;
            set;
        }

        /// <summary>
        /// 会员中心Vip背景
        /// </summary>        
        public string VipBgImg
        {
            get;
            set;
        }

        /// <summary>
        /// 会员中心头像样式类型(1-头像靠左，2-头像居中，3-头像内嵌)
        /// </summary>        
        public int? HeadStyle
        {
            get;
            set;
        }

        /// <summary>
        /// 会员中心头像样式字符串
        /// </summary>        
        public string HeadStyleStr
        {
            get;
            set;
        }

        /// <summary>
        /// 是否显示收藏夹(0-显示，1-不显示)
        /// </summary>        
        public int? IsShowFavorite
        {
            get;
            set;
        }

        /// <summary>
        /// 是否显示订单栏(0-显示，1-不显示)
        /// </summary>        
        public int? IsShowOrderNav
        {
            get;
            set;
        }

        /// <summary>
        /// 是否显示账户栏(0-显示，1-不显示)
        /// </summary>        
        public int? IsShowAccountNav
        {
            get;
            set;
        }

        /// <summary>
        /// 是否显示菜单栏(0-显示，1-不显示)
        /// </summary>        
        public int? IsShowMenuNav
        {
            get;
            set;
        }

        /// <summary>
        /// 菜单栏标题
        /// </summary>        
        public string MenuNavTitle
        {
            get;
            set;
        }

        /// <summary>
        /// 菜单栏样式(0-列表,1-九宫格)
        /// </summary>        
        public int? MenuNavStyle
        {
            get;
            set;
        }

        #endregion

        #region  获取可跳转小程序
        /// <summary>
        /// 获取可跳转小程序
        /// </summary>
        public string JumpAppId { get; set; }
        #endregion

        /// <summary>
        ///小程序直播组件 0-否，1-是
        /// </summary>
        public int LivePlayerPlugin { get; set; }


        /// <summary>
        /// 发布时填写的版本号
        /// </summary>
        public string Version { get; set; }

    }
}
