﻿using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Entity.User;
using Mall.Model.Extend.BaseSetUp;
using Mall.Repository;
using Mall.Repository.BaseSetUp;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Module.BaseSetUp
{
    public class MallBaseModule
    {
        private RB_MiniProgramRepository miniProgramRepository = new RB_MiniProgramRepository();
        private RB_MallBaseRepository mallBaseRepository = new RB_MallBaseRepository();
        private RB_LogisticsRepository logisticsRepository = new RB_LogisticsRepository();
        private RB_Logistics_RulesPriceRepository logisticsRulesPriceRepository = new RB_Logistics_RulesPriceRepository();
        private RB_Logistics_RulesRegionRepository logisticsRulesRegionRepository = new RB_Logistics_RulesRegionRepository();
        private RB_Logistics_RulesRepository logisticsRulesRepository = new RB_Logistics_RulesRepository();


        #region 基础设置
        /// <summary>
        /// 获取小程序列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MallBase_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_MallBase_Extend query)
        {
            return mallBaseRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MallBase_Extend> GetListRepository(RB_MallBase_Extend query)
        {
            return mallBaseRepository.GetListRepository(query);
        }


        /// <summary>
        /// 根据编号获取实体
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>

        public RB_MallBase GetMallBaseEntity(int ID)
        {

            return mallBaseRepository.GetEntity(ID);
        }


        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateMallBase(RB_MallBase_Extend model)
        {
            bool flag = false;
            var trans = mallBaseRepository.DbTransaction;
            try
            {
                if (model.ID == 0)
                {
                    flag = mallBaseRepository.Insert(model) > 0;
                }
                else
                {
                    flag = mallBaseRepository.Update(model);
                }
                IDictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram.MallName),model.MallName},
                };
                IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_MiniProgram.MallBaseId),FiledValue=model.MallBaseId,OperatorEnum=OperatorEnum.Equal}
                };
                miniProgramRepository.Update(fileds, whereHelpers, trans);

                mallBaseRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetDefaultLogisticsRules");
                mallBaseRepository.DBSession.Rollback("SetDefaultLogisticsRules");
                return false;
            }
            return flag;
        }
        #endregion


        #region 物流设置
        /// <summary>
        /// 根据商户id获取物流信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics> GetLogisticsList(RB_Logistics query)
        {
            return logisticsRepository.GetListRepository(query);
        }


        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateLogistics(RB_Logistics model)
        {
            if (model.ID == 0)
            {
                return logisticsRepository.Insert(model) > 0;
            }
            else
            {
                return logisticsRepository.Update(model);
            }
        }
        #endregion

        #region 物流规则设置
        /// <summary>
        /// 物料规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Rules_Extend> GetLogisticsRulesList(int pageIndex, int pageSize, out long rowCount, RB_Logistics_Rules_Extend query)
        {
            return logisticsRulesRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 物流规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Rules_Extend> GetLogisticsRulesList(RB_Logistics_Rules_Extend query)
        {
            return logisticsRulesRepository.GetLogisticsRulesList(query);
        }

        public RB_Logistics_Rules_Extend GetLogisticsRulesModel(RB_Logistics_Rules_Extend query)
        {
            RB_Logistics_Rules_Extend model = logisticsRulesRepository.GetLogisticsRulesList(query).FirstOrDefault();
            //获取价格规则
            List<RB_Logistics_RulesPrice_Extend> ListPrice = logisticsRulesPriceRepository.GetListRepository(new RB_Logistics_RulesPrice_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, RulesId = query.ID });

            List<RB_Logistics_RulesRegion_Extend> listLogisticsRulesRegion = logisticsRulesRegionRepository.GetListRepository(new RB_Logistics_RulesRegion_Extend { TenantId = query.TenantId, RulesType = Common.Enum.MallBase.RulesTypeEnum.Rule, MallBaseId = query.MallBaseId, PriceIds = string.Join(",", ListPrice.Select(x => x.ID)) });

            model.Detail = new List<RB_Logistics_RulesPrice_Extend>();
            model.Detail = ListPrice;

            foreach (var item in model.Detail)
            {
                item.List = new List<RB_Logistics_RulesRegion_Extend>();
                item.List = listLogisticsRulesRegion.Where(x => x.RulesPriceId == item.ID).ToList();
            }
            return model;
        }



        public bool SetDefaultLogisticsRules(RB_Logistics_Rules_Extend query)
        {
            bool flag = false;
            var trans = logisticsRulesRepository.DbTransaction;
            try
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.IsDefault),0},
                };
                IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_Logistics_Rules.MallBaseId),FiledValue=query.MallBaseId,OperatorEnum=OperatorEnum.Equal}
                };
                logisticsRulesPriceRepository.Update(fileds, whereHelpers, trans);

                IDictionary<string, object> filedsDefault = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.IsDefault),1},
                };
                IList<WhereHelper> whereHelpersDefault = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_Logistics_Rules.ID),FiledValue=query.ID,OperatorEnum=OperatorEnum.Equal}
                };
                logisticsRulesPriceRepository.Update(filedsDefault, whereHelpersDefault, trans);
                logisticsRulesRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetDefaultLogisticsRules");
                logisticsRulesRepository.DBSession.Rollback("SetDefaultLogisticsRules");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateLogisticsRules(RB_Logistics_Rules_Extend model)
        {
            bool flag = false;
            var trans = logisticsRulesRepository.DbTransaction;
            try
            {
                int rulesId = 0;
                if (model.ID == 0)
                {
                    rulesId = logisticsRulesRepository.Insert(model, trans);
                    if (model.Detail != null && model.Detail.Any())
                    {
                        foreach (var item in model.Detail)
                        {
                            item.RulesId = rulesId;
                            item.TenantId = model.TenantId;
                            item.MallBaseId = model.MallBaseId;
                            int priceId = logisticsRulesPriceRepository.Insert(item, trans);
                            item.List.ForEach(x => x.RulesPriceId = priceId);
                            item.List.ForEach(x => x.TenantId = model.TenantId);
                            item.List.ForEach(x => x.RulesType = Common.Enum.MallBase.RulesTypeEnum.Rule);
                            item.List.ForEach(x => x.MallBaseId = model.MallBaseId);
                            item.List.ForEach(x => x.CreateDate = System.DateTime.Now);
                            flag = logisticsRulesRegionRepository.InsertBatch(item.List, trans);
                        }
                    }
                }
                else
                {
                    rulesId = model.ID;
                    flag = logisticsRulesRepository.Update(model, trans);

                    //获取价格规则
                    List<RB_Logistics_RulesPrice_Extend> ListPrice = logisticsRulesPriceRepository.GetListRepository(new RB_Logistics_RulesPrice_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, RulesId = model.ID });

                    List<RB_Logistics_RulesRegion_Extend> listLogisticsRulesRegion = new List<RB_Logistics_RulesRegion_Extend>();

                    if (ListPrice != null && ListPrice.Any())
                    {
                        listLogisticsRulesRegion = logisticsRulesRegionRepository.GetListRepository(new RB_Logistics_RulesRegion_Extend { TenantId = model.TenantId, RulesType = model.RulesType, MallBaseId = model.MallBaseId, PriceIds = string.Join(",", ListPrice.Select(x => x.ID)) });
                    }


                    //比较之前有的现在没有的价格
                    List<string> notPriceList = new List<string>();
                    notPriceList = ListPrice.Select(x => x.ID.ToString()).Except(model.Detail.Select(x => x.ID.ToString())).ToList();
                    var deletePriceList = ListPrice.Where(x => notPriceList.Contains(x.ID.ToString()));
                    foreach (var item in deletePriceList)//删除之前有现在没有的数据
                    {
                        IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Logistics_RulesPrice.Status),1},

                          };
                        IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesPrice.ID),FiledValue=item.ID,OperatorEnum=OperatorEnum.Equal}
                        };
                        flag = logisticsRulesPriceRepository.Update(fileds, whereHelpers, trans);
                        if (listLogisticsRulesRegion != null && listLogisticsRulesRegion.Any())
                        {
                            foreach (var itemRegion in listLogisticsRulesRegion.Where(x => x.RulesPriceId == item.ID))
                            {
                                IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                         {
                            { nameof(RB_Logistics_RulesRegion.Status),1},
                             { nameof(RB_Logistics_RulesRegion.UpdateDate),System.DateTime.Now},
                          };
                                IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                            {
                                new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesRegion.ID),FiledValue=itemRegion.ID,OperatorEnum=OperatorEnum.Equal}
                            };
                                flag = logisticsRulesRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                            }
                        }

                    }

                    foreach (var item in model.Detail)
                    {
                        item.RulesId = rulesId;
                        item.TenantId = model.TenantId;
                        item.MallBaseId = model.MallBaseId;
                        int priceId = 0;
                        if (item.ID == 0)
                        {
                            priceId = logisticsRulesPriceRepository.Insert(item, trans);
                        }
                        else
                        {
                            priceId = item.ID;
                            flag = logisticsRulesPriceRepository.Update(item, trans);
                            //删除之前的区域
                            foreach (var itemRegion in listLogisticsRulesRegion.Where(x => x.RulesPriceId == item.ID))
                            {
                                IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                                 {
                                    { nameof(RB_Logistics_RulesRegion.Status),1},
                                    { nameof(RB_Logistics_RulesRegion.UpdateDate),System.DateTime.Now},
                                  };
                                IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesRegion.ID),FiledValue=itemRegion.ID,OperatorEnum=OperatorEnum.Equal}
                                };
                                flag = logisticsRulesRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                            }

                            //比较之前有的现在没有的价格
                            //List<string> notRegionList = new List<string>();
                            //notRegionList = listLogisticsRulesRegion.Where(x => x.RulesPriceId == item.ID).Select(x => x.ID.ToString()).Except(item.List.Select(x => x.ID.ToString())).ToList();
                            //var deleteRegionList = listLogisticsRulesRegion.Where(x => x.RulesPriceId == item.ID).Where(x => notRegionList.Contains(x.ID.ToString()));
                            //foreach (var itemRegion in deleteRegionList)
                            //{
                            //    IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                            //     {
                            //        { nameof(RB_LogisticsRulesRegion.Status),1},
                            //      };
                            //    IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                            //    {
                            //        new WhereHelper (){ FiledName=nameof(RB_LogisticsRulesRegion.ID),FiledValue=itemRegion.ID,OperatorEnum=OperatorEnum.Equal}
                            //    };
                            //    logisticsRulesRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                            //}
                        }
                        item.List.ForEach(x => x.RulesPriceId = priceId);
                        item.List.ForEach(x => x.CreateDate = System.DateTime.Now);
                        item.List.ForEach(x => x.ID = 0);
                        item.List.ForEach(x => x.TenantId = model.TenantId);
                        item.List.ForEach(x => x.RulesType = model.RulesType);
                        item.List.ForEach(x => x.MallBaseId = model.MallBaseId);
                        flag = logisticsRulesRegionRepository.InsertBatch(item.List, trans);
                    }
                }
                logisticsRulesRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateLogisticsRules");
                logisticsRulesRepository.DBSession.Rollback("AddOrUpdateLogisticsRules");
                return false;
            }
            return flag;
        }





        /// <summary>
        /// 删除物流规则
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelRulesInfo(int id, int uid, int mallBaseId)
        {
            bool flag = false;
            var trans = logisticsRulesRepository.DbTransaction;
            try
            {
                Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.Status),1},
                    { nameof(RB_Logistics_Rules.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
                flag = logisticsRulesRepository.Update(cols, wheres1, trans);

                //获取价格规则
                List<RB_Logistics_RulesPrice_Extend> ListPrice = logisticsRulesPriceRepository.GetListRepository(new RB_Logistics_RulesPrice_Extend { TenantId = uid, MallBaseId = mallBaseId, RulesId = id });
                foreach (var item in ListPrice)
                {
                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Logistics_RulesPrice.Status),1},

                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesPrice.ID),FiledValue=item.ID,OperatorEnum=OperatorEnum.Equal}
                        };
                    flag = logisticsRulesPriceRepository.Update(fileds, whereHelpers, trans);

                    IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                                 {
                                    { nameof(RB_Logistics_RulesRegion.Status),1},
                                    { nameof(RB_Logistics_RulesRegion.UpdateDate),System.DateTime.Now},
                                  };
                    IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesRegion.RulesPriceId),FiledValue=item.ID,OperatorEnum=OperatorEnum.Equal},
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.RulesType),
                        FiledValue=Convert.ToInt32(Common.Enum.MallBase.RulesTypeEnum.Rule),
                        OperatorEnum=OperatorEnum.Equal
                }  };
                    flag = logisticsRulesRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                }

                logisticsRulesRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelRulesInfo");
                logisticsRulesRepository.DBSession.Rollback("DelRulesInfo");
                return false;
            }
            return flag;
        }
        #endregion


        #region 包邮规则
        /// <summary>
        /// 包邮规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Rules_Extend> GetLogisticsPinkageList(int pageIndex, int pageSize, out long rowCount, RB_Logistics_Rules_Extend query)
        {
            List<RB_Logistics_Rules_Extend> list = logisticsRulesRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
            if (list != null && list.Any())
            {
                List<RB_Logistics_RulesRegion_Extend> listLogisticsRulesRegion = logisticsRulesRegionRepository.GetListRepository(new RB_Logistics_RulesRegion_Extend { TenantId = query.TenantId, RulesType = Common.Enum.MallBase.RulesTypeEnum.Pinkage, MallBaseId = query.MallBaseId, PriceIds = string.Join(",", list.Select(x => x.ID)) });
                foreach (var item in list)
                {
                    item.List = new List<RB_Logistics_RulesRegion_Extend>();
                    item.List = listLogisticsRulesRegion.Where(x => x.RulesPriceId == item.ID).ToList();
                }
            }
            return list;
        }

        /// <summary>
        /// 包邮实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Logistics_Rules_Extend GetPinkageModel(RB_Logistics_Rules_Extend query)
        {
            RB_Logistics_Rules_Extend model = logisticsRulesRepository.GetLogisticsRulesList(query).FirstOrDefault();
            List<RB_Logistics_RulesRegion_Extend> listLogisticsRulesRegion = logisticsRulesRegionRepository.GetListRepository(new RB_Logistics_RulesRegion_Extend { TenantId = query.TenantId, RulesType = Common.Enum.MallBase.RulesTypeEnum.Pinkage, MallBaseId = query.MallBaseId, RulesPriceId = model.ID });
            model.List = new List<RB_Logistics_RulesRegion_Extend>();
            model.List = listLogisticsRulesRegion;
            return model;
        }

        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdatePinkage(RB_Logistics_Rules_Extend model)
        {
            bool flag = false;
            var trans = logisticsRulesRepository.DbTransaction;
            try
            {
                int rulesId = 0;
                if (model.ID == 0)
                {
                    rulesId = logisticsRulesRepository.Insert(model, trans);
                }
                else
                {
                    rulesId = model.ID;
                    flag = logisticsRulesRepository.Update(model, trans);

                    List<RB_Logistics_RulesRegion_Extend> listLogisticsRulesRegion = logisticsRulesRegionRepository.GetListRepository(new RB_Logistics_RulesRegion_Extend { TenantId = model.TenantId, RulesType = Common.Enum.MallBase.RulesTypeEnum.Pinkage, MallBaseId = model.MallBaseId, RulesPriceId = model.ID });

                    //删除之前的区域
                    foreach (var itemRegion in listLogisticsRulesRegion.Where(x => x.RulesPriceId == model.ID))
                    {
                        IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                                 {
                                    { nameof(RB_Logistics_RulesRegion.Status),1},
                                    { nameof(RB_Logistics_RulesRegion.UpdateDate),System.DateTime.Now},
                                  };
                        IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesRegion.ID),FiledValue=itemRegion.ID,OperatorEnum=OperatorEnum.Equal}
                                };
                        flag = logisticsRulesRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                    }
                }
                model.List.ForEach(x => x.TenantId = rulesId);
                model.List.ForEach(x => x.CreateDate = System.DateTime.Now);
                model.List.ForEach(x => x.ID = 0);
                model.List.ForEach(x => x.RulesPriceId = model.TenantId);
                model.List.ForEach(x => x.RulesType = Common.Enum.MallBase.RulesTypeEnum.Pinkage);
                model.List.ForEach(x => x.MallBaseId = model.MallBaseId);
                flag = logisticsRulesRegionRepository.InsertBatch(model.List, trans);
                logisticsRulesRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdatePinkage");
                logisticsRulesRepository.DBSession.Rollback("AddOrUpdatePinkage");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除包邮规则
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelPinkageInfo(int id, int uid, int mallBaseId)
        {
            bool flag = false;
            var trans = logisticsRulesRepository.DbTransaction;
            try
            {
                Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_Logistics_Rules.Status),1},
                    { nameof(RB_Logistics_Rules.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_Rules.RulesType),
                        FiledValue=Convert.ToInt32(Common.Enum.MallBase.RulesTypeEnum.Pinkage),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
                flag = logisticsRulesRepository.Update(cols, wheres1, trans);

                IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                                 {
                                    { nameof(RB_Logistics_RulesRegion.Status),1},
                                    { nameof(RB_Logistics_RulesRegion.UpdateDate),System.DateTime.Now},
                                  };
                IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_Logistics_RulesRegion.RulesPriceId),FiledValue=id,OperatorEnum=OperatorEnum.Equal},
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Logistics_RulesRegion.RulesType),
                        FiledValue=Convert.ToInt32(Common.Enum.MallBase.RulesTypeEnum.Pinkage),
                        OperatorEnum=OperatorEnum.Equal
                }  };
                flag = logisticsRulesRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                logisticsRulesRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelPinkageInfo");
                logisticsRulesRepository.DBSession.Rollback("DelPinkageInfo");
                return false;
            }
            return flag;
        }
        #endregion

    }
}
