﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using Mall.Repository;
using Mall.Repository.Product;

namespace Mall.Module.Product
{
    /// <summary>
    /// 商品处理层
    /// </summary>
    public class ProductModule
    {
        /// <summary>
        /// 素材分组
        /// </summary>
        private readonly RB_Material_GroupRepository material_GroupRepository = new RB_Material_GroupRepository();
        /// <summary>
        /// 素材管理
        /// </summary>
        private readonly RB_Material_InfoRepository material_InfoRepository = new RB_Material_InfoRepository();


        /// <summary>
        /// 获取素材分组列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Material_Group_Extend> GetMaterialGroupList(RB_Material_Group_Extend dmodel) {
            var list= material_GroupRepository.GetList(dmodel);
            return list;
        }


        /// <summary>
        /// 获取素材分组分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Material_Info_Extend> GetMaterialInfoPageList(int pageIndex, int pageSize, out long count, RB_Material_Info_Extend dmodel)
        {
            var list = material_InfoRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
            return list;
        }

        /// <summary>
        /// 新增分组
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMaterialGroupInfo(RB_Material_Group_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Material_Group.Name),demodel.Name},
                    { nameof(RB_Material_Group.Sort),demodel.Sort},
                    { nameof(RB_Material_Group.UpdateDate),demodel.UpdateDate},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                     FiledName=nameof(RB_Material_Group.Id),
                      FiledValue=demodel.Id,
                       OperatorEnum=OperatorEnum.Equal
                    }
                };
                return material_GroupRepository.Update(keyValues, wheres);
            }
            else {
                return material_GroupRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 设置素材信息
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMaterialInfo(RB_Material_Info_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Material_Info.Name),demodel.Name},
                    { nameof(RB_Material_Info.UpdateDate),demodel.UpdateDate},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                     FiledName=nameof(RB_Material_Group.Id),
                      FiledValue=demodel.Id,
                       OperatorEnum=OperatorEnum.Equal
                    }
                };
                return material_InfoRepository.Update(keyValues, wheres);
            }
            else {
                return material_InfoRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 设置分组回收
        /// </summary>
        /// <param name="groupId"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialGroupRecycled(int groupId, string uid, int mallBaseId)
        {
            var gmodel = material_GroupRepository.GetEntity(groupId);
            if (gmodel == null) {
                return false;
            }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Material_Group.Recycled),2},
                { nameof(RB_Material_Group.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.Id),
                    FiledValue=groupId,
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.TenantId),
                    FiledValue=Convert.ToInt32(uid),
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.MallBaseId),
                    FiledValue=mallBaseId,
                    OperatorEnum=OperatorEnum.Equal
                },
            };
            bool flag = material_GroupRepository.Update(keyValues, wheres);
            if (flag) {
                //分组下所有素材全回收
                material_InfoRepository.SetMaterialInfoRecycled(groupId, Convert.ToInt32(uid), mallBaseId);
            }
            return flag;
        }

        /// <summary>
        /// 删除分组
        /// </summary>
        /// <param name="groupId"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelMaterialGroupInfo(int groupId, string uid, int mallBaseId)
        {
            var gmodel = material_GroupRepository.GetEntity(groupId);
            if (gmodel == null)
            {
                return false;
            }
            if (gmodel.Recycled != 2) {
                return false;
            }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Material_Group.Status),1},
                { nameof(RB_Material_Group.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.Id),
                    FiledValue=groupId,
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.TenantId),
                    FiledValue=Convert.ToInt32(uid),
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.MallBaseId),
                    FiledValue=mallBaseId,
                    OperatorEnum=OperatorEnum.Equal
                },
            };
            bool flag = material_GroupRepository.Update(keyValues, wheres);
            if (flag) {
                //删除分组下所有的素材
                material_InfoRepository.DelMaterialInfo("", uid, mallBaseId, groupId);
            }
            return flag;
        }

        /// <summary>
        /// 设置分组还原
        /// </summary>
        /// <param name="groupId"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialGroupRestore(int groupId, string uid, int mallBaseId)
        {
            var gmodel = material_GroupRepository.GetEntity(groupId);
            if (gmodel == null)
            {
                return false;
            }
            if (gmodel.Recycled != 2)
            {
                return false;
            }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Material_Group.Recycled),1},
                { nameof(RB_Material_Group.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.Id),
                    FiledValue=groupId,
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.TenantId),
                    FiledValue=Convert.ToInt32(uid),
                    OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Material_Group.MallBaseId),
                    FiledValue=mallBaseId,
                    OperatorEnum=OperatorEnum.Equal
                },
            };
            return material_GroupRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 设置素材回收
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialInfoRecycled(string materialIds, string uid, int mallBaseId)
        {
            bool flag = material_InfoRepository.SetMaterialListRecycled(materialIds, uid, mallBaseId);
            return flag;
        }

        /// <summary>
        /// 删除素材
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelMaterialInfo(string materialIds, string uid, int mallBaseId)
        {
            bool flag = material_InfoRepository.DelMaterialInfo(materialIds, uid, mallBaseId);
            return flag;
        }

        /// <summary>
        /// 设置素材还原
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialInfoRestore(string materialIds, string uid, int mallBaseId)
        {
            var trans = material_InfoRepository.DbTransaction;
            try
            {
                var list = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = materialIds, TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                if (list.Any())
                {
                    //查询出所有的分组
                    var glist = material_GroupRepository.GetList(new RB_Material_Group_Extend() { GroupIds = string.Join(",", list.Select(x => x.GroupId).Distinct()), TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                    if (glist.Where(x => x.Recycled == 2).Any())
                    {
                        foreach (var item in glist.Where(x => x.Recycled == 2)) {
                            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                                { nameof(RB_Material_Group.Recycled),1},
                                { nameof(RB_Material_Group.UpdateDate),DateTime.Now},
                            };
                            List<WhereHelper> wheres = new List<WhereHelper>() {
                                new WhereHelper(){
                                    FiledName=nameof(RB_Material_Group.Id),
                                    FiledValue=item.Id,
                                    OperatorEnum=OperatorEnum.Equal
                                },
                                new WhereHelper(){
                                    FiledName=nameof(RB_Material_Group.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                                },
                                new WhereHelper(){
                                    FiledName=nameof(RB_Material_Group.MallBaseId),
                                    FiledValue=mallBaseId,
                                    OperatorEnum=OperatorEnum.Equal
                                },
                            };
                            material_GroupRepository.Update(keyValues, wheres, trans);
                        }
                    }
                    foreach (var item in list) {
                        Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                            { nameof(RB_Material_Info.Recycled),1},
                            { nameof(RB_Material_Info.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres = new List<WhereHelper>() {
                            new WhereHelper(){
                                FiledName=nameof(RB_Material_Info.Id),
                                FiledValue=item.Id,
                                OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                FiledName=nameof(RB_Material_Info.TenantId),
                                FiledValue=Convert.ToInt32(uid),
                                OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                FiledName=nameof(RB_Material_Info.MallBaseId),
                                FiledValue=mallBaseId,
                                OperatorEnum=OperatorEnum.Equal
                            },
                        };
                        material_InfoRepository.Update(keyValues, wheres, trans);
                    }
                }
                material_InfoRepository.DBSession.Commit();
                return true;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetMaterialInfoRestore");
                material_InfoRepository.DBSession.Rollback();
                return false;
            }
        }

        /// <summary>
        /// 设置分组转移
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="groupId"></param>
        /// <param name="Type"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialInfoTransfer(string materialIds, int groupId, int Type, string uid, int mallBaseId)
        {
            var gmodel = material_GroupRepository.GetEntity(groupId);
            if (gmodel == null) {
                return false;
            }
            if (gmodel.Status == 1 || gmodel.Recycled == 2 || gmodel.Type != Type)
            {
                return false;
            }
            return material_InfoRepository.SetMaterialInfoTransfer(materialIds, groupId, uid, mallBaseId);
        }
    }
}
