﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using Mall.Module.BaseSetUp;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MallBaseController : BaseController
    {

        private MallBaseModule mallBaseModule = new MallBaseModule();
        private Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        #region 基础设置
        public ApiResult AddOrUpdateMallBase()
        {
            var query = JsonConvert.DeserializeObject<RB_MallBase_Extend>(RequestParm.msg.ToString());

            if (query == null)
            {
                return ApiResult.Failed("请传入需要操作的小程序");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.MallName))
                {
                    return ApiResult.Failed("请输入商城名称");
                }
                query.TenantId = UserInfo.TenantId;
                if (query.ID == 0)//新增
                {
                    var TenantModel = TenantModule.GetTenantModule(query.TenantId);
                    if (TenantModel == null)
                    {
                        return ApiResult.Failed("请确保商户信息正确");
                    }
                    if (TenantModel.AccountStatus != 2)
                    {
                        return ApiResult.Failed("商户状态审核不通过");
                    }
                    if (TenantModel.IsEffective == 0 && TenantModel.AccountValidate.HasValue && TenantModel.AccountValidate.Value < System.DateTime.Now)
                    {
                        return ApiResult.Failed("商户账号已过期");
                    }
                    //判断当前商户下面有多少小程序

                    if (TenantModel.CreateMiniPrograme.HasValue)
                    {
                        var oldList = mallBaseModule.GetListRepository(query);
                        if (oldList.Count() >= TenantModel.CreateMiniPrograme.Value)
                        {
                            return ApiResult.Failed("商户可建小程序数：" + TenantModel.CreateMiniPrograme.Value);
                        }
                    }
                }
                bool result = mallBaseModule.AddOrUpdateMallBase(query);
                if (result)
                {
                    return ApiResult.Success("基础信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("基础信息保存失败");
                }

            }
        }


        public ApiResult GetMallBaseInfo()
        {
            var query = new RB_MallBase_Extend();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = UserInfo.MallBaseId;
            var model = mallBaseModule.GetListRepository(query).FirstOrDefault();
            return ApiResult.Success("获取成功", model);
        }


        #endregion

        #region 物流设置

        #region 物流规格-物流设置
        /// <summary>
        /// 根据商户号获取物流信息
        /// </summary>
        /// <returns></returns>
        public ApiResult GetLogistics()
        {
            var query = JsonConvert.DeserializeObject<RB_Logistics>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            var oldLogisticsModel = mallBaseModule.GetLogisticsList(query).FirstOrDefault();
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Logistics();
                oldLogisticsModel.LogisticsType = Common.Enum.MallBase.LogisticsTypeEnum.ExpressBird;
            }
            return ApiResult.Success("", oldLogisticsModel);
        }

        /// <summary>
        /// 保存物流信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateLogistics()
        {
            var query = JsonConvert.DeserializeObject<RB_Logistics>(RequestParm.msg.ToString());

            if (query == null)
            {
                return ApiResult.Failed("请传入物流基础信息");
            }
            else
            {
                query.TenantId = UserInfo.TenantId;
                bool result = mallBaseModule.AddOrUpdateLogistics(query);
                if (result)
                {
                    return ApiResult.Success("物流设置信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("基物流设置信息保存失败");
                }
            }
        }

        #endregion

        #region 运费规则
        /// <summary>
        /// 列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetLogisticsRulesPage()
        {
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Logistics_Rules_Extend demodel = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = UserInfo.MallBaseId;
            demodel.RulesType = Common.Enum.MallBase.RulesTypeEnum.Rule;
            var list = mallBaseModule.GetLogisticsRulesList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.RulesName,
                x.IsDefault
            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetLogisticsRules()
        {
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = UserInfo.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.Rule;
            var oldLogisticsModel = mallBaseModule.GetLogisticsRulesModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Logistics_Rules_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }



        /// <summary>
        /// 设置默认物流规则
        /// </summary>
        /// <returns></returns>
        public ApiResult SetLogisticsRulesDefault()
        {
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = UserInfo.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.Rule;
            bool result = mallBaseModule.SetDefaultLogisticsRules(query);

            if (result)
            {
                return ApiResult.Success("默认运费规则设置成功");
            }
            else
            {
                return ApiResult.Failed("默认运费规则设置失败");
            }

        }


        /// <summary>
        /// 保存物流信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateLogisticsRules()
        {
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = UserInfo.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.Rule;
            if (query == null)
            {
                return ApiResult.Failed("请传入物流规则信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.RulesName))
                {
                    return ApiResult.Failed("请输入规则名称");
                }
                if (query.Detail == null || !query.Detail.Any())
                {
                    return ApiResult.Failed("请输入运费规则");
                }
                foreach (var item in query.Detail)
                {
                    if (item.List == null || !item.List.Any())
                    {
                        return ApiResult.Failed("请选择地区");
                    }
                }
                query.TenantId = UserInfo.TenantId;
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = mallBaseModule.AddOrUpdateLogisticsRules(query);
                if (result)
                {
                    return ApiResult.Success("物流规则信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("物流规则信息保存失败");
                }
            }
        }


        public ApiResult DelRules()
        {

            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int Id = parms.GetInt("Id", 0);
            if (Id <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            bool flag = mallBaseModule.DelRulesInfo(Id, UserInfo.TenantId, UserInfo.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }


        #endregion


        #region 包邮规则
        /// <summary>
        /// 列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetLogisticsPinkagePage()
        {
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Logistics_Rules_Extend demodel = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = UserInfo.MallBaseId;
            demodel.RulesType = Common.Enum.MallBase.RulesTypeEnum.Pinkage;
            var list = mallBaseModule.GetLogisticsPinkageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.RulesName,
                x.AllRegionPrice,
                RegionList = x.List.Select(x => x.RegionName)
            });
            return ApiResult.Success("", pagelist);
        }



        public ApiResult DelPinkage()
        {

            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int Id = parms.GetInt("Id", 0);
            if (Id <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            bool flag = mallBaseModule.DelPinkageInfo(Id, UserInfo.TenantId, UserInfo.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetLogisticsPinkage()
        {
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = UserInfo.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.Pinkage;
            var oldLogisticsModel = mallBaseModule.GetPinkageModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Logistics_Rules_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }


        /// <summary>
        /// 保存物流信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateLogisticsPinkage()
        {
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = UserInfo.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.Pinkage;
            if (query == null)
            {
                return ApiResult.Failed("请传入包邮规则信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.RulesName))
                {
                    return ApiResult.Failed("请输入包邮名称");
                }
                if (query.AllRegionPrice > -1)
                {
                    return ApiResult.Failed("包邮费用不能为负数");
                }
                if (query.List == null || !query.List.Any())
                {
                    return ApiResult.Failed("请选择地区");
                }
                query.TenantId = UserInfo.TenantId;
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = mallBaseModule.AddOrUpdatePinkage(query);
                if (result)
                {
                    return ApiResult.Success("包邮规则信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("包邮规则信息保存失败");
                }
            }
        }
        #endregion


        #region 起送规则
        public ApiResult GetMinPriceInfo()
        {
            var query = new RB_Logistics_Rules_Extend();
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = UserInfo.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.OpenMinPrice;
            var model = mallBaseModule.GetLogisticsRulesModel(query);
            return ApiResult.Success("获取成功", model);
        }


        /// <summary>
        /// 保存起送信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateMinPrice()
        {
            var query = JsonConvert.DeserializeObject<RB_Logistics_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = UserInfo.MallBaseId;
            query.RulesType = Common.Enum.MallBase.RulesTypeEnum.OpenMinPrice;
            if (query == null)
            {
                return ApiResult.Failed("请传入起送规则信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.RulesName))
                {
                    return ApiResult.Failed("请输入规则名称");
                }
                if (query.Detail == null || !query.Detail.Any())
                {
                    return ApiResult.Failed("请输入运费规则");
                }
                if (query.IsOpenAllRegionPrice == 0)
                {
                    foreach (var item in query.Detail)
                    {
                        if (item.List == null || !item.List.Any())
                        {
                            return ApiResult.Failed("请选择地区");
                        }
                    }
                }
                else
                {
                    if (query.AllRegionPrice < 0)
                    {
                        return ApiResult.Failed("全地区起送金额不能为负数");
                    }
                }
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = mallBaseModule.AddOrUpdateLogisticsRules(query);
                if (result)
                {
                    return ApiResult.Success("起送规则信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("起送规则信息保存失败");
                }
            }
        }
        #endregion

        #endregion

    }
}