﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace Mall.WindowsService.Helper
{
    public class TimersHelper
    {
        private static int inTimer = 0;

        /// <summary>
        /// 收入单子服务开始执行方法
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void RevenueFinance(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer, 1) == 0)
            {
                LogHelper.Write("RevenueFinance=====Start");


                Module.FinanceModule.OrderIncomeFinanceModule();

                LogHelper.Write("RevenueFinance=====End");
                Interlocked.Exchange(ref inTimer, 0);
            }
        }

        /// <summary>
        /// 自动取消订单
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void AutoCancelOrder(object sender, System.Timers.ElapsedEventArgs e) {
            if (Interlocked.Exchange(ref inTimer, 1) == 0)
            {
                LogHelper.Write("AutoCancelOrder=====Start");
                Module.FinanceModule.AutoCancelOrder();
                LogHelper.Write("AutoCancelOrder=====End");
                Interlocked.Exchange(ref inTimer, 0);
            }
        }

        /// <summary>
        /// 自动收货订单
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void AutoReceivingOrder(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer, 1) == 0)
            {
                if (DateTime.Now.Hour == 1)
                {
                    LogHelper.Write("AutoReceivingOrder=====Start");
                    Module.FinanceModule.AutoReceivingOrder();
                    LogHelper.Write("AutoReceivingOrder=====End");
                    Interlocked.Exchange(ref inTimer, 0);
                }
            }
        }

        /// <summary>
        /// 七天自动取消下线
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void AutoReleaseTheOffline(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer, 1) == 0)
            {
                if (DateTime.Now.Hour == 1)
                {
                    LogHelper.Write("AutoReceivingOrder=====Start");
                    Module.FinanceModule.AutoReleaseTheOffline();
                    LogHelper.Write("AutoReceivingOrder=====End");
                    Interlocked.Exchange(ref inTimer, 0);
                }
            }
        }
    }
}
