﻿using Mall.Model.Entity.User;
using System.Collections.Generic;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 用户分组扩展实体类
    /// </summary>
    public class RB_Member_Group_Extend: RB_Member_Group
    {
        /// <summary>
        /// 分组编号
        /// </summary>
        public string Q_GroupIds { get; set; }

        /// <summary>
        /// 可查看分组列表
        /// </summary>
        public List<object> LookGroupList { get; set; }

        /// <summary>
        /// 可查询分组编号
        /// </summary>
        public List<int> GroupIdList
        {
            get
            {
                List<int> ids = new List<int>();
                if (!string.IsNullOrEmpty(this.LookGroupIds))
                {
                    ids = Common.ConvertHelper.StringToList(this.LookGroupIds);
                }
                return ids;
            }
        }

        /// <summary>
        /// 是否查询默认分组
        /// </summary>
        public int IsQueryDefault { get; set; }
    }
}
