﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 耗材盘点明细仓储类
    /// </summary>
    public partial class RB_Supplies_CheckDetailRepository : BaseRepository<RB_Supplies_CheckDetail>
    {
        /// <summary>
        /// 获取盘点分页数据
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Supplies_CheckDetail_Extend> GetPageList(int pageIndex, int pageSize, RB_Supplies_CheckDetail_Extend dmodel, out long count)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND cd.{0}={1}", nameof(RB_Supplies_CheckDetail_Extend.Status), 0);
            where += $@" and cd.RB_Group_Id={dmodel.RB_Group_Id}";
            if (dmodel.SuppliesId > 0)
            {
                where += " and cd." + nameof(RB_Supplies_CheckDetail_Extend.SuppliesId) + "=" + dmodel.SuppliesId;
            }
            if (dmodel.CheckId > 0)
            {
                where += " and cd." + nameof(RB_Supplies_CheckDetail_Extend.CheckId) + "=" + dmodel.CheckId;
            }
            if (!string.IsNullOrWhiteSpace(dmodel.SuppliesName))
            {
                where += " and pi." + nameof(RB_Supplies_Material.Name) + " like '%" + dmodel.SuppliesName + "%'";
            }
            if (dmodel.CheckStatus > 0)
            {
                where += " and cd." + nameof(RB_Supplies_CheckDetail_Extend.CheckStatus) + "=" + (int)dmodel.CheckStatus;
            }
            if (dmodel.DealStatus > 0)
            {
                where += " and cd." + nameof(RB_Supplies_CheckDetail_Extend.DealStatus) + "=" + dmodel.DealStatus;
            }
            if (dmodel.IsSelectCheckLoss == 1)
            {
                where += " and cd." + nameof(RB_Supplies_CheckDetail_Extend.CheckStatus) + " in(3,4)";
            }
            if (dmodel.IsSelectHaveInventory == 1)
            {
                where += " and cd." + nameof(RB_Supplies_CheckDetail_Extend.InventoryNum) + ">0";
            }
            string sql = $@" select cd.*,pi.Name as SuppliesName,pi.SuppliesNum as SuppliesNo,pi.SpecificationName from RB_Supplies_CheckDetail cd
left join rb_supplies_material pi on cd.SuppliesId=pi.Id
{where} order by cd.Id desc";
            return GetPage<RB_Supplies_CheckDetail_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 根据条件获取盘点列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Supplies_CheckDetail_Extend> GetList(RB_Supplies_CheckDetail_Extend dmodel)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND cd.{0}={1}", nameof(RB_Supplies_CheckDetail_Extend.Status), 0);
            where += $@" and cd.RB_Group_Id={dmodel.RB_Group_Id}";
            if (dmodel.SuppliesId > 0)
            {
                where += " and cd." + nameof(RB_Supplies_CheckDetail_Extend.SuppliesId) + "=" + dmodel.SuppliesId;
            }
            if (dmodel.CheckId > 0)
            {
                where += " and cd." + nameof(RB_Supplies_CheckDetail_Extend.CheckId) + "=" + dmodel.CheckId;
            }
            if (!string.IsNullOrWhiteSpace(dmodel.SuppliesName))
            {
                where += " and pi." + nameof(RB_Supplies_Material.Name) + " like '%" + dmodel.SuppliesName + "%'";
            }
            if (dmodel.CheckStatus > 0)
            {
                where += " and cd." + nameof(RB_Supplies_CheckDetail_Extend.CheckStatus) + "=" + (int)dmodel.CheckStatus;
            }
            if (dmodel.DealStatus >= 0)
            {
                where += " and cd." + nameof(RB_Supplies_CheckDetail_Extend.DealStatus) + "=" + dmodel.DealStatus;
            }
            if (dmodel.IsSelectCheckLoss == 1)
            {
                where += " and cd." + nameof(RB_Supplies_CheckDetail_Extend.CheckStatus) + " in(3,4)";
            }
            string sql = $@" select cd.*,pi.Name as SuppliesName,pi.SuppliesNo,pi.SpecificationName from RB_Supplies_CheckDetail cd
left join rb_supplies_material pi on cd.SuppliesId=pi.Id
{where} order by cd.Id desc";
            return Get<RB_Supplies_CheckDetail_Extend>(sql).ToList();
        }
    }
}
