﻿using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Education
{
    public class RB_Education_FollowTeacherRepository : BaseRepository<RB_Education_FollowTeacher>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Education_FollowTeacher); } }
        /// <summary>
        /// 网课-我关注的老师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_FollowTeacher_Extend> GetFollowPageList(int pageIndex, int pageSize, out long rowCount, RB_Education_FollowTeacher_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.*,b.Introduction,b.Major,b.LableName,b.`Name`,b.Score,b.TeacherLogo,b.Telephone FROM rb_education_followteacher as a LEFT JOIN rb_education_teacher as b 
on a.TeacherId=b.ID WHERE  a.{nameof(RB_Education_FollowTeacher_Extend.Status)}=0 and b.{nameof(RB_Education_Teacher_Extend.Status)}=0 and b.{nameof(RB_Education_Teacher_Extend.TeacherStatus)}=1");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.ID)}={query.ID}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.UserId)}={query.UserId}");
                }
                if (query.TeacherId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.TeacherId)}={query.TeacherId}");
                }
            }
            return GetPage<RB_Education_FollowTeacher_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 网课-我关注的老师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_FollowTeacher_Extend> GetFollowTeacherList(RB_Education_FollowTeacher_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.*,b.Introduction,b.Major,b.LableName,b.`Name`,b.Score,b.TeacherLogo,b.Telephone FROM rb_education_followteacher as a LEFT JOIN rb_education_teacher as b 
on a.TeacherId=b.ID WHERE  a.{nameof(RB_Education_FollowTeacher_Extend.Status)}=0 and b.{nameof(RB_Education_Teacher_Extend.Status)}=0 and b.{nameof(RB_Education_Teacher_Extend.TeacherStatus)}=1");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.ID)}={query.ID}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.UserId)}={query.UserId}");
                }
                if (query.TeacherId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.TeacherId)}={query.TeacherId}");
                }
            }
            return Get<RB_Education_FollowTeacher_Extend>(builder.ToString()).ToList();
        }


        /// <summary>
        /// 网课-我关注的老师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_FollowTeacher_Extend> GetFollowUserList(RB_Education_FollowTeacher_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.*,b.OpenId FROM rb_education_followteacher as a LEFT JOIN rb_member_user as b 
on a.UserId=b.ID  WHERE  a.{nameof(RB_Education_FollowTeacher_Extend.Status)}=0  ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.ID)}={query.ID}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.UserId)}={query.UserId}");
                }
                if (query.TeacherId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_FollowTeacher_Extend.TeacherId)}={query.TeacherId}");
                }
            }
            return Get<RB_Education_FollowTeacher_Extend>(builder.ToString()).ToList();
        }
    }
}
