﻿using Mall.Model.Entity.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.MarketingCenter
{
    /// <summary>
    /// 充值设置仓储层
    /// </summary>
    public class RB_Recharge_SettingsRepository : RepositoryBase<RB_Recharge_Settings>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Recharge_Settings); } }


        /// <summary>
        /// 充值设置列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Recharge_Settings> GetRechargeSettingsList(RB_Recharge_Settings query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Recharge_Settings.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Recharge_Settings.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Recharge_Settings.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Recharge_Settings.MallBaseId)}={query.MallBaseId}");
                }
            }
            return Get<RB_Recharge_Settings>(builder.ToString()).ToList();
        }
    }
}
