﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Goods;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 课程下载表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_WK_DownLoad
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 课程id
        /// </summary>        
        public int GoodsId
        {
            get;
            set;
        }
        /// <summary>
        /// 章节id
        /// </summary>        
        public int CourseId
        {
            get;
            set;
        }
        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId { get; set; }
        /// <summary>
        /// 文件下载地址
        /// </summary>
        public string FilePath { get; set; }
        /// <summary>
        /// 附件类型  枚举
        /// </summary>
        public GoodsCourseTypeEnum? FileType { get; set; }
        /// <summary>
        /// 文件大小
        /// </summary>
        public decimal Size { get; set; }
        /// <summary>
        /// 单位
        /// </summary>
        public string Unit { get; set; }
        /// <summary>
        /// 文件状态  1下载中  2下载成功  3下载失败
        /// </summary>
        public int FileState { get; set; }
        
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
