﻿using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Mall.Model.Entity.User;
using VT.FW.DB.Dapper;

namespace Mall.Repository.User
{
    /// <summary>
    /// 商户用户仓储层
    /// </summary>
    public partial  class RB_Member_UserRepository2 : BaseRepository<RB_Member_User>
    {
        /// <summary>
        /// 获取商户用户列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetMemberUserListExtRepository(RB_Member_User_Extend dmodel)
        {
            DynamicParameters dynamicParameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT  IFNULL(B.Id,0) AS ShopId,IFNULL(B.Name,'') AS ShopName,A.* 
FROM rb_member_user AS A LEFT JOIN rb_smallshops_info AS B ON A.Id=B.UserId
WHERE 1=1
"); 
            if (dmodel.TenantId > 0)
            {
                builder.AppendFormat($@" and A.{nameof(RB_Member_User.TenantId)}={dmodel.TenantId}");
            }
            if (dmodel.MallBaseId > 0)
            {
                builder.AppendFormat($@" and A.{nameof(RB_Member_User.MallBaseId)}={dmodel.MallBaseId}");
            }
            if (!string.IsNullOrEmpty(dmodel.Name.Trim()))
            {
                builder.AppendFormat($@" and A.Name like @Name ");
                dynamicParameters.Add("Name", "%" + dmodel.Name.Trim() + "%");
            }
            return Get<RB_Member_User_Extend>(builder.ToString(), dynamicParameters).ToList();
        }
    }
}
