﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Plugin;

namespace Mall.Common.Enum.TradePavilion
{
    /// <summary>
    /// 载体
    /// </summary>
    public enum SZTCarrierExportEnum
    {
        /// <summary>
        /// 项目名称
        /// </summary>
        [EnumField("项目名称")]
        CarrierName = 1,
        /// <summary>
        /// Logo
        /// </summary>
        [EnumField("Logo")]
        Logo = 2,
        /// <summary>
        /// 载体视频
        /// </summary>
        [EnumField("载体视频")]
        VideoUrl = 3,


        /// <summary>
        /// 项目位置
        /// </summary>
        [EnumField("项目位置")]
        Address = 4,

        /// <summary>
        /// 开业状态
        /// </summary>
        [EnumField("开业状态")]
        OpeningStatus = 5,


        /// <summary>
        /// 商业体量
        /// </summary>
        [EnumField("商业体量")]
        CarrierSize = 6,

        /// <summary>
        /// 商业层数
        /// </summary>
        [EnumField("商业层数")]
        LayersNum = 7,

        /// <summary>
        /// 车位数量
        /// </summary>
        [EnumField("车位数量")]
        CarNum = 8,


        /// <summary>
        /// 经营面积
        /// </summary>
        [EnumField("经营面积")]
        BuiltUpArea = 9,


        /// <summary>
        /// 可租赁面积
        /// </summary>
        [EnumField("可租赁面积")]
        AreaRequirement = 10,
        /// <summary>
        /// 开业时间
        /// </summary>
        [EnumField("开业时间")]
        OpenTime = 11,
        /// <summary>
        /// 人流量参数
        /// </summary>
        [EnumField("人流量参数")]
        VisitorsFlowrate = 12,
        /// <summary>
        /// 水电气及配套
        /// </summary>
        [EnumField("水电气及配套")]
        SupportingFacilities = 13,
        /// <summary>
        /// 管理公司及管理费
        /// </summary>
        [EnumField("管理公司及管理费")]
        ManagementCompany = 14,
        /// <summary>
        /// 开发商
        /// </summary>
        [EnumField("开发商")]
        Developers = 15,
        /// <summary>
        /// 物业构成
        /// </summary>
        [EnumField("物业构成")]
        CategoryId = 16,
        /// <summary>
        /// 资产权属
        /// </summary>
        [EnumField("资产权属")]
        Ascription = 17,
        /// <summary>
        /// 业态规划
        /// </summary>
        [EnumField("业态规划")]
        CarrierPlan = 18,
        /// <summary>
        /// 目标招商业态及品牌需求
        /// </summary>
        [EnumField("目标招商业态及品牌需求")]
        BrandDemand = 19,


        /// <summary>
        /// 项目发展及定位
        /// </summary>
        [EnumField("项目发展及定位")]
        Location = 20,


        /// <summary>
        /// 联系人
        /// </summary>
        [EnumField("联系人")]
        ContactName = 21,


        /// <summary>
        /// 联系电话
        /// </summary>
        [EnumField("联系电话")]
        ContactPhone = 22,

    }

    /// <summary>
    /// 楼宇下载项目
    /// </summary>
    public enum SZTBuildExportEnum
    {

        /// <summary>
        /// 楼宇名称
        /// </summary>
        [EnumField("楼宇名称")]
        Name = 1,

        /// <summary>
        /// Logo
        /// </summary>
        [EnumField("Logo")]
        Logo = 2,

        /// <summary>
        /// 楼宇位置
        /// </summary>
        [EnumField("楼宇位置")]
        Address = 3,

        /// <summary>
        /// 经纬度
        /// </summary>
        [EnumField("经纬度")]
        LatAndLon = 4,

        /// <summary>
        /// 投运时间
        /// </summary>
        [EnumField("投运时间")]
        OperationTime = 5,

        /// <summary>
        /// 楼宇等级
        /// </summary>
        [EnumField("楼宇等级")]
        CategoryId = 6,

        /// <summary>
        /// 楼宇建筑面积
        /// </summary>
        [EnumField("楼宇建筑面积")]
        Areas = 7,


        /// <summary>
        /// 楼栋数
        /// </summary>
        [EnumField("楼栋数")]
        BuildingNum = 8,

        /// <summary>
        /// 楼层数
        /// </summary>
        [EnumField("楼层数")]
        FloorNum = 9,

        /// <summary>
        /// 电梯数
        /// </summary>
        [EnumField("电梯数")]
        ElevatorNum = 10,

        /// <summary>
        /// 层高
        /// </summary>
        [EnumField("层高")]
        FloorHeight = 11,

        /// <summary>
        /// 开发商
        /// </summary>
        [EnumField("开发商")]
        Developers = 12,

        /// <summary>
        /// 物业公司
        /// </summary>
        [EnumField("物业公司")]
        PropertyComp = 13,

        /// <summary>
        /// 销售自持比例
        /// </summary>
        [EnumField("销售自持比例")]
        SaleOrSelf = 14,

        /// <summary>
        /// 是否统一运营
        /// </summary>
        [EnumField("是否统一运营")]
        IsAllOperate = 15,

        /// <summary>
        /// 建设时间
        /// </summary>
        [EnumField("建设时间")]
        ConstructionTime = 16,

        /// <summary>
        /// 物业费
        /// </summary>
        [EnumField("物业费")]
        PropertyFee = 17,

        /// <summary>
        /// 月租金
        /// </summary>
        [EnumField("月租金")]
        RentFee = 18,

        /// <summary>
        /// 产业方向
        /// </summary>
        [EnumField("产业方向")]
        IndustryDirection = 19,

        /// <summary>
        /// 目标企业招引需求
        /// </summary>
        [EnumField("目标企业招引需求")]
        BrandDemand = 20,


        /// <summary>
        /// 其他需求
        /// </summary>
        [EnumField("其他需求")]
        Other = 21,

        /// <summary>
        /// 联系人
        /// </summary>
        [EnumField("联系人")]
        ContactName = 22,
        /// <summary>
        /// 联系电话
        /// </summary>
        [EnumField("联系电话")]
        ContactPhone = 23,
    }



}
