﻿using VT.FW.DB;
using Mall.Model.Entity.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.BaseSetUp
{
    /// <summary>
    /// 地区
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Destination_Extend : RB_Destination
    {
        /// <summary>
        /// 洲查询使用
        /// </summary>
        public string QArea { get; set; }

        /// <summary>
        /// 国家查询使用
        /// </summary>
        public string QCountry { get; set; }

        /// <summary>
        /// 省份查询使用
        /// </summary>
        public string QProvince { get; set; }

        /// <summary>
        /// 城市查询使用
        /// </summary>
        public string QCity { get; set; }

        /// <summary>
        /// 地区查询使用
        /// </summary>
        public string QDistrict { get; set; }



        /// <summary>
        /// 行政级别名称
        /// </summary>
        public string CodeLevelName
        {
            get
            {
                string str = string.Empty;
                if (this.CodeLevel > 0)
                {
                    str = Common.Plugin.EnumHelper.GetEnumName(CodeLevel);
                }
                return str;
            }
        }


   

        /// <summary>
        /// 所属国家
        /// </summary>
        public string CountryName { get; set; }

        /// <summary>
        /// 所属省份
        /// </summary>
        public string ProvinceName { get; set; }

        /// <summary>
        /// 所属城市
        /// </summary>
        public string CityName { get; set; }

        /// <summary>
        /// ID查询字符串
        /// </summary>
        public string QIds { get; set; }

        /// <summary>
        /// 批量name查询
        /// </summary>
        public string NameStr { get; set; }

        public List<RB_Destination_Extend> Children { get; set; }
    }

    /// <summary>
    /// 地区树形结构
    /// </summary>
    public class DestinationViewModel
    {
        /// <summary>
        /// 主键
        /// </summary>
        public int ID
        {
            get;
            set;
        }

        /// <summary>
        /// 名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 下级地区列表
        /// </summary>
        public List<DestinationViewModel> Children { get; set; }
    }
}
