﻿using Mall.Common;
using Mall.Common.API;
using Mall.Common.Models;
using Mall.Common.Plugin;
using Mall.Model.Entity.Coffee;
using Mall.Model.Extend.Coffee;
using Mall.Model.Extend.Product;
using Mall.Repository.BaseSetUp;
using Mall.Repository.Coffee;
using Mall.Repository.Education;
using Mall.Repository.Product;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.Education
{
    public class CoffeeModule
    {
        /// <summary>
        /// 咖啡劵
        /// </summary>
        private readonly RB_Member_CoffeeCouponsRepository member_CoffeeCouponsRepository = new RB_Member_CoffeeCouponsRepository();
        /// <summary>
        /// 咖啡劵消费记录
        /// </summary>
        private readonly RB_Member_CoffeeLogRepository member_CoffeeLogRepository = new RB_Member_CoffeeLogRepository();
        /// <summary>
        /// 字典
        /// </summary>
        private readonly Rb_DictvalueRepository dictvalueRepository = new Rb_DictvalueRepository();
        /// <summary>
        /// 商品
        /// </summary>
        private readonly RB_GoodsRepository goodsRepository = new RB_GoodsRepository();
        /// <summary>
        /// 商品规格
        /// </summary>
        private readonly RB_Goods_SpecificationPriceRepository goods_SpecificationPriceRepository = new RB_Goods_SpecificationPriceRepository();
        /// <summary>
        /// 订单
        /// </summary>
        private readonly RB_Goods_OrderRepository goods_OrderRepository = new RB_Goods_OrderRepository();
        /// <summary>
        /// 订单明细
        /// </summary>
        private readonly RB_Goods_OrderDetailRepository goods_OrderDetailRepository = new RB_Goods_OrderDetailRepository();
        /// <summary>
        /// 用户关联
        /// </summary>
        private readonly RB_Education_EduSellRepository education_EduSellRepository = new RB_Education_EduSellRepository();
        /// <summary>
        /// 甲鹤用户
        /// </summary>
        private readonly Repository.User.RB_Member_UserRepository member_UserRepository = new Repository.User.RB_Member_UserRepository();
        /// <summary>
        /// 账号
        /// </summary>
        private readonly RB_AccountRepository accountRepository = new RB_AccountRepository();


        /// <summary>
        /// 获取我的咖啡劵详情
        /// </summary>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public object GetMyCoffeeCouponsInfo(AppletUserInfo userInfo, out string msg)
        {
            msg = "";
            var esModel = education_EduSellRepository.GetEducationStuList(new Model.Extend.Education.RB_Education_EduSell_Extend() { MallBaseId = userInfo.MallBaseId, UserId = userInfo.UserId }, true).FirstOrDefault();
            var cmodel = member_CoffeeCouponsRepository.GetList(new RB_Member_CoffeeCoupons_Extend() { MallBaseId = userInfo.MallBaseId, UserId = userInfo.UserId }).FirstOrDefault();
            if (cmodel == null)
            {
                //没有咖啡劵信息
                //查询关联的信息
                if (esModel != null)
                {
                    if (esModel.Type == 1)
                    {
                        //内部人员  直接初始化  内部人员的咖啡劵信息
                        int FreeNum = Convert.ToInt32(dictvalueRepository.GetList(new Model.Extend.BaseSetUp.RB_Dictvalue_Extend() { MallBaseId = userInfo.MallBaseId, DictKey = "Edu_CoffeeCoupons_EmpFree" }).FirstOrDefault()?.Content ?? "0");
                        if (FreeNum > 0)
                        {
                            cmodel = new RB_Member_CoffeeCoupons_Extend()
                            {
                                Id = 0,
                                CreateDate = DateTime.Now,
                                FreeNum = FreeNum,
                                MallBaseId = userInfo.MallBaseId,
                                SurplusBugNum = 0,
                                TotalBuyNum = 0,
                                UpdateDate = DateTime.Now,
                                UserId = userInfo.UserId
                            };
                            cmodel.Id = member_CoffeeCouponsRepository.Insert(cmodel);
                        }
                    }
                    else if (esModel.Type == 2)
                    {
                        //学生  要看是否还有正在学习的课程  有的话 可初始化免费的咖啡劵
                        int learningNum = accountRepository.GetStuLearningCourse(esModel.EduSellId, out int FreeCoffeeNum, out _);
                        if (learningNum > 0)
                        {
                            int FreeNum = Convert.ToInt32(dictvalueRepository.GetList(new Model.Extend.BaseSetUp.RB_Dictvalue_Extend() { MallBaseId = userInfo.MallBaseId, DictKey = "Edu_CoffeeCoupons_Free" }).FirstOrDefault()?.Content ?? "0");
                            FreeNum = FreeCoffeeNum > 0 ? FreeCoffeeNum : FreeNum;
                            if (FreeNum > 0)
                            {
                                cmodel = new RB_Member_CoffeeCoupons_Extend()
                                {
                                    Id = 0,
                                    CreateDate = DateTime.Now,
                                    FreeNum = FreeNum,
                                    MallBaseId = userInfo.MallBaseId,
                                    SurplusBugNum = 0,
                                    TotalBuyNum = 0,
                                    UpdateDate = DateTime.Now,
                                    UserId = userInfo.UserId
                                };
                                cmodel.Id = member_CoffeeCouponsRepository.Insert(cmodel);
                            }
                        }
                    }
                    if (cmodel == null)
                    {
                        cmodel = new RB_Member_CoffeeCoupons_Extend()
                        {
                            Id = 0,
                            CreateDate = DateTime.Now,
                            FreeNum = 0,
                            MallBaseId = userInfo.MallBaseId,
                            SurplusBugNum = 0,
                            TotalBuyNum = 0,
                            UpdateDate = DateTime.Now,
                            UserId = userInfo.UserId
                        };
                        cmodel.Id = member_CoffeeCouponsRepository.Insert(cmodel);
                    }
                }
            }
            else {
                if (esModel != null && esModel.IsInitFreeCoffee == 1 && esModel.Type == 2) {
                    //该用户咖啡劵没更新赠送  验证一下  其是否还有正在学习的课程  有的话 恢复赠送咖啡劵
                    int learningNum = accountRepository.GetStuLearningCourse(esModel.EduSellId, out int FreeCoffeeNum, out _);
                    if (learningNum > 0)
                    {
                        int FreeNum = Convert.ToInt32(dictvalueRepository.GetList(new Model.Extend.BaseSetUp.RB_Dictvalue_Extend() { MallBaseId = userInfo.MallBaseId, DictKey = "Edu_CoffeeCoupons_Free" }).FirstOrDefault()?.Content ?? "0");
                        FreeNum = FreeCoffeeNum > 0 ? FreeCoffeeNum : FreeNum;
                        if (FreeNum > 0)
                        {
                            cmodel.FreeNum = FreeNum;
                            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                                { nameof(RB_Member_CoffeeCoupons_Extend.FreeNum), FreeNum}
                            };
                            List<WhereHelper> wheres = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName = nameof(RB_Member_CoffeeCoupons_Extend.Id),
                                      FiledValue = cmodel.Id,
                                       OperatorEnum =OperatorEnum.Equal
                                }
                            };
                            member_CoffeeCouponsRepository.Update(keyValues, wheres);
                        }
                    }
                }
            }
            string GiveAway = dictvalueRepository.GetList(new Model.Extend.BaseSetUp.RB_Dictvalue_Extend() { MallBaseId = userInfo.MallBaseId, DictKey = "Edu_CoffeeCoupons_GiveAway" }).FirstOrDefault()?.Content??"";
            List<object> giveAwayList = new List<object>();
            if (!string.IsNullOrEmpty(GiveAway)) {
                var glist = GiveAway.Split("/");
                foreach (var item in glist) {
                    var slist = item.Split('-');
                    giveAwayList.Add(new
                    {
                        BuyNum = slist[0],
                        GiveAwayNum = slist[1]
                    });
                }
            }
            //获取当前咖啡劵单价
            var goodsModel = goodsRepository.GetSingleList(new RB_Goods_Extend() { MallBaseId = userInfo.MallBaseId, GoodsEduType = 1, GoodsStatus = 1 }).FirstOrDefault();
            decimal SellingPrice = 0;
            string SpecificationSort = "";
            if (goodsModel != null)
            {
                var spMdoel = goods_SpecificationPriceRepository.GetList(new RB_Goods_SpecificationPrice_Extend() { MallBaseId = userInfo.MallBaseId, GoodsId = goodsModel.Id }).FirstOrDefault();
                SellingPrice = spMdoel.SellingPrice ?? 0;
                SpecificationSort = spMdoel.SpecificationSort;
            }
            string Address = dictvalueRepository.GetList(new Model.Extend.BaseSetUp.RB_Dictvalue_Extend() { MallBaseId = userInfo.MallBaseId, DictKey = "Edu_Coffee_Address" }).FirstOrDefault()?.Content ?? "";
            return new
            {
                GoodsId = goodsModel?.Id ?? 0,
                SpecificationSort,
                SellingPrice,
                SurplusBugNum = cmodel?.SurplusBugNum ?? 0,
                FreeNum = cmodel?.FreeNum ?? 0,
                GiveAwayList = giveAwayList,
                Address
            };
        }

        /// <summary>
        /// 获取我的咖啡劵消费列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_CoffeeLog_Extend> GetMyCoffeeCouponsPageList(int pageIndex, int pageSize, out long count, RB_Member_CoffeeLog_Extend demodel)
        {
            var list = member_CoffeeLogRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            return list;
        }

        /// <summary>
        /// 获取我的咖啡劵订单
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Order_Extend> GetMyCofeeOrderPageList(int pageIndex, int pageSize, out long count, RB_Goods_Order_Extend demodel) {
            var list = goods_OrderRepository.GetOrderPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any()) {
                string orderIds = string.Join(",", list.Select(x => x.OrderId));
                var dlist = goods_OrderDetailRepository.GetOrderDetailList(new RB_Goods_OrderDetail_Extend() { MallBaseId = demodel.MallBaseId, OrderIds = orderIds });
                foreach (var item in list) {
                    item.DetailList = dlist.Where(x => x.OrderId == item.OrderId).ToList();
                }
            }
            return list;
        }

        /// <summary>
        /// 获取我的咖啡劵订单信息
        /// </summary>
        /// <param name="orderId"></param>
        /// <param name="userId"></param>
        /// <param name="mallbaseId"></param>
        /// <returns></returns>
        public RB_Goods_Order_Extend GetMyCoffeeOrderInfo(int orderId , int userId , int mallbaseId) {
            var omodel = goods_OrderRepository.GetEntity<RB_Goods_Order_Extend>(orderId);
            if (omodel == null || omodel.UserId != userId || omodel.MallBaseId != mallbaseId) { return null; }

            omodel.DetailList = goods_OrderDetailRepository.GetOrderDetailList(new RB_Goods_OrderDetail_Extend() { MallBaseId = mallbaseId, OrderId = orderId });
            //查询下地址
            string Address = dictvalueRepository.GetList(new Model.Extend.BaseSetUp.RB_Dictvalue_Extend() { MallBaseId = mallbaseId, DictKey = "Edu_Coffee_Address" }).FirstOrDefault()?.Content ?? "";
            omodel.ShoppingAddress = Address;
            return omodel;
        }

        /// <summary>
        /// 核销咖啡劵
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="userInfo"></param>
        /// <param name="rmsg"></param>
        /// <returns></returns>
        public object SetAdminVerificationCoffee(int userId, string code, AppletUserInfo userInfo, out string rmsg)
        {
            rmsg = "";
            string AdminIds = dictvalueRepository.GetList(new Model.Extend.BaseSetUp.RB_Dictvalue_Extend() { MallBaseId = userInfo.MallBaseId, DictKey = "Edu_CoffeeCoupons_Verification" }).FirstOrDefault()?.Content ?? "";
            if (AdminIds == "") { rmsg = "您没有权限核销咖啡劵"; return ""; }
            var adminModel = education_EduSellRepository.GetEducationSellBaseInfo(new Model.Extend.Education.RB_Education_EduSell_Extend() { MallBaseId = userInfo.MallBaseId, UserId = userInfo.UserId, EduSellIds = AdminIds }).FirstOrDefault();
            if (adminModel == null) { rmsg = "您没有权限核销咖啡劵"; return ""; }

            var model = member_CoffeeLogRepository.GetList(new RB_Member_CoffeeLog_Extend() { MallBaseId = userInfo.MallBaseId, UserId = userInfo.UserId, Code = code }).FirstOrDefault();
            if (model != null) { rmsg = "已核销咖啡劵"; return ""; }

            string Name = "";
            var uModel = education_EduSellRepository.GetEducationStuList(new Model.Extend.Education.RB_Education_EduSell_Extend() { MallBaseId = userInfo.MallBaseId, UserId = userId }).FirstOrDefault();
            int Type;
            if (uModel != null)
            {
                Type = uModel.Type;
                if (uModel.Type == 1)
                {
                    Name = accountRepository.GetEmployeeListRepository(new Model.Extend.Education.Employee_ViewModel() { Id = uModel.EduSellId }).FirstOrDefault()?.EmployeeName ?? "";
                }
                else if (uModel.Type == 2)
                {
                    Name = accountRepository.GetStudentExt(new Model.Extend.Education.RB_Account_ViewModel() { Id = uModel.EduSellId, AccountType = 4 }).FirstOrDefault()?.AccountName ?? "";
                }
            }
            else
            {
                Type = 3;//甲鹤用户
                Name = CacheManager.User.UserReidsCache.GetAppletUserLoginInfo(userId)?.Name ?? "";
            }
            //获取用户的咖啡劵明细
            var mModel = member_CoffeeCouponsRepository.GetList(new RB_Member_CoffeeCoupons_Extend() { MallBaseId = userInfo.MallBaseId, UserId = userId }).FirstOrDefault();
            if (mModel == null || (mModel.FreeNum <= 0 && mModel.SurplusBugNum <= 0)) {
                return new
                {
                    State = 2,
                    Msg = "该用户暂无可使用的咖啡劵"
                };
            }
            Dictionary<string, object> keyValues = new Dictionary<string, object>();
            if (mModel.FreeNum > 0)
            {
                //使用免费的核销
                keyValues.Add(nameof(RB_Member_CoffeeCoupons_Extend.FreeNum), mModel.FreeNum - 1);
            }
            else if (mModel.SurplusBugNum > 0) {
                //使用购买的
                keyValues.Add(nameof(RB_Member_CoffeeCoupons_Extend.SurplusBugNum), mModel.SurplusBugNum - 1);
            }
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName = nameof(RB_Member_CoffeeCoupons_Extend.Id),
                      FiledValue = mModel.Id,
                       OperatorEnum =OperatorEnum.Equal
                }
            };
            bool flag = member_CoffeeCouponsRepository.Update(keyValues, wheres);
            if (flag) {
                //增加消费记录
                member_CoffeeLogRepository.Insert(new RB_Member_CoffeeLog()
                {
                    Id = 0,
                    BuyType = mModel.FreeNum > 0 ? 1 : 2,
                    Code = code,
                    CreateBy = userInfo.UserId,
                    UserId = userId,
                    CreateDate = DateTime.Now,
                    MallBaseId = userInfo.MallBaseId,
                    Number = 1,
                    OrderId = 0,
                    Remark = mModel.FreeNum > 0 ? "使用赠送咖啡" : "使用购买星巴克咖啡",
                    Type = 2
                });
            }
            var umodel = member_UserRepository.GetEntity(userId);
            return new
            {
                State = 1,
                Number = 1,
                Type,
                Name,
                umodel.Photo
            };
        }

        /// <summary>
        /// 获取我的咖啡劵使用
        /// </summary>
        /// <param name="code"></param>
        /// <param name="userInfo"></param>
        /// <param name="rmsg"></param>
        /// <returns></returns>
        public object GetMyCoffeeVerificatInfo(string code, AppletUserInfo userInfo, out string rmsg)
        {
            rmsg = "";
            var model = member_CoffeeLogRepository.GetList(new RB_Member_CoffeeLog_Extend() { MallBaseId = userInfo.MallBaseId, UserId = userInfo.UserId, Code = code }).FirstOrDefault();
            if (model == null) { rmsg = "未检测到消费数据"; return ""; }
            return new
            {
                model.Id,
                model.BuyType,
                model.Number
            };
        }

        #region 咖啡劵统计
        /// <summary>
        /// 获取咖啡劵统计
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public object GetCoffeeStatistics(RB_Member_CoffeeLog_Extend demodel)
        {
            DateTime STime = Convert.ToDateTime(demodel.StartTime + (demodel.SelectType == 2 ? "-01" : demodel.SelectType == 3 ? "-01-01" : ""));
            DateTime ETime = Convert.ToDateTime(demodel.EndTime + (demodel.SelectType == 2 ? "-01" : demodel.SelectType == 3 ? "-01-01" : ""));
            if (demodel.SelectType == 2)
            {
                demodel.StartTime = STime.ToString("yyyy-MM-dd");
                demodel.EndTime = ETime.AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
            }
            else if (demodel.SelectType == 3) {
                demodel.StartTime = STime.ToString("yyyy-MM-dd");
                demodel.EndTime = ETime.AddYears(1).AddDays(-1).ToString("yyyy-MM-dd");
            }
            //查询数据
            var list = member_CoffeeLogRepository.GetCoffeeStatisticsToDay(demodel, demodel.SelectType);
            if (list.Any()) {
                //查询核销人
                string accountIds = string.Join(",", list.Select(x => x.CreateBy).Distinct());
                var elist = accountRepository.GetEmployeeListRepository(new Model.Extend.Education.Employee_ViewModel() { QIds = accountIds });
                foreach (var item in list) {
                    item.EmpName = elist.Where(x => x.Id == item.CreateBy).FirstOrDefault()?.EmployeeName ?? "-";
                }
            }
            //查询当日收款
            var SKList = member_CoffeeLogRepository.GetCoffeeMoneyStatisticsToDay(demodel, demodel.SelectType);

            List<object> RList = new List<object>();
            //开始遍历组装数据
            while (true) {
                string DateStr = STime.ToString("yyyy-MM-dd");
                if (demodel.SelectType == 2)
                {
                    DateStr = STime.ToString("yyyy-MM");
                }
                else if(demodel.SelectType ==3) {
                    DateStr = STime.ToString("yyyy");
                }
                var clist = list.Where(x => x.Date == DateStr).ToList();
                var slist = SKList.Where(x => x.Date == DateStr).ToList();
                RList.Add(new
                {
                    Date = DateStr,
                    Income = slist.Sum(x => x.Income),
                    Total = clist.Sum(x => x.LBFreeNum + x.LBBuyNum + x.StuBuyNum + x.StuFreeNum + x.EmpBuyNum + x.EmpFreeNum),
                    CList = clist.Select(x => new
                    {
                        x.EmpName,
                        x.EmpBuyNum,
                        x.EmpFreeNum,
                        x.LBBuyNum,
                        x.LBFreeNum,
                        x.StuBuyNum,
                        x.StuFreeNum
                    })
                });
                if (STime == ETime)
                {
                    break;
                }
                if (demodel.SelectType == 1)
                {
                    STime = STime.AddDays(1);
                }
                else if (demodel.SelectType == 2)
                {
                    STime = STime.AddMonths(1);
                }
                else {
                    STime = STime.AddYears(1);
                }
            }
            return RList;
        }

        /// <summary>
        /// 咖啡劵导出
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<ExcelDataSource> GetCoffeeStatisticsToExcel(RB_Member_CoffeeLog_Extend demodel)
        {
            DateTime STime = Convert.ToDateTime(demodel.StartTime + (demodel.SelectType == 2 ? "-01" : demodel.SelectType == 3 ? "-01-01" : ""));
            DateTime ETime = Convert.ToDateTime(demodel.EndTime + (demodel.SelectType == 2 ? "-01" : demodel.SelectType == 3 ? "-01-01" : ""));
            if (demodel.SelectType == 2)
            {
                demodel.StartTime = STime.ToString("yyyy-MM-dd");
                demodel.EndTime = ETime.AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
            }
            else if (demodel.SelectType == 3)
            {
                demodel.StartTime = STime.ToString("yyyy-MM-dd");
                demodel.EndTime = ETime.AddYears(1).AddDays(-1).ToString("yyyy-MM-dd");
            }
            //查询数据
            var list = member_CoffeeLogRepository.GetCoffeeStatisticsToDay(demodel, demodel.SelectType);
            if (list.Any())
            {
                //查询核销人
                string accountIds = string.Join(",", list.Select(x => x.CreateBy).Distinct());
                var elist = accountRepository.GetEmployeeListRepository(new Model.Extend.Education.Employee_ViewModel() { QIds = accountIds });
                foreach (var item in list)
                {
                    item.EmpName = elist.Where(x => x.Id == item.CreateBy).FirstOrDefault()?.EmployeeName ?? "-";
                }
            }
            //查询当日收款
            var SKList = member_CoffeeLogRepository.GetCoffeeMoneyStatisticsToDay(demodel, demodel.SelectType);

            List<ExcelDataSource> RList = new List<ExcelDataSource>();
            //开始遍历组装数据
            while (true)
            {
                string DateStr = STime.ToString("yyyy-MM-dd");
                if (demodel.SelectType == 2)
                {
                    DateStr = STime.ToString("yyyy-MM");
                }
                else if (demodel.SelectType == 3)
                {
                    DateStr = STime.ToString("yyyy");
                }
                var clist = list.Where(x => x.Date == DateStr).ToList();
                var slist = SKList.Where(x => x.Date == DateStr).ToList();
                if (clist.Any())
                {
                    int rowSpan = clist.Count();
                    for (var i = 0; i < rowSpan; i++)
                    {
                        var cmodel = clist[i];
                        if (i == 0)
                        {
                            ExcelDataSource datarow = new ExcelDataSource()
                            {
                                ExcelRows = new List<ExcelColumn>(30) {
                                new ExcelColumn(value: DateStr){ Rowspan = rowSpan },
                                new ExcelColumn(value: cmodel.EmpName){ },
                                new ExcelColumn(value: cmodel.EmpFreeNum.ToString()){ },
                                new ExcelColumn(value: cmodel.EmpBuyNum.ToString()){ },
                                new ExcelColumn(value: cmodel.StuFreeNum.ToString()){ },
                                new ExcelColumn(value: cmodel.StuBuyNum.ToString()){ },
                                new ExcelColumn(value: cmodel.LBFreeNum.ToString()){ },
                                new ExcelColumn(value: cmodel.LBBuyNum.ToString()){ },
                                new ExcelColumn(value: slist.Sum(x => x.Income).ToString("#0.00")){ Rowspan = rowSpan },
                                new ExcelColumn(value: clist.Sum(x => x.LBFreeNum + x.LBBuyNum + x.StuBuyNum + x.StuFreeNum + x.EmpBuyNum + x.EmpFreeNum).ToString()){ Rowspan = rowSpan },
                            },
                                ColumnHight = 30
                            };
                            RList.Add(datarow);
                        }
                        else
                        {
                            ExcelDataSource datarow = new ExcelDataSource()
                            {
                                ExcelRows = new List<ExcelColumn>(30) {
                                new ExcelColumn(value: ""){ },
                                new ExcelColumn(value: cmodel.EmpName){ },
                                new ExcelColumn(value: cmodel.EmpFreeNum.ToString()){ },
                                new ExcelColumn(value: cmodel.EmpBuyNum.ToString()){ },
                                new ExcelColumn(value: cmodel.StuFreeNum.ToString()){ },
                                new ExcelColumn(value: cmodel.StuBuyNum.ToString()){ },
                                new ExcelColumn(value: cmodel.LBFreeNum.ToString()){ },
                                new ExcelColumn(value: cmodel.LBBuyNum.ToString()){ },
                                new ExcelColumn(value: ""){ },
                                new ExcelColumn(value: ""){ },
                            },
                                ColumnHight = 30
                            };
                            RList.Add(datarow);
                        }
                    }
                }
                else {
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                                new ExcelColumn(value: DateStr){ },
                                new ExcelColumn(value: ""){ },
                                new ExcelColumn(value: ""){ },
                                new ExcelColumn(value: ""){ },
                                new ExcelColumn(value: ""){ },
                                new ExcelColumn(value: ""){ },
                                new ExcelColumn(value: ""){ },
                                new ExcelColumn(value: ""){ },
                                new ExcelColumn(value: slist.Sum(x => x.Income).ToString("#0.00")){ },
                                new ExcelColumn(value: ""){ },
                            },
                        ColumnHight = 30
                    };
                    RList.Add(datarow);
                }
                
                if (STime == ETime)
                {
                    break;
                }
                if (demodel.SelectType == 1)
                {
                    STime = STime.AddDays(1);
                }
                else if (demodel.SelectType == 2)
                {
                    STime = STime.AddMonths(1);
                }
                else
                {
                    STime = STime.AddYears(1);
                }
            }
            return RList;
        }

        /// <summary>
        /// 获取咖啡劵消费列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_CoffeeLog_Extend> GetCoffeeCouponsPageList(int pageIndex, int pageSize, out long count, RB_Member_CoffeeLog_Extend demodel)
        {
            var list = member_CoffeeLogRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any()) {
                var userIds = string.Join(",", list.Select(x => x.UserId + "," + x.CreateBy));
                var memberList = member_UserRepository.GetList(new Model.Extend.User.RB_Member_User_Extend() { MallBaseId = demodel.MallBaseId, UserIds = userIds });
                var eduSellList = education_EduSellRepository.GetEducationStuList(new Model.Extend.Education.RB_Education_EduSell_Extend() { MallBaseId = demodel.MallBaseId, Ids = userIds }, true);
                List<Model.Extend.Education.Employee_ViewModel> empList = new List<Model.Extend.Education.Employee_ViewModel>();
                List<Model.Extend.Education.RB_Account_ViewModel> StuList = new List<Model.Extend.Education.RB_Account_ViewModel>();
                if (eduSellList.Any()) {
                    string EmpIds = string.Join(",", eduSellList.Where(x => x.Type == 1).Select(x => x.EduSellId));
                    string StuIds = string.Join(",", eduSellList.Where(x => x.Type == 2).Select(x => x.EduSellId));
                    if (!string.IsNullOrEmpty(EmpIds)) {
                        empList = accountRepository.GetEmployeeListRepository(new Model.Extend.Education.Employee_ViewModel() { QIds = EmpIds });
                    }
                    if (!string.IsNullOrEmpty(StuIds)) {
                        StuList = accountRepository.GetStudentExt(new Model.Extend.Education.RB_Account_ViewModel() { QIds = StuIds });
                    }
                }

                foreach (var item in list) {

                    item.UserName = memberList.Where(x => x.Id == item.UserId).FirstOrDefault()?.Name ?? "";
                    item.UserIcon = memberList.Where(x => x.Id == item.UserId).FirstOrDefault()?.Photo ?? "";
                    var eduSellModel = eduSellList.Where(x => x.UserId == item.UserId).FirstOrDefault();
                    if (eduSellModel == null)
                    {
                        item.EmpType = 3;
                    }
                    else {
                        if (eduSellModel.Type == 1)
                        {
                            item.EmpStuName = empList.Where(x => x.Id == eduSellModel.EduSellId).FirstOrDefault()?.EmployeeName ?? "";
                        }
                        else {
                            item.EmpStuName = StuList.Where(x => x.Id == eduSellModel.EduSellId).FirstOrDefault()?.AccountName ?? "";
                        }
                        if (eduSellModel.Type == 2 && eduSellModel.StuIsEmp == 0)
                        {
                            item.EmpType = 2;
                        }
                        else {
                            item.EmpType = 1;
                        }
                    }
                    var createByModel = eduSellList.Where(x => x.UserId == item.CreateBy).FirstOrDefault();
                    if (createByModel != null && createByModel.Type == 1)
                    {
                        item.EmpName = empList.Where(x => x.Id == createByModel.EduSellId).FirstOrDefault()?.EmployeeName ?? "";
                    }
                }
            }
            return list;
        }
        #endregion
    }
}
