﻿using Mall.Model.Entity.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.BaseSetUp
{
    /// <summary>
    /// 快递配置仓储层
    /// </summary>
    public class RB_Express_ConfigRepository : BaseRepository<RB_Express_Config>
    {

        /// <summary>
        /// 获取上传存储信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Express_Config> GetListRepository(RB_Express_Config query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM RB_Express_Config WHERE {nameof(RB_Express_Config.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Express_Config.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Express_Config.MallBaseId)}={query.MallBaseId}");
                }
                if (query.Type > 0)
                {
                    builder.Append($" AND {nameof(RB_Express_Config.Type)}={query.Type}");
                }
                if (query.IsDefault > 0) 
                {
                    builder.Append($" AND {nameof(RB_Express_Config.IsDefault)}={query.IsDefault}");
                }
            }
            return Get<RB_Express_Config>(builder.ToString()).ToList();
        }
    }
}
