﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Extend.Education;

namespace Mall.Repository.Education
{
   public class RB_StudentRepository:BaseRepository<RB_Student>
    {
        /// <summary>
        /// 获取学生列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Student> GetStudentList(RB_Student query)
        {
            
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"SELECT t.* FROM rb_student AS t WHERE 1=1 ");
            builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.Group_Id), query.Group_Id);
                }
                if (query.School_Id > -1)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.School_Id), query.School_Id);
                }
              
                if (!string.IsNullOrWhiteSpace(query.StuTel))
                {
                    builder.AppendFormat(" AND t.{0}='{1}' ", nameof(RB_Student.StuTel),query.StuTel);
                   // parameters.Add("StuTel", "%" + query.StuTel.Trim() + "%");
                }
                if (query.ProviceId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.ProviceId), query.ProviceId);
                }
                if (query.CityId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.CityId), query.CityId);
                }
                if (query.AreaId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.AreaId), query.AreaId);
                }
                
            }
            return Get<RB_Student>(builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取学生列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Student> GetStudentListByEnterID(RB_Student query,int EnterID)
        {

            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"SELECT t.* from rb_student as t LEFT JOIN RB_Student_OrderGuest  as sog on t.StuId=sog.Student_Id
LEFT JOIN rb_order_guest as og on og.Id=sog.GuestId
LEFT JOIN rb_order as o on o.OrderId=og.OrderId  WHERE 1=1  and o.OrderState<>3  and og.`Status`=0 and sog.`Status`=0");
            builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.Group_Id), query.Group_Id);
                }
                if (query.School_Id > -1)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.School_Id), query.School_Id);
                }

                if (!string.IsNullOrWhiteSpace(query.StuTel))
                {
                    builder.AppendFormat(" AND t.{0}='{1}' ", nameof(RB_Student.StuTel), query.StuTel);
                    // parameters.Add("StuTel", "%" + query.StuTel.Trim() + "%");
                }
                if (query.ProviceId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.ProviceId), query.ProviceId);
                }
                if (query.CityId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.CityId), query.CityId);
                }
                if (query.AreaId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.AreaId), query.AreaId);
                }
                if (query.StuId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student.StuId), query.StuId);
                }
                if (EnterID > 0)
                {
                    builder.AppendFormat(" AND o.EnterID={0} ", EnterID);
                }
            }
            return Get<RB_Student>(builder.ToString()).ToList();
        }

    }
}
