﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 公司信息仓储层
    /// </summary>
    public class RB_CompanyEnterpriseRepository : BaseRepository<RB_CompanyEnterprise>
    {
        /// <summary>
        /// 获取公司信息分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_CompanyEnterprise_Extend> GetCompanyEnterprisePageRepository(int pageIndex, int pageSize, out long rowsCount, RB_CompanyEnterprise_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_CompanyEnterprise
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_CompanyEnterprise_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.CreateBy > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.CreateBy), query.CreateBy);
                }
                if (query.CompanyStatus > -1)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.CompanyStatus), query.CompanyStatus);
                }
                if (!string.IsNullOrEmpty(query.CompanyName))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_CompanyEnterprise_Extend.CompanyName));
                    parameters.Add("Name", "%" + query.CompanyName.Trim() + "%");
                }
            }
            builder.AppendFormat(" order by CompanyId desc ");
            return GetPage<RB_CompanyEnterprise_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 根据查询条件获取公司信息实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_CompanyEnterprise_Extend GetCompanyRepository(RB_CompanyEnterprise_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_CompanyEnterprise
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new RB_CompanyEnterprise_Extend();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.CompanyName))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_CompanyEnterprise_Extend.CompanyName));
                    parameters.Add("Name", "%" + query.CompanyName.Trim() + "%");
                }
                if (query.CreateBy > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.CreateBy), query.CreateBy);
                }
            }
            return Get<RB_CompanyEnterprise_Extend>(builder.ToString(), parameters).FirstOrDefault();
        }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_CompanyEnterprise_Extend> GetCompanyListRepository(RB_CompanyEnterprise_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_CompanyEnterprise
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_CompanyEnterprise_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.CompanyName))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_CompanyEnterprise_Extend.CompanyName));
                    parameters.Add("Name", "%" + query.CompanyName.Trim() + "%");
                }
                if (query.CreateBy > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyEnterprise_Extend.CreateBy), query.CreateBy);
                }
                if (!string.IsNullOrEmpty(query.UserIds))
                {
                    builder.AppendFormat(" AND {0} in({1}) ", nameof(RB_CompanyEnterprise_Extend.CreateBy), query.UserIds);
                }
            }
            return Get<RB_CompanyEnterprise_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
