using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;

namespace Mall.WebApi
{
    public class Program
    {
        public static void Main(string[] args)
        {
            CreateHostBuilder(args).Build().Run();
        }

        public static IHostBuilder CreateHostBuilder(string[] args) =>
            Host.CreateDefaultBuilder(args)
                .ConfigureWebHostDefaults(webBuilder =>
                {
                    webBuilder.ConfigureKestrel((context, options) =>
                    {
                        options.AllowSynchronousIO = true;
                        //Ӧ÷KestrelΪ100MB
                        options.Limits.MaxRequestBodySize = 104857600;
                        //쳣
                        options.Limits.MinRequestBodyDataRate = null;
                        options.Limits.KeepAliveTimeout = TimeSpan.FromMinutes(2);
                    });
                    webBuilder.UseStartup<Startup>().UseIIS();
                });
    }
}
