﻿using Mall.Common.Enum;
using System;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 活力楼宇实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Building
    {
        /// <summary>
		/// 楼宇主键Id
		/// </summary>
		public int BuildId { get; set; }

        /// <summary>
        /// 楼宇名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 楼宇图片
        /// </summary>
        public string Banner { get; set; }

        /// <summary>
        /// 楼宇位置
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// 经纬度
        /// </summary>
        public string LatAndLon { get; set; }

        /// <summary>
        /// 投运时间
        /// </summary>
        public string OperationTime { get; set; }

        /// <summary>
        /// 楼宇等级
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        /// 面积
        /// </summary>
        public string Areas { get; set; }

        /// <summary>
        /// 楼栋数
        /// </summary>
        public string BuildingNum { get; set; }

        /// <summary>
        /// 楼层数
        /// </summary>
        public string FloorNum { get; set; }

        /// <summary>
        /// 电梯数
        /// </summary>
        public string ElevatorNum { get; set; }

        /// <summary>
        /// 层高
        /// </summary>
        public decimal FloorHeight { get; set; }

        /// <summary>
        /// 开发商
        /// </summary>
        public string Developers { get; set; }

        /// <summary>
        /// 物业公司
        /// </summary>
        public string PropertyComp { get; set; }

        /// <summary>
        /// 销售自持比例
        /// </summary>
        public string SaleOrSelf { get; set; }

        /// <summary>
        /// 是否统一运营(1-是，0-否)
        /// </summary>
        public int IsAllOperate { get; set; }

        /// <summary>
        /// 建设时间
        /// </summary>
        public string ConstructionTime { get; set; }

        /// <summary>
        /// 物业费(元/㎡)
        /// </summary>
        public decimal PropertyFee { get; set; }

        /// <summary>
        /// 月租金(元/㎡)
        /// </summary>
        public decimal RentFee { get; set; }

        /// <summary>
        /// 产业方向
        /// </summary>
        public string IndustryDirection { get; set; }

        /// <summary>
        /// 目标企业招引需求
        /// </summary>
        public string BrandDemand { get; set; }

        /// <summary>
        /// 其他需求
        /// </summary>
        public string Other { get; set; }

        /// <summary>
        /// 联系人
        /// </summary>
        public string ContactName { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string ContactPhone { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }

        /// <summary>
        /// 小程序对应的员工id
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public int SortNum { get; set; }
    }
}
