﻿using Mall.DataHelper.Import;
using Mall.Repository.TradePavilion;
using Mall.ThirdCore.Oss;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace TestCore
{
    class Program
    {
        static string rootPath = Path.Combine(Directory.GetCurrentDirectory(), "upfile");
        static string tempPath = rootPath + @"\TempImport\TempFile";
        static string ViewFileSiteUrl = "https://viitto-1301420277.cos.ap-chengdu.myqcloud.com";

        /// <summary>
        /// 分类仓储层
        /// </summary>
        private static RB_BrandClassRepository brandClassRepository = new RB_BrandClassRepository();

        /// <summary>
        /// 品牌仓储层
        /// </summary>
        private static RB_Brand_EnterpriseRepository brand_EnterpriseRepository = new RB_Brand_EnterpriseRepository();

        /// <summary>
        /// 载体仓储层
        /// </summary>
        private static RB_Building_CarrierRepository building_CarrierRepository = new RB_Building_CarrierRepository();

        /// <summary>
        /// 楼宇仓储层
        /// </summary>
        private static RB_BuildingRepository buildingRepository = new RB_BuildingRepository();

        /// <summary>
        /// 企业服务仓储层
        /// </summary>
        private static RB_EnterpriseServicesRepository enterpriseServicesRepository = new RB_EnterpriseServicesRepository();

        static void Main(string[] args)
        {
            Console.WriteLine("开始.." );
            int Type = 3;
            //品牌
            if (Type == 1)
            {
                BrandImport();
            }
            //载体
            else if (Type == 2)
            {
                CarrierImport();
            }
            //楼宇
            else if (Type == 3)
            {
                BuildingImport();
            }
            //企业服务
            else
            {
                EnterpriseImport();
            }
            Console.WriteLine("结束..");
            Console.ReadKey();
        }

        /// <summary>
        /// 品牌导入
        /// </summary>
        static void BrandImport()
        {
            string brandFile = rootPath + @"\消费品牌导入.xlsx";
            Console.WriteLine("Start解析品牌文件...");
            var brandList = BrandHelper.ImportYBBrandData(brandFile, tempPath);
            Console.WriteLine("End解析品牌文件...");
            var categoryList = brandClassRepository.GetBrandClassListRepository(new Mall.Model.Extend.TradePavilion.RB_BrandClass_Extend() { });
            Console.WriteLine("开始导入品牌数据...");
            foreach (var item in brandList)
            {
                item.BrandEnterpriseType = 1;
                item.FullBrandName = item.BrandName;
                if (!string.IsNullOrEmpty(item.Logo))
                {
                    OssResult logoObj = SaveImg(item.Logo);
                    if (logoObj != null && logoObj.resultCode == 1)
                    {
                        item.Logo = ViewFileSiteUrl + logoObj.data;
                    }
                }
                if (!string.IsNullOrEmpty(item.Banner))
                {
                    List<string> bannerList = new List<string>();
                    var tempArray = item.Banner.Split(',');
                    if (tempArray != null && tempArray.Length > 0)
                    {
                        foreach (var tItem in tempArray)
                        {
                            if (!string.IsNullOrEmpty(tItem))
                            {
                                OssResult bObj = SaveImg(tItem);
                                if (bObj.resultCode == 1)
                                {
                                    bannerList.Add(ViewFileSiteUrl + bObj.data);
                                }
                            }
                        }
                    }
                    item.Banner = Mall.Common.Plugin.JsonHelper.Serialize(bannerList);
                }
                if (!string.IsNullOrEmpty(item.CategoryName))
                {
                    var tempCategory = categoryList.FirstOrDefault(qitem => qitem.ClassName.Trim() == item.CategoryName.Trim());
                    item.CategoryId = tempCategory?.ID ?? 0;
                }
                item.TenantId = 30;
                item.MallBaseId = 20;
                item.CreateBy = 30;
                item.CreateDate = DateTime.Now;
                item.UpdateBy = 30;
                item.UpdateDate = DateTime.Now;
            }
            bool flag = false;
            if (brandList != null && brandList.Count > 0)
            {
                flag= brand_EnterpriseRepository.InsertBatch(brandList);
            }
            Console.WriteLine("BrandImport::Flag_{0}  Params:{1} ", flag, Mall.Common.Plugin.JsonHelper.Serialize(brandList));
        }



        /// <summary>
        /// 商业载体导入
        /// </summary>
        static void CarrierImport()
        {
            Console.WriteLine("Start 解析载体文件...");
            string carrierFile = rootPath + @"\商业载体导入.xlsx";
            Console.WriteLine("End   解析载体文件...");
        
            var carrierList = CarrierHelper.ImportYBCarrierData(carrierFile, tempPath);
            var categoryList = brandClassRepository.GetBrandClassListRepository(new Mall.Model.Extend.TradePavilion.RB_BrandClass_Extend() { });
            Console.WriteLine("开始导入载体数据...");
            foreach (var item in carrierList)
            {
                item.BuildingCarrierType = 1;
                if (!string.IsNullOrEmpty(item.Logo))
                {
                    OssResult logoObj = SaveImg(item.Logo);
                    if (logoObj != null && logoObj.resultCode == 1)
                    {
                        item.Logo = ViewFileSiteUrl + logoObj.data;
                    }
                }
                if (!string.IsNullOrEmpty(item.CategoryName))
                {
                    var tempCategory = categoryList.FirstOrDefault(qitem => qitem.ClassName.Trim() == item.CategoryName.Trim());
                    item.CategoryId = tempCategory?.ID ?? 0;
                }

                item.TenantId = 30;
                item.MallBaseId = 20;
                item.CreateBy = 30;
                item.CreateDate = DateTime.Now;
                item.UpdateBy = 30;
                item.UpdateDate = DateTime.Now;
            }
            bool flag = false;
            if (carrierList != null && carrierList.Count > 0)
            {
                flag= building_CarrierRepository.InsertBatch(carrierList);
            }
            Console.WriteLine("CarrierImport::flag_{0} params_{1}",flag, Mall.Common.Plugin.JsonHelper.Serialize(carrierList));
        }

        /// <summary>
        /// 楼宇导入
        /// </summary>
        static void BuildingImport()
        {
            Console.WriteLine("Start 解析楼宇文件...");
            string buildingFile = rootPath + @"\活力楼宇导入.xlsx";
            var buildingList = BuildingHelper.ImportYBuildingData(buildingFile, tempPath);
            var categoryList = brandClassRepository.GetBrandClassListRepository(new Mall.Model.Extend.TradePavilion.RB_BrandClass_Extend() { });
            var oldBuildList = buildingRepository.GetBuildingRepository(new Mall.Model.Extend.TradePavilion.RB_Building_Extend() { TenantId = 30, MallBaseId = 20 });
            Console.WriteLine("End 解析楼宇文件...");
            Console.WriteLine("开始导入楼宇数据...");
            foreach (var item in buildingList)
            {
                if (!string.IsNullOrEmpty(item.Name))
                {
                    if (!string.IsNullOrEmpty(item.Banner))
                    {
                        List<string> bannerList = new List<string>();
                        var tempArray = item.Banner.Split(',');
                        if (tempArray != null && tempArray.Length > 0)
                        {
                            foreach (var tItem in tempArray)
                            {
                                if (!string.IsNullOrEmpty(tItem))
                                {
                                    OssResult bObj = SaveImg(tItem);
                                    if (bObj.resultCode == 1)
                                    {
                                        bannerList.Add(ViewFileSiteUrl + bObj.data);
                                    }
                                }
                            }
                        }
                        item.Banner = Mall.Common.Plugin.JsonHelper.Serialize(bannerList);
                    }
                    if (!string.IsNullOrEmpty(item.CategoryName))
                    {
                        var tempCategory = categoryList.FirstOrDefault(qitem => qitem.ClassName.Trim() == item.CategoryName.Trim());
                        item.CategoryId = tempCategory?.ID ?? 0;
                    }
                    var tempBuild = oldBuildList?.FirstOrDefault(qitem => qitem.Name == item.Name);
                    item.BuildId = tempBuild?.BuildId ?? 0;
                    item.TenantId = 30;
                    item.MallBaseId = 20;
                    item.CreateBy = 30;
                    item.CreateDate = DateTime.Now;
                    item.UpdateBy = 30;
                    item.UpdateDate = DateTime.Now;
                }
            }
            bool flag = false;
            string str = Mall.Common.Plugin.JsonHelper.Serialize(buildingList);

            if (buildingList != null && buildingList.Count > 0)
            {
                flag= buildingRepository.InsertBatch(buildingList);
                //buildingRepository.UpdateBatch
            }
            Console.WriteLine("BuildingImport::Flag_{0} params:{1}", flag, Mall.Common.Plugin.JsonHelper.Serialize(buildingList));
        }

        /// <summary>
        /// 企业服务导入
        /// </summary>
        static void EnterpriseImport()
        {
            Console.WriteLine("Start 解析企业服务文件...");
            string enterpriseFile = rootPath + @"\企业服务导入.xlsx";
            var enterpriseList = EnterpriseServiceHelper.ImportYBEnterpriseData(enterpriseFile, tempPath);
            var categoryList = brandClassRepository.GetBrandClassListRepository(new Mall.Model.Extend.TradePavilion.RB_BrandClass_Extend() { });
            Console.WriteLine("End 解析企业服务文件...");
            Console.WriteLine("开始导入企业服务文件...");
            foreach (var item in enterpriseList)
            {
                if (!string.IsNullOrEmpty(item.Banner))
                {
                    List<string> bannerList = new List<string>();
                    var tempArray = item.Banner.Split(',');
                    if (tempArray != null && tempArray.Length > 0)
                    {
                        foreach (var tItem in tempArray)
                        {
                            if (!string.IsNullOrEmpty(tItem))
                            {
                                OssResult bObj = SaveImg(tItem);
                                if (bObj.resultCode == 1)
                                {
                                    bannerList.Add(ViewFileSiteUrl + bObj.data);
                                }
                            }
                        }
                    }
                    item.Banner = Mall.Common.Plugin.JsonHelper.Serialize(bannerList);
                }
                if (!string.IsNullOrEmpty(item.CategoryName))
                {
                    var tempCategory = categoryList.FirstOrDefault(qitem => qitem.ClassName.Trim() == item.CategoryName.Trim());
                    item.CategoryId = tempCategory?.ID ?? 0;
                }
                if (!string.IsNullOrEmpty(item.ETypeName))
                {
                    var tempCategory = categoryList.FirstOrDefault(qitem => qitem.ClassName.Trim() == item.ETypeName.Trim());
                    item.EType = tempCategory?.ID ?? 0;
                }
                item.TenantId = 30;
                item.MallBaseId = 20;
                item.CreateBy = 30;
                item.CreateDate = DateTime.Now;
                item.UpdateBy = 30;
                item.UpdateDate = DateTime.Now;
            }
            bool flag = false;
            if(enterpriseList!=null && enterpriseList.Count > 0)
            {
                flag= enterpriseServicesRepository.InsertBatch(enterpriseList);
            }
            Console.WriteLine("EnterpriseImport::flag_{0} params:{1}",flag, Mall.Common.Plugin.JsonHelper.Serialize(enterpriseList));
        }

        /// <summary>
        /// 上传图片
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        static OssResult SaveImg(string path)
        {
            OssResult result = new OssResult();
            if (!string.IsNullOrEmpty(path))
            {
                result = UploadHelper.UploadFileToTencent(path);
            }
            return result;
        }
    }
}
