﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.MarketingCenter;
using Mall.Module.MarketingCenter;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.MarketingCenter
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class CouponController : BaseController
    {
        private CouponModule IntegralModule = new CouponModule();



        #region 卡券

        [HttpPost]
        public ApiResult GetCouponPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Coupon_Extend demodel = JsonConvert.DeserializeObject<RB_Coupon_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = IntegralModule.GetCouponPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.Name,
                x.HeXiao,
                x.CouponIco,
                x.StartDate,
                x.IndateType,
                x.IndateDay,
                x.EndDate,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCouponDetail()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Coupon_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = IntegralModule.GetCouponList(query).FirstOrDefault();
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Coupon_Extend();
                oldLogisticsModel.IndateType = Common.Enum.MarketingCenter.IndateTypeEnum.DayHorizon;
            }
            return ApiResult.Success("", oldLogisticsModel);
        }


        /// <summary>
        /// 保存物流信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult AddOrUpdateCoupon()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Coupon_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入卡券信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.Name))
                {
                    return ApiResult.Failed("请输入卡券名称");
                }
                if (string.IsNullOrWhiteSpace(query.CouponIco))
                {
                    return ApiResult.Failed("请输入卡券图标");
                }
                if (query.IndateType == Common.Enum.MarketingCenter.IndateTypeEnum.DayHorizon)
                {
                    if (query.IndateDay == 0)
                    {
                        return ApiResult.Failed("请输入有效期天数");
                    }
                }
                else
                {
                    if (!query.StartDate.HasValue || !query.EndDate.HasValue)
                    {
                        return ApiResult.Failed("开始日期或结束日期必填");
                    }
                    if (query.StartDate < query.EndDate)
                    {
                        return ApiResult.Failed("开始日期必须小于结束日期");
                    }
                }
                if (query.HeXiao == 0)
                {
                    return ApiResult.Failed("请输入核销总次数");
                }

                if (query.TotalNum == 0)
                {
                    return ApiResult.Failed("请输入可发放数量");
                }

                if (string.IsNullOrWhiteSpace(query.Describe))
                {
                    return ApiResult.Failed("请输入卡券描述");
                }
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = IntegralModule.AddOrUpdateCoupon(query);
                if (result)
                {
                    return ApiResult.Success("卡券信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("卡券信息保存失败");
                }
            }
        }

        /// <summary>
        /// 删除卡券
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelRules()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            int Id = parmsJob.GetInt("Id", 0);
            if (Id <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            bool flag = IntegralModule.DelCoupon(Id, UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }
        #endregion

        #region 优惠券

        [HttpPost]
        public ApiResult GetDiscountCouponPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_DiscountCoupon_Extend demodel = JsonConvert.DeserializeObject<RB_DiscountCoupon_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = IntegralModule.GetDiscountCouponPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.Name,
                x.MinConsumePrice,
                x.DiscountsPrice,
                x.UseType,
                x.CouponType,
                x.StartDate,
                x.IndateType,
                x.IndateDay,
                x.EndDate,
                x.TotalNum,
                ResidueNum = x.TotalNum - x.ReceiveNum,
                x.PickupType
            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetDiscountCouponDetail()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_DiscountCoupon_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = IntegralModule.GetDiscountCouponList(query).FirstOrDefault();
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_DiscountCoupon_Extend();
                oldLogisticsModel.IndateType = Common.Enum.MarketingCenter.IndateTypeEnum.DayHorizon;
            }
            return ApiResult.Success("", oldLogisticsModel);
        }


        /// <summary>
        /// 保存优惠券
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult AddOrUpdateDiscountCoupon()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_DiscountCoupon_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入卡券信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.Name))
                {
                    return ApiResult.Failed("请输入卡券名称");
                }
                if (query.IndateType == Common.Enum.MarketingCenter.IndateTypeEnum.DayHorizon)
                {
                    if (query.IndateDay == 0)
                    {
                        return ApiResult.Failed("请输入有效期天数");
                    }
                }
                else
                {
                    if (!query.StartDate.HasValue || !query.EndDate.HasValue)
                    {
                        return ApiResult.Failed("开始日期或结束日期必填");
                    }
                    if (query.StartDate < query.EndDate)
                    {
                        return ApiResult.Failed("开始日期必须小于结束日期");
                    }
                }


                if (query.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category || query.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product)
                {
                    if (query.ProductList == null || !query.ProductList.Any())
                    {
                        return ApiResult.Failed(query.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category?"请选择商品类别": "请选择商品");
                    }
                }
                if (query.TotalNum == 0)
                {
                    return ApiResult.Failed("请输入可发放数量");
                }

                if (string.IsNullOrWhiteSpace(query.Describe))
                {
                    return ApiResult.Failed("请输入卡券描述");
                }
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = IntegralModule.AddOrUpdateDiscountCoupon(query);
                if (result)
                {
                    return ApiResult.Success("优惠券信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("优惠券信息保存失败");
                }
            }
        }

        /// <summary>
        /// 删除优惠券
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelDiscountCoupon()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            int Id = parmsJob.GetInt("Id", 0);
            if (Id <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            bool flag = IntegralModule.DelDiscountCoupon(Id, UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }
        #endregion
    }
}