﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 收藏仓储层
    /// </summary>
    public class RB_CollectRepository : BaseRepository<RB_Collect>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Collect); } }

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Collect_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Collect_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Collect_Extend.Status)}=0 ");
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Collect_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Collect_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.Type > 0)
                {
                    builder.Append($" AND {nameof(RB_Collect_Extend.Type)}={query.Type}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Collect_Extend.UserId)}={query.UserId}");
                }
                if (query.SourceId > 0)
                {
                    builder.Append($" AND {nameof(RB_Collect_Extend.SourceId)}={query.SourceId}");
                }
            }
            builder.Append($" order by Id desc");
            return GetPage<RB_Collect_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 收藏列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Collect_Extend> GetList(RB_Collect_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Collect_Extend.Status)}=0 ");
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Collect_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Collect_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.Type > 0)
                {
                    builder.Append($" AND {nameof(RB_Collect_Extend.Type)}={query.Type}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Collect_Extend.UserId)}={query.UserId}");
                }
                if (query.SourceId > 0)
                {
                    builder.Append($" AND {nameof(RB_Collect_Extend.SourceId)}={query.SourceId}");
                }
            }
            builder.Append($" order by Id desc");
            return Get<RB_Collect_Extend>(builder.ToString()).ToList();
        }
    }
}
