﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品订单返佣信息表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderCommission
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 订单id
        /// </summary>        
        public int? OrderId
        {
            get;
            set;
        }
        /// <summary>
        /// 订单明细id
        /// </summary>
        public int? OrderDetailId { get; set; }
        /// <summary>
        /// 分销商id
        /// </summary>        
        public int? UserId
        {
            get;
            set;
        }
        /// <summary>
        /// 等级  一级分销   二级分销 （跟下线正好相反）  0表示自购返佣   //和平+粉象 都是存GradeId
        /// </summary>        
        public int? Grade
        {
            get;
            set;
        }
        /// <summary>
        /// 佣金
        /// </summary>        
        public decimal? Commission
        {
            get;
            set;
        }
        /// <summary>
        /// 是否是商品设置分销反佣   1是  2否
        /// </summary>        
        public int? IsGoodsDistribution
        {
            get;
            set;
        }
        /// <summary>
        /// 佣金状态  1待返佣   2已返佣  
        /// </summary>        
        public int? CommissionState
        {
            get;
            set;
        }
        /// <summary>
        /// 类型  1标准返佣   2和平返佣   3粉象返佣
        /// </summary>
        public int? Type { get; set; }
        /// <summary>
        /// Remark
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }

        public int? IsRemit { get; set; }
    }

    /// <summary>
    /// 粉象返佣数量记录
    /// </summary>
    public class FXOrderCommissionNumModel { 

        public int GradeId { get; set; }

        public int Grade { get; set; }

        public decimal Money { get; set; }

        public int Sort { get; set; }

        public int IsSelfBuy { get; set; }
    }
}
