﻿using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.BaseSetUp
{
    /// <summary>
    /// 分类包邮规则仓储层
    /// </summary>
    public class RB_FreeShippingRepository : BaseRepository<RB_FreeShipping>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_FreeShipping); } }
        /// <summary>
        /// 物料规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_FreeShipping_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_FreeShipping_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_FreeShipping_Extend.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_FreeShipping_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_FreeShipping_Extend.MallBaseId)}={query.MallBaseId}");
                }
            }
            return GetPage<RB_FreeShipping_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 物流规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_FreeShipping_Extend> GetFreeShippingList(RB_FreeShipping_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_FreeShipping_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_FreeShipping_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_FreeShipping_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_FreeShipping_Extend.MallBaseId)}={query.MallBaseId}");
                }
            }
            return Get<RB_FreeShipping_Extend>(builder.ToString()).ToList();
        }


        /// <summary>
        /// 物流规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_FreeShipping_Extend> GetFreeShippingListByCategoryIds(RB_FreeShipping_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.*,b.CategoryId,c.IsFreeShipping from rb_freeshipping as a LEFT JOIN rb_freeshippingcategory as b on a.ID=b.FreeShippingId 
INNER JOIN rb_mallbase as c on a.MallBaseId = c.ID and a.TenantId = c.TenantId WHERE a.{nameof(RB_FreeShipping_Extend.Status)}=0 ");
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_FreeShipping_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_FreeShipping_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.CategoryIds))
                {
                    query.CategoryIds += ",0";
                    builder.Append($" AND b.{nameof(RB_FreeShippingCategory_Extend.CategoryId)} in({query.CategoryIds})");
                }
            }
            return Get<RB_FreeShipping_Extend>(builder.ToString()).ToList();
        }
    }
}
