﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单物流关联仓储层
    /// </summary>
    public class RB_Goods_ExpressRelevanceRepository : BaseRepository<RB_Goods_ExpressRelevance>
    {

        /// <summary>
        /// 获取订单明细列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_ExpressRelevance_Extend> GetList(RB_Goods_ExpressRelevance_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_ExpressRelevance.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_ExpressRelevance.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and {nameof(RB_Goods_ExpressRelevance.OrderId)}={dmodel.OrderId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds)) 
            {
                where += $@" and {nameof(RB_Goods_ExpressRelevance.OrderId)} in({dmodel.OrderIds})";
            }
            if (dmodel.OrderDetailId > 0)
            {
                where += $@" and {nameof(RB_Goods_ExpressRelevance.OrderDetailId)}={dmodel.OrderDetailId}";
            }
            if (dmodel.OrderExpressId > 0)
            {
                where += $@" and {nameof(RB_Goods_ExpressRelevance.OrderExpressId)}={dmodel.OrderExpressId}";
            }

            string sql = $@"SELECT * FROM RB_Goods_ExpressRelevance where {where} order by Id asc";
            return Get<RB_Goods_ExpressRelevance_Extend>(sql).ToList();
        }
    }
}
