﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 耗材仓库库存仓储类
    /// </summary>
    public partial class RB_Supplies_InventoryRepository : BaseRepository<RB_Supplies_Inventory>
    {
        /// <summary>
        /// 获取耗材仓库库存分页数据
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Supplies_Inventory_Extend> GetPageList(int pageIndex, int pageSize, RB_Supplies_Inventory_Extend dmodel, out long count)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Supplies_Inventory_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";            
            if (dmodel.WarehouseId > 0) {
                where += " and " + nameof(RB_Supplies_Inventory_Extend.WarehouseId) + $" ={dmodel.WarehouseId}";
            }
            if (dmodel.SuppliesId > 0)
            {
                where += " and " + nameof(RB_Supplies_Inventory_Extend.SuppliesId) + $" ={dmodel.SuppliesId}";
            }

            string sql = $@" select * from RB_Supplies_Inventory {where} order by Id desc";
            return GetPage<RB_Supplies_Inventory_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Supplies_Inventory_Extend> GetList(RB_Supplies_Inventory_Extend dmodel)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Supplies_Inventory_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";
            if (dmodel.WarehouseId > 0)
            {
                where += " and " + nameof(RB_Supplies_Inventory_Extend.WarehouseId) + $" ={dmodel.WarehouseId}";
            }
            if (dmodel.SuppliesId > 0)
            {
                where += " and " + nameof(RB_Supplies_Inventory_Extend.SuppliesId) + $" ={dmodel.SuppliesId}";
            }
            if (!string.IsNullOrEmpty(dmodel.WarehouseIdStr)) {
                where += " and " + nameof(RB_Supplies_Inventory_Extend.WarehouseId) + $" in({dmodel.WarehouseIdStr})";
            }
            if (!string.IsNullOrEmpty(dmodel.SuppliesIdStr))
            {
                where += " and " + nameof(RB_Supplies_Inventory_Extend.SuppliesId) + $" in({dmodel.SuppliesIdStr})";
            }

            string sql = $@" select * from RB_Supplies_Inventory {where} order by Id desc";
            return Get<RB_Supplies_Inventory_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public int GetSafetyStockWarningCount(RB_Supplies_Inventory_Extend dmodel)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND si.{0}={1}", nameof(RB_Supplies_Inventory_Extend.Status), 0);
            where += $@" and si.RB_Group_Id={dmodel.RB_Group_Id}";
            where += $@" and si.Number<IFNULL(sm.SafetyStock,0)";

            string sql = $@" select count(0) as Number
from RB_Supplies_Inventory si
left join rb_supplies_material sm on si.SuppliesId=sm.Id
{where} order by si.Id desc";
            return Get<RB_Supplies_Inventory_Extend>(sql).FirstOrDefault()?.Number ?? 0;
        }

        /// <summary>
        /// 获取库存日志
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Supplies_InventoryDetail_Extend> GetInventoryDetailPageList(int pageIndex, int pageSize, RB_Supplies_Inventory_Extend dmodel, out long count)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND sid.{0}={1}", nameof(RB_Supplies_Inventory_Extend.Status), 0);
            where += $@" and sid.RB_Group_Id={dmodel.RB_Group_Id}";
            if (dmodel.WarehouseId > 0)
            {
                where += " and si." + nameof(RB_Supplies_Inventory_Extend.WarehouseId) + $" ={dmodel.WarehouseId}";
            }
            if (dmodel.SuppliesId > 0)
            {
                where += " and si." + nameof(RB_Supplies_Inventory_Extend.SuppliesId) + $" ={dmodel.SuppliesId}";
            }

            string sql = $@" select sid.* from RB_Supplies_Inventory si
left join rb_supplies_inventorydetail sid on si.Id=sid.InventoryId
{where} order by sid.Id desc";
            return GetPage<RB_Supplies_InventoryDetail_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
