﻿using Mall.Common;
using Mall.Model.Extend.Product;
using Mall.Model.Extend.TradePavilion;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Data;
using System.Text;

namespace Mall.DataHelper.Import
{
    /// <summary>
    /// 品牌导入帮助类
    /// </summary>
    public class BrandHelper
    {
        /// <summary>
        /// 导入模板
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public static List<RB_Brand_Enterprise_Extend> ImportYBBrandData(string fileName,string tempFilePath)
        {
            //图片所在的列
            List<int> imgColList = new List<int>();
            imgColList.Add(2);
            imgColList.Add(3);
            List<RB_Brand_Enterprise_Extend> list = new List<RB_Brand_Enterprise_Extend>();
            Mall.Common.Plugin.ImportExcelNPOIHelper importExcelNPOIHelper = new Common.Plugin.ImportExcelNPOIHelper(tempFilePath);
            DataTable dt = importExcelNPOIHelper.ExcelToDataTable(fileName, 0, 0, true, imgColList: imgColList);
            if (dt != null && dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    list.Add(DataRowToModel(dr));
                }
            }
            return list;
        }

        /// <summary>
        /// DataRow转实体
        /// </summary>
        /// <param name="dr"></param>
        /// <returns></returns>
        public static RB_Brand_Enterprise_Extend DataRowToModel(DataRow dr)
        {
            RB_Brand_Enterprise_Extend model = new RB_Brand_Enterprise_Extend();
            if (dr != null)
            {
                if (dr.Table.Columns.Contains("品牌名称") && !string.IsNullOrEmpty(dr["品牌名称"].ToString().Trim()))
                {
                    model.BrandName = dr["品牌名称"].ToString();
                }
                if (dr.Table.Columns.Contains("Logo") && !string.IsNullOrEmpty(dr["Logo"].ToString().Trim()))
                {
                    model.Logo = dr["Logo"].ToString();
                }
                if (dr.Table.Columns.Contains("介绍图") && !string.IsNullOrEmpty(dr["介绍图"].ToString().Trim()))
                {
                    model.Banner = dr["介绍图"].ToString();
                }
                if (dr.Table.Columns.Contains("品牌视频地址") && !string.IsNullOrEmpty(dr["品牌视频地址"].ToString().Trim()))
                {
                    model.VideoUrl = dr["品牌视频地址"].ToString();
                }

                if (dr.Table.Columns.Contains("品牌分类") && !string.IsNullOrEmpty(dr["品牌分类"].ToString().Trim()))
                {
                    model.CategoryName = dr["品牌分类"].ToString();
                }
                if (dr.Table.Columns.Contains("店铺数量") && !string.IsNullOrEmpty(dr["店铺数量"].ToString().Trim()))
                {
                    Int32.TryParse(dr["店铺数量"].ToString(), out int ShopNum);
                    model.ShopNum = ShopNum;
                }
                if (dr.Table.Columns.Contains("建筑面积(㎡)") && !string.IsNullOrEmpty(dr["建筑面积(㎡)"].ToString().Trim()))
                {
                   var tempArray= dr["建筑面积(㎡)"].ToString().Split('-');
                    if (tempArray != null && tempArray.Length ==2)
                    {
                        decimal.TryParse(tempArray[0].ToString(), out decimal BuiltUpArea);

                        model.BuiltUpArea = BuiltUpArea;

                        decimal.TryParse(tempArray[1].ToString(), out decimal EndBuiltUpArea);
                        model.EndBuiltUpArea = EndBuiltUpArea;
                    }
                }
                if (dr.Table.Columns.Contains("需求面积(㎡)") && !string.IsNullOrEmpty(dr["需求面积(㎡)"].ToString().Trim()))
                {
                    var tempArray = dr["需求面积(㎡)"].ToString().Split('-');
                    if (tempArray != null && tempArray.Length == 2)
                    {
                        decimal.TryParse(tempArray[0].ToString(), out decimal AreaRequirement);
                        model.AreaRequirement = AreaRequirement;

                        decimal.TryParse(tempArray[1].ToString(), out decimal EndAreaRequirement);
                        model.EndAreaRequirement = EndAreaRequirement;
                    }
                }
                if (dr.Table.Columns.Contains("客群定位") && !string.IsNullOrEmpty(dr["客群定位"].ToString().Trim()))
                {
                    model.CustomerType = dr["客群定位"].ToString();
                }
                if (dr.Table.Columns.Contains("品牌定位") && !string.IsNullOrEmpty(dr["品牌定位"].ToString().Trim()))
                {
                    model.BrandType = dr["品牌定位"].ToString();
                }
                if (dr.Table.Columns.Contains("合作条件") && !string.IsNullOrEmpty(dr["合作条件"].ToString().Trim()))
                {
                    model.Cooperation = dr["合作条件"].ToString();
                }
                if (dr.Table.Columns.Contains("物业需求") && !string.IsNullOrEmpty(dr["物业需求"].ToString().Trim()))
                {
                    model.PropertyDemand = dr["物业需求"].ToString();
                }
                if (dr.Table.Columns.Contains("配套需求") && !string.IsNullOrEmpty(dr["配套需求"].ToString().Trim()))
                {
                    model.Complementary = dr["配套需求"].ToString();
                }
                if (dr.Table.Columns.Contains("品牌简介") && !string.IsNullOrEmpty(dr["品牌简介"].ToString().Trim()))
                {
                    model.Introduce = dr["品牌简介"].ToString();
                }
            }
            return model;
        }
    }
}
