﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;
using Mall.Common.Enum.User;
using VT.FW.DB.Dapper;

namespace Mall.Repository.User
{
    /// <summary>
    /// 用户统计仓储层
    /// </summary>
    public partial class RB_User_StatisticsRepository : BaseRepository<RB_User_Statistics>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_User_Statistics_Extend> GetList(RB_User_Statistics_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_User_Statistics.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_User_Statistics.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and {nameof(RB_User_Statistics.Date)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and {nameof(RB_User_Statistics.Date)} <='{dmodel.EndTime} 23:59:59'";
            }

            string sql = $@"select * from RB_User_Statistics where {where} ";
            return Get<RB_User_Statistics_Extend>(sql).ToList();
        }

    }
}
