﻿using Mall.Repository.Product;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Mall.Model.Entity.Product;
using VT.FW.DB;
using Mall.Repository.Coffee;
using Mall.Repository.Education;
using Mall.Model.Extend.Education;
using Mall.Repository.BaseSetUp;
using Mall.Model.Extend.Coffee;
using Mall.Common.Plugin;

namespace Mall.WindowsService.Module
{
    /// <summary>
    /// 咖啡劵处理
    /// </summary>
    public class CoffeeModule
    {
        /// <summary>
        /// 咖啡劵
        /// </summary>
        private static readonly RB_Member_CoffeeCouponsRepository member_CoffeeCouponsRepository = new RB_Member_CoffeeCouponsRepository();
        /// <summary>
        /// 用户关联
        /// </summary>
        private static readonly RB_Education_EduSellRepository education_EduSellRepository = new RB_Education_EduSellRepository();
        /// <summary>
        /// 字典
        /// </summary>
        private static readonly Rb_DictvalueRepository dictvalueRepository = new Rb_DictvalueRepository();
        /// <summary>
        /// 账号
        /// </summary>
        private static readonly RB_AccountRepository accountRepository = new RB_AccountRepository();


        /// <summary>
        /// 更新员工  +  学生 免费咖啡劵
        /// </summary>
        /// <returns></returns>
        public static bool UpdateUserCoffeeFreeNum(int mallBaseId = 5, int groupId = 100000) 
        {
            //注意  更新教育的数据库链接 ******
            try
            {
                int FreeNum = Convert.ToInt32(dictvalueRepository.GetList(new Model.Extend.BaseSetUp.RB_Dictvalue_Extend() { MallBaseId = mallBaseId, DictKey = "Edu_CoffeeCoupons_Free" }).FirstOrDefault()?.Content ?? "0");
                int EmpFreeNum = Convert.ToInt32(dictvalueRepository.GetList(new Model.Extend.BaseSetUp.RB_Dictvalue_Extend() { MallBaseId = mallBaseId, DictKey = "Edu_CoffeeCoupons_EmpFree" }).FirstOrDefault()?.Content ?? "0");
                if (FreeNum > 0 || EmpFreeNum > 0)
                {
                    var empList = accountRepository.GetEmployeeListRepository(new Employee_ViewModel() { Group_Id = groupId, IsLeave = 1 });
                    //学员 只查询 目前还在学习中的
                    var learnStuList = accountRepository.GetStuLearningCourseList();
                    //根据绑定信息  查询出所有已绑定的
                    var ulist = education_EduSellRepository.GetEducationStuList(new RB_Education_EduSell_Extend() { MallBaseId = mallBaseId, IsInitFreeCoffee = 1 }, true);

                    foreach (var item in ulist)
                    {
                        if (item.Type == 1)
                        {
                            int fNum = EmpFreeNum;
                            //员工离职的话  解除绑定
                            var emodel = empList.Where(x => x.Id == item.EduSellId).FirstOrDefault();
                            if (emodel == null)
                            {
                                //不存在了  直接  解除绑定
                                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                                    { nameof(RB_Education_EduSell_Extend.IsInitFreeCoffee), 1}
                                };
                                List<WhereHelper> wheres = new List<WhereHelper>() {
                                    new WhereHelper(){
                                         FiledName = nameof(RB_Education_EduSell_Extend.Id),
                                          FiledValue = item.Id,
                                           OperatorEnum =OperatorEnum.Equal
                                    }
                                };
                                education_EduSellRepository.Update(keyValues, wheres);
                                fNum = 0;//离职 初始化免费数量
                            }
                            //直接更新
                            Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                { nameof(RB_Member_CoffeeCoupons_Extend.FreeNum),fNum }
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                        FiledName = nameof(RB_Member_CoffeeCoupons_Extend.UserId),
                                        FiledValue = item.UserId,
                                        OperatorEnum =OperatorEnum.Equal
                                }
                            };
                            member_CoffeeCouponsRepository.Update(keyValues1, wheres1);
                        }
                        else if (item.Type == 2)
                        {
                            int fNum = FreeNum;
                            //员工离职的话  解除绑定
                            var emodel = learnStuList.Where(x => x.Id == item.EduSellId).FirstOrDefault();
                            if (emodel == null)
                            {
                                //未在学习中了  解除绑定
                                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                                    { nameof(RB_Education_EduSell_Extend.IsInitFreeCoffee), 1}
                                };
                                List<WhereHelper> wheres = new List<WhereHelper>() {
                                    new WhereHelper(){
                                         FiledName = nameof(RB_Education_EduSell_Extend.Id),
                                          FiledValue = item.Id,
                                           OperatorEnum =OperatorEnum.Equal
                                    }
                                };
                                education_EduSellRepository.Update(keyValues, wheres);
                                fNum = 0;//毕业了 初始化免费数量
                            }
                            //直接更新
                            Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                { nameof(RB_Member_CoffeeCoupons_Extend.FreeNum),fNum }
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                        FiledName = nameof(RB_Member_CoffeeCoupons_Extend.UserId),
                                        FiledValue = item.UserId,
                                        OperatorEnum =OperatorEnum.Equal
                                }
                            };
                            member_CoffeeCouponsRepository.Update(keyValues1, wheres1);
                        }
                    }
                }
                return true;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "UpdateUserCoffeeFreeNum");
                return false;
            }
        }
    }
}
