﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Mall.Common.Plugin;
namespace Mall.Common.API.Model
{
    /// <summary>
    /// 动态表单数据
    /// </summary>
    public class FormDataModel
    {
        /// <summary>
        /// 表单类型
        /// </summary>
        public string formType { get; set; }
        /// <summary>
        /// 表单值
        /// </summary>
        public object value { get; set; }
        /// <summary>
        /// 表单名
        /// </summary>
        public string title { get; set; }
        /// <summary>
        /// 占位符
        /// </summary>
        public string placeHolder { get; set; }
        /// <summary>
        /// 图片描述
        /// </summary>
        public string imageDesc { get; set; }
        /// <summary>
        /// 提交表单key值
        /// </summary>
        public string key { get; set; }
        /// <summary>
        /// 枚举值
        /// </summary>
        public object category { get; set; }
        /// <summary>
        /// 是否必填
        /// </summary>
        public bool required { get; set; }
    }
    /// <summary>
    /// 表单类型枚举
    /// </summary>
    public enum FromTypeEnum
    {
        /// <summary>
        /// 单行输入框
        /// </summary>
        [EnumField("textField")]
        textField = 1,
        /// <summary>
        /// 多行输入框
        /// </summary>
        [EnumField("textareaField")]
        TextareaField = 2,
        /// <summary>
        /// 数字输入框
        /// </summary>
        [EnumField("numberField")]
        NumberField = 3,
        /// <summary>
        /// 单选框
        /// </summary>
        [EnumField("selectField")]
        Selectfield = 4,
        /// <summary>
        /// 多选框
        /// </summary>
        [EnumField("multiSelectField")]
        MultiSelectField = 5,
        /// <summary>
        /// 日期时间
        /// </summary>
        [EnumField("dateTimeField")]
        DateTimeField = 6,
        /// <summary>
        /// 图片
        /// </summary>
        [EnumField("imageField")]
        ImageField = 7,
        /// <summary>
        /// 附件
        /// </summary>
        [EnumField("fileField")]
        FileField = 8,
        /// <summary>
        /// 子表单
        /// </summary>
        [EnumField("childField")]
        ChildField = 9,
        /// <summary>
        /// 时长控件
        /// </summary>
        [EnumField("durationField")]
        DurationField = 10,
        /// <summary>
        /// 总时长控件
        /// </summary>
        [EnumField("totalDurationField")]
        TotalDurationField = 11
    }
}
